/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.builder.impl;

import java.util.List;
import java.util.Map;
import org.drools.compiler.builder.DroolsAssemblerContext;
import org.drools.compiler.builder.impl.BuildResultAccumulatorImpl;
import org.drools.compiler.builder.impl.BuilderConfigurationProvider;
import org.drools.compiler.builder.impl.GlobalVariableContext;
import org.drools.compiler.builder.impl.InternalKnowledgeBaseProvider;
import org.drools.compiler.builder.impl.KnowledgeBuilderConfigurationImpl;
import org.drools.compiler.builder.impl.PackageRegistryManagerImpl;
import org.drools.compiler.builder.impl.RootClassLoaderProvider;
import org.drools.compiler.builder.impl.TypeDeclarationBuilder;
import org.drools.compiler.compiler.PackageRegistry;
import org.drools.core.base.ClassObjectType;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.core.rule.TypeDeclaration;
import org.drools.core.spi.ObjectType;
import org.drools.drl.ast.descr.PackageDescr;
import org.drools.kiesession.rulebase.InternalKnowledgeBase;
import org.kie.internal.builder.KnowledgeBuilderErrors;

public class DroolsAssemblerContextImpl
implements DroolsAssemblerContext,
BuilderConfigurationProvider,
InternalKnowledgeBaseProvider,
RootClassLoaderProvider {
    private final KnowledgeBuilderConfigurationImpl knowledgeBuilderConfiguration;
    private final ClassLoader rootClassLoader;
    private final InternalKnowledgeBase kBase;
    private final GlobalVariableContext globalVariableContext;
    private final TypeDeclarationBuilder typeBuilder;
    private final PackageRegistryManagerImpl pkgRegistryManager;
    private final BuildResultAccumulatorImpl buildResultAccumulator;

    public DroolsAssemblerContextImpl(KnowledgeBuilderConfigurationImpl knowledgeBuilderConfiguration, ClassLoader rootClassLoader, InternalKnowledgeBase kBase, GlobalVariableContext globalVariableContext, TypeDeclarationBuilder typeBuilder, PackageRegistryManagerImpl pkgRegistryManager, BuildResultAccumulatorImpl buildResultAccumulator) {
        this.knowledgeBuilderConfiguration = knowledgeBuilderConfiguration;
        this.rootClassLoader = rootClassLoader;
        this.kBase = kBase;
        this.globalVariableContext = globalVariableContext;
        this.typeBuilder = typeBuilder;
        this.pkgRegistryManager = pkgRegistryManager;
        this.buildResultAccumulator = buildResultAccumulator;
    }

    @Override
    public Map<String, Class<?>> getGlobals() {
        return this.globalVariableContext.getGlobals();
    }

    @Override
    public KnowledgeBuilderConfigurationImpl getBuilderConfiguration() {
        return this.knowledgeBuilderConfiguration;
    }

    @Override
    public TypeDeclaration getAndRegisterTypeDeclaration(Class<?> cls, String packageName) {
        TypeDeclaration typeDeclaration;
        InternalKnowledgePackage pkg;
        InternalKnowledgeBase kBase = this.getKnowledgeBase();
        if (kBase != null && (pkg = kBase.getPackage(packageName)) != null && (typeDeclaration = pkg.getTypeDeclaration(cls)) != null) {
            return typeDeclaration;
        }
        return this.typeBuilder.getAndRegisterTypeDeclaration(cls, packageName);
    }

    @Override
    public TypeDeclaration getTypeDeclaration(Class<?> cls) {
        return cls != null ? this.typeBuilder.getTypeDeclaration(cls) : null;
    }

    @Override
    public TypeDeclaration getTypeDeclaration(ObjectType objectType) {
        return objectType.isTemplate() ? this.typeBuilder.getExistingTypeDeclaration(objectType.getClassName()) : this.typeBuilder.getTypeDeclaration(((ClassObjectType)objectType).getClassType());
    }

    @Override
    public ClassLoader getRootClassLoader() {
        return this.rootClassLoader;
    }

    @Override
    public List<PackageDescr> getPackageDescrs(String namespace) {
        return this.pkgRegistryManager.getPackageDescrs(namespace);
    }

    @Override
    public PackageRegistry getPackageRegistry(String packageName) {
        return this.pkgRegistryManager.getPackageRegistry(packageName);
    }

    @Override
    public InternalKnowledgeBase getKnowledgeBase() {
        return this.kBase;
    }

    @Override
    public KnowledgeBuilderErrors getErrors() {
        return this.buildResultAccumulator.getErrors();
    }
}

