/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.builder.impl.processors;

import java.util.HashSet;
import org.drools.compiler.builder.impl.GlobalVariableContext;
import org.drools.compiler.builder.impl.KnowledgeBuilderImpl;
import org.drools.compiler.builder.impl.processors.AbstractPackageCompilationPhase;
import org.drools.compiler.compiler.GlobalError;
import org.drools.compiler.compiler.PackageRegistry;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.drl.ast.descr.GlobalDescr;
import org.drools.drl.ast.descr.PackageDescr;
import org.drools.kiesession.rulebase.InternalKnowledgeBase;
import org.kie.internal.builder.ResourceChange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlobalCompilationPhase
extends AbstractPackageCompilationPhase {
    protected static final transient Logger logger = LoggerFactory.getLogger(GlobalCompilationPhase.class);
    private final InternalKnowledgeBase kBase;
    private final GlobalVariableContext globalVariableContext;
    private final KnowledgeBuilderImpl.AssetFilter assetFilter;

    public GlobalCompilationPhase(PackageRegistry pkgRegistry, PackageDescr packageDescr, InternalKnowledgeBase kBase, GlobalVariableContext globalVariableContext, KnowledgeBuilderImpl.AssetFilter filterAcceptsRemoval) {
        super(pkgRegistry, packageDescr);
        this.kBase = kBase;
        this.globalVariableContext = globalVariableContext;
        this.assetFilter = filterAcceptsRemoval;
    }

    @Override
    public void process() {
        InternalKnowledgePackage pkg = this.pkgRegistry.getPackage();
        HashSet existingGlobals = new HashSet(pkg.getGlobals().keySet());
        for (GlobalDescr global : this.packageDescr.getGlobals()) {
            String identifier = global.getIdentifier();
            existingGlobals.remove(identifier);
            String className = global.getType();
            while (className.indexOf(60) >= 0) {
                className = className.replaceAll("<[^<>]+?>", "");
            }
            try {
                Class clazz = this.pkgRegistry.getTypeResolver().resolveType(className);
                if (clazz.isPrimitive()) {
                    this.results.add(new GlobalError(global, " Primitive types are not allowed in globals : " + className));
                    return;
                }
                pkg.addGlobal(identifier, clazz);
                this.globalVariableContext.addGlobal(identifier, clazz);
                if (this.kBase == null) continue;
                this.kBase.addGlobal(identifier, clazz);
            }
            catch (ClassNotFoundException e) {
                this.results.add(new GlobalError(global, e.getMessage()));
                logger.warn("ClassNotFoundException occured!", (Throwable)e);
            }
        }
        for (String toBeRemoved : existingGlobals) {
            if (this.assetFilter == null || !KnowledgeBuilderImpl.AssetFilter.Action.REMOVE.equals((Object)this.assetFilter.accept(ResourceChange.Type.GLOBAL, pkg.getName(), toBeRemoved))) continue;
            pkg.removeGlobal(toBeRemoved);
            if (this.kBase == null) continue;
            this.kBase.removeGlobal(toBeRemoved);
        }
    }
}

