/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.compiler;

import org.drools.compiler.builder.impl.KnowledgeBuilderConfigurationImpl;
import org.drools.compiler.compiler.DialectCompiletimeRegistry;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.core.rule.DialectRuntimeRegistry;
import org.drools.core.rule.ImportDeclaration;
import org.drools.drl.ast.descr.ImportDescr;
import org.drools.util.TypeResolver;
import org.kie.api.io.Resource;
import org.kie.internal.builder.KnowledgeBuilderConfiguration;

public class PackageRegistry {
    private final InternalKnowledgePackage pkg;
    private String dialect;
    private final DialectRuntimeRegistry dialectRuntimeRegistry;
    private final DialectCompiletimeRegistry dialectCompiletimeRegistry;

    public PackageRegistry(ClassLoader rootClassLoader, KnowledgeBuilderConfiguration pkgConf, InternalKnowledgePackage pkg) {
        this.pkg = pkg;
        KnowledgeBuilderConfigurationImpl buildConfImpl = (KnowledgeBuilderConfigurationImpl)pkgConf.as(KnowledgeBuilderConfigurationImpl.KEY);
        this.dialectCompiletimeRegistry = buildConfImpl.buildDialectRegistry(rootClassLoader, buildConfImpl, this, pkg);
        this.dialectRuntimeRegistry = pkg.getDialectRuntimeRegistry();
        pkg.setClassLoader(rootClassLoader);
    }

    public String getDialect() {
        return this.dialect;
    }

    public void setDialect(String dialect) {
        this.dialect = dialect;
    }

    public InternalKnowledgePackage getPackage() {
        return this.pkg;
    }

    public ClassLoader getPackageClassLoader() {
        return this.getPackage().getPackageClassLoader();
    }

    public DialectRuntimeRegistry getDialectRuntimeRegistry() {
        return this.dialectRuntimeRegistry;
    }

    public DialectCompiletimeRegistry getDialectCompiletimeRegistry() {
        return this.dialectCompiletimeRegistry;
    }

    public void addImport(ImportDescr importDescr) {
        this.registerImport(importDescr.getTarget());
        this.dialectCompiletimeRegistry.addImport(importDescr);
    }

    public void registerImport(String importEntry) {
        this.pkg.addImport(new ImportDeclaration(importEntry));
    }

    public void addStaticImport(ImportDescr importDescr) {
        this.dialectCompiletimeRegistry.addStaticImport(importDescr);
    }

    public TypeResolver getTypeResolver() {
        return this.pkg.getTypeResolver();
    }

    public void compileAll() {
        this.dialectCompiletimeRegistry.compileAll();
    }

    public boolean removeObjectsGeneratedFromResource(Resource resource) {
        return this.pkg.removeObjectsGeneratedFromResource(resource);
    }
}

