/*
 * Decompiled with CFR 0.152.
 */
package org.drools.constraint.parser;

import java.io.IOException;
import org.drools.constraint.parser.Provider;

public class StringProvider
implements Provider {
    private String _string;
    private int _position = 0;
    private final int _size;

    public StringProvider(String string) {
        this._string = string;
        this._size = string.length();
    }

    @Override
    public int read(char[] aDest, int nOfs, int nLen) throws IOException {
        int numCharsOutstandingInString = this._size - this._position;
        if (numCharsOutstandingInString == 0) {
            return -1;
        }
        int numBytesToRead = aDest.length - nOfs;
        if (nLen < numBytesToRead) {
            numBytesToRead = nLen;
        }
        if (numCharsOutstandingInString < numBytesToRead) {
            numBytesToRead = numCharsOutstandingInString;
        }
        this._string.getChars(this._position, this._position + numBytesToRead, aDest, nOfs);
        this._position += numBytesToRead;
        return numBytesToRead;
    }

    @Override
    public void close() {
        this._string = null;
    }
}

