/*
 * Decompiled with CFR 0.152.
 */
package org.drools.decisiontable.model;

import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.drools.decisiontable.model.Condition;
import org.drools.decisiontable.model.Consequence;
import org.drools.decisiontable.model.DRLElement;
import org.drools.decisiontable.model.DRLJavaEmitter;
import org.drools.decisiontable.model.DRLOutput;
import org.drools.decisiontable.model.Duration;

public class Rule
extends DRLElement
implements DRLJavaEmitter {
    private static final int MAX_ROWS = 65535;
    private Integer _salience;
    private String _name;
    private Duration _duration;
    private String _description;
    private String _noLoop;
    private String _activationGroup;
    private List _lhs;
    private List _rhs;
    private int _spreadsheetRow;

    public Rule(String name, Integer salience, int spreadsheetRow) {
        this._name = name;
        this._salience = salience;
        this._description = "";
        this._lhs = new LinkedList();
        this._rhs = new LinkedList();
        this._spreadsheetRow = spreadsheetRow;
    }

    public void addCondition(Condition con) {
        this._lhs.add(con);
    }

    public void addConsequence(Consequence con) {
        this._rhs.add(con);
    }

    public void renderDRL(DRLOutput out) {
        if (this.isCommented()) {
            out.writeLine("#" + this.getComment());
        }
        out.writeLine("rule \"" + this._name + "\"");
        if (this._description != null) {
            out.writeLine("\t" + this._description);
        }
        if (this._salience != null) {
            out.writeLine("\tsalience " + this._salience);
        }
        if (this._activationGroup != null) {
            out.writeLine("\tactivation-group" + this._activationGroup);
        }
        if (this._noLoop != null) {
            out.writeLine("\tno-loop" + this._noLoop);
        }
        if (this._duration != null) {
            out.writeLine("\tduration" + this._duration);
        }
        out.writeLine("\twhen");
        this.renderDRL(this._lhs, out);
        out.writeLine("\tthen");
        this.renderDRL(this._rhs, out);
        out.writeLine("end\n");
    }

    private void renderDRL(List list, DRLOutput out) {
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            DRLJavaEmitter item = (DRLJavaEmitter)iter.next();
            item.renderDRL(out);
        }
    }

    public static int calcSalience(int rowNumber) {
        if (rowNumber > 65535) {
            throw new IllegalArgumentException("That row number is above the max: 65535");
        }
        return 65535 - rowNumber;
    }

    public static String convertColNumToColName(int i) {
        String result;
        int div = i / 26;
        int mod = i % 26;
        if (div == 0) {
            byte[] c = new byte[]{(byte)(mod + 65)};
            result = Rule.byteToString(c);
        } else {
            byte[] firstChar = new byte[]{(byte)(div - 1 + 65)};
            byte[] secondChar = new byte[]{(byte)(mod + 65)};
            String first = Rule.byteToString(firstChar);
            String second = Rule.byteToString(secondChar);
            result = String.valueOf(first) + second;
        }
        return result;
    }

    private static String byteToString(byte[] secondChar) {
        try {
            return new String(secondChar, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Unable to convert char to string.", e);
        }
    }

    public List getConditions() {
        return this._lhs;
    }

    public List getConsequences() {
        return this._rhs;
    }

    public void setSalience(Integer value) {
        this._salience = value;
    }

    public Integer getSalience() {
        return this._salience;
    }

    public void setName(String value) {
        this._name = value;
    }

    public String getName() {
        return this._name;
    }

    public void setDescription(String value) {
        this._description = value;
    }

    public void appendDescription(String value) {
        this._description = String.valueOf(this._description) + value;
    }

    public String getDescription() {
        return this._description;
    }

    public void setDuration(Duration value) {
        this._duration = value;
    }

    public String getDuration() {
        return this._duration.getSnippet();
    }

    public void setActivationrGroup(String value) {
        this._activationGroup = value;
    }

    public String getActivationGroup() {
        return this._activationGroup;
    }

    public void setNoLoop(String value) {
        this._noLoop = value;
    }

    public boolean getNoLoop() {
        String value = "false";
        if (this._noLoop.compareTo("true") != 0) {
            value = this._noLoop;
        }
        Boolean b = new Boolean(value);
        return b;
    }

    public int getSpreadsheetRowNumber() {
        return this._spreadsheetRow;
    }
}

