/*
 * Decompiled with CFR 0.152.
 */
package org.drools.decisiontable.parser.xls;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.eventusermodel.HSSFEventFactory;
import org.apache.poi.hssf.eventusermodel.HSSFListener;
import org.apache.poi.hssf.eventusermodel.HSSFRequest;
import org.apache.poi.hssf.record.BOFRecord;
import org.apache.poi.hssf.record.BoolErrRecord;
import org.apache.poi.hssf.record.BoundSheetRecord;
import org.apache.poi.hssf.record.FormulaRecord;
import org.apache.poi.hssf.record.LabelSSTRecord;
import org.apache.poi.hssf.record.NumberRecord;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RowRecord;
import org.apache.poi.hssf.record.SSTRecord;
import org.apache.poi.hssf.record.formula.Ptg;
import org.apache.poi.hssf.record.formula.Ref3DPtg;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.drools.decisiontable.parser.DecisionTableParseException;
import org.drools.decisiontable.parser.DecisionTableParser;
import org.drools.decisiontable.parser.SheetListener;
import org.drools.decisiontable.parser.xls.NullSheetListener;

public class ExcelParser
implements DecisionTableParser,
HSSFListener {
    public static final String DEFAULT_RULESHEET_NAME = "Decision Tables";
    private static final String WORKBOOK = "Workbook";
    public static final String DATE_TARGET_FORMAT = "dd-MMM-yyyy";
    private Map _listners = new HashMap();
    private SheetListener _currentSheetListener = new NullSheetListener();
    private final List _sheetNames = new ArrayList();
    private int _currentSheetNumber = 0;
    private SSTRecord _sstRec = null;
    private boolean _useFirstSheet = false;
    private HSSFWorkbook _workbook = null;

    public ExcelParser(Map sheetListners) {
        this._listners = sheetListners;
    }

    public ExcelParser(SheetListener listener) {
        this._listners.put(DEFAULT_RULESHEET_NAME, listener);
        this._useFirstSheet = true;
    }

    private void newSheet(String sheetName) {
        this._currentSheetListener.finishSheet();
        this._currentSheetListener = new NullSheetListener();
        if (this._useFirstSheet && this._currentSheetNumber == 1) {
            this._currentSheetListener = this.getFirstSheetListener();
        } else if (this._listners.containsKey(sheetName)) {
            this._currentSheetListener = (SheetListener)this._listners.get(sheetName);
        }
        this._currentSheetListener.startSheet(sheetName);
    }

    private SheetListener getFirstSheetListener() {
        SheetListener listener = (SheetListener)this._listners.values().iterator().next();
        if (listener == null) {
            throw new IllegalStateException("No default first sheet listener found !");
        }
        return listener;
    }

    public void processRecord(Record record) {
        switch (record.getSid()) {
            case 133: {
                BoundSheetRecord bsr = (BoundSheetRecord)record;
                this._sheetNames.add(bsr.getSheetname());
                break;
            }
            case 2057: {
                BOFRecord bof = (BOFRecord)record;
                if (bof.getType() != 16) break;
                this.newSheet((String)this._sheetNames.get(this._currentSheetNumber++));
                break;
            }
            case 520: {
                RowRecord rowRec = (RowRecord)record;
                this._currentSheetListener.newRow(rowRec.getRowNumber(), rowRec.getLastCol() - rowRec.getFirstCol() + 1);
                break;
            }
            case 252: {
                this._sstRec = (SSTRecord)record;
                break;
            }
            case 253: {
                this.handleText(record);
                break;
            }
            case 515: {
                this.handleNumber(record);
                break;
            }
            case 517: {
                this.handleBool(record);
                break;
            }
            case 6: {
                this.handleFormula(record);
                break;
            }
        }
    }

    private void handleFormula(Record record) {
        FormulaRecord formulaRec = (FormulaRecord)record;
        Ptg ptg = formulaRec.peekExpressionToken();
        if (ptg instanceof Ref3DPtg) {
            Ref3DPtg ptg3D = (Ref3DPtg)ptg;
            HSSFSheet sheet = this._workbook.getSheetAt(ptg3D.getExternSheetIndex() + 1);
            HSSFRow row = sheet.getRow((int)ptg3D.getRow());
            HSSFCell cell = row.getCell(ptg3D.getColumn());
            this._currentSheetListener.newCell(formulaRec.getRow(), formulaRec.getColumn(), cell.getStringCellValue());
        }
    }

    private void handleBool(Record record) {
        BoolErrRecord boolRec = (BoolErrRecord)record;
        this._currentSheetListener.newCell(boolRec.getRow(), boolRec.getColumn(), "" + boolRec.getBooleanValue());
    }

    private void handleText(Record record) {
        LabelSSTRecord labelRec = (LabelSSTRecord)record;
        String value = this._sstRec.getString(labelRec.getSSTIndex());
        this._currentSheetListener.newCell(labelRec.getRow(), labelRec.getColumn(), value);
    }

    private void handleNumber(Record record) {
        NumberRecord numRec = (NumberRecord)record;
        String stringVal = null;
        stringVal = "" + numRec.getValue();
        stringVal = ExcelParser.removeTrailingZero(stringVal);
        this._currentSheetListener.newCell(numRec.getRow(), numRec.getColumn(), stringVal);
    }

    static String removeTrailingZero(String stringVal) {
        if (stringVal.endsWith(".0")) {
            stringVal = stringVal.substring(0, stringVal.length() - 2);
        }
        return stringVal;
    }

    public void parseFile(InputStream inStream) {
        DocumentInputStream din = null;
        POIFSFileSystem poifs = null;
        try {
            poifs = new POIFSFileSystem(inStream);
            this._workbook = new HSSFWorkbook(poifs);
            din = poifs.createDocumentInputStream(WORKBOOK);
            HSSFRequest req = new HSSFRequest();
            req.addListenerForAllRecords((HSSFListener)this);
            HSSFEventFactory factory = new HSSFEventFactory();
            factory.processEvents(req, (InputStream)din);
        }
        catch (IOException ex) {
            throw new DecisionTableParseException("Failed to open Excel stream, please check that the content is xls97 format.", ex);
        }
    }
}

