/*
 * Decompiled with CFR 0.152.
 */
package org.drools.decisiontable.model;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.drools.decisiontable.model.DRLJavaEmitter;
import org.drools.decisiontable.model.DRLOutput;
import org.drools.decisiontable.model.Functions;
import org.drools.decisiontable.model.Global;
import org.drools.decisiontable.model.Import;
import org.drools.decisiontable.model.Rule;

public class Package
implements DRLJavaEmitter {
    private String _name;
    private List _imports;
    private List _variables;
    private List _rules;
    private Functions _functions;

    public Package(String string) {
        this._name = string;
        this._imports = new LinkedList();
        this._variables = new LinkedList();
        this._rules = new LinkedList();
        this._functions = new Functions();
    }

    public void addImport(Import import_) {
        this._imports.add(import_);
    }

    public void addVariable(Global global) {
        this._variables.add(global);
    }

    public void addRule(Rule rule) {
        this._rules.add(rule);
    }

    public void addFunctions(String string) {
        this._functions.setFunctionsListing(string);
    }

    public String getName() {
        return this._name;
    }

    public List getImports() {
        return this._imports;
    }

    public List getVariables() {
        return this._variables;
    }

    public List getRules() {
        return this._rules;
    }

    public void renderDRL(DRLOutput dRLOutput) {
        dRLOutput.writeLine("package " + this._name.replace(' ', '_') + ";");
        dRLOutput.writeLine("#generated from Decision Table");
        this.renderDRL(this._imports, dRLOutput);
        this.renderDRL(this._variables, dRLOutput);
        this._functions.renderDRL(dRLOutput);
        this.renderDRL(this._rules, dRLOutput);
    }

    private void renderDRL(List list, DRLOutput dRLOutput) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            DRLJavaEmitter dRLJavaEmitter = (DRLJavaEmitter)iterator.next();
            dRLJavaEmitter.renderDRL(dRLOutput);
        }
    }
}

