/*
 * Decompiled with CFR 0.152.
 */
package org.drools.decisiontable.parser;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.drools.decisiontable.model.Condition;
import org.drools.decisiontable.model.Consequence;
import org.drools.decisiontable.model.Duration;
import org.drools.decisiontable.model.Global;
import org.drools.decisiontable.model.Import;
import org.drools.decisiontable.model.Package;
import org.drools.decisiontable.model.Rule;
import org.drools.decisiontable.parser.ActionType;
import org.drools.decisiontable.parser.DecisionTableParseException;
import org.drools.decisiontable.parser.RuleSheetParserUtil;
import org.drools.decisiontable.parser.SheetListener;
import org.drools.decisiontable.parser.xls.PropertiesSheetListener;

public class RuleSheetListener
implements SheetListener {
    public static final String FUNCTIONS_TAG = "Functions";
    public static final String IMPORT_TAG = "Import";
    public static final String SEQUENTIAL_FLAG = "Sequential";
    public static final String VARIABLES_TAG = "Variables";
    public static final String RULE_TABLE_TAG = "RuleTable";
    public static final String RULESET_TAG = "RuleSet";
    private static final int ACTION_ROW = 1;
    private static final int CODE_ROW = 2;
    private static final int LABEL_ROW = 3;
    private boolean _isInRuleTable = false;
    private int _ruleRow;
    private int _ruleStartColumn;
    private int _ruleStartRow;
    private Rule _currentRule;
    private String _currentRulePrefix;
    private boolean _currentSequentialFlag = false;
    private Map _actions;
    private final HashMap _cellComments = new HashMap();
    private final List _ruleList = new LinkedList();
    private final PropertiesSheetListener _propertiesListner = new PropertiesSheetListener();

    public Properties getProperties() {
        return this._propertiesListner.getProperties();
    }

    public Package getRuleSet() {
        if (this._ruleList.isEmpty()) {
            throw new DecisionTableParseException("No RuleTable's were found in spreadsheet.");
        }
        Package package_ = this.buildRuleSet();
        return package_;
    }

    private Package buildRuleSet() {
        String string = this.getProperties().getProperty(RULESET_TAG, "rule_table");
        Package package_ = new Package(string);
        Object object = this._ruleList.iterator();
        while (object.hasNext()) {
            package_.addRule((Rule)object.next());
        }
        object = RuleSheetParserUtil.getImportList(this.getProperties().getProperty(IMPORT_TAG));
        Object object2 = object.iterator();
        while (object2.hasNext()) {
            package_.addImport((Import)object2.next());
        }
        object2 = RuleSheetParserUtil.getVariableList(this.getProperties().getProperty(VARIABLES_TAG));
        Object object3 = object2.iterator();
        while (object3.hasNext()) {
            package_.addVariable((Global)object3.next());
        }
        object3 = this.getProperties().getProperty(FUNCTIONS_TAG);
        package_.addFunctions((String)object3);
        return package_;
    }

    public void startSheet(String string) {
    }

    public void finishSheet() {
        this._propertiesListner.finishSheet();
        this.finishRuleTable();
    }

    public void newRow(int n, int n2) {
    }

    public void newCell(int n, int n2, String string) {
        if (this.isCellValueEmpty(string)) {
            return;
        }
        if (this._isInRuleTable) {
            this.processRuleCell(n, n2, string);
        } else {
            this.processNonRuleCell(n, n2, string);
        }
    }

    private void initRuleTable(int n, int n2, String string) {
        this._isInRuleTable = true;
        this._actions = new HashMap();
        this._ruleStartColumn = n2;
        this._ruleStartRow = n;
        this._ruleRow = n + 3 + 1;
        this._currentRulePrefix = RuleSheetParserUtil.getRuleName(string);
        this._currentSequentialFlag = this.getSequentialFlag();
        this._currentRule = this.createNewRuleForRow(this._ruleRow);
        this._ruleList.add(this._currentRule);
    }

    private boolean getSequentialFlag() {
        String string = this.getProperties().getProperty(SEQUENTIAL_FLAG);
        return RuleSheetParserUtil.isStringMeaningTrue(string);
    }

    private void finishRuleTable() {
        if (this._isInRuleTable) {
            this._currentSequentialFlag = false;
            this._isInRuleTable = false;
        }
    }

    private void processNonRuleCell(int n, int n2, String string) {
        if (string.startsWith(RULE_TABLE_TAG)) {
            this.initRuleTable(n, n2, string);
        } else {
            this._propertiesListner.newCell(n, n2, string);
        }
    }

    private void processRuleCell(int n, int n2, String string) {
        if (string.startsWith(RULE_TABLE_TAG)) {
            this.finishRuleTable();
            this.initRuleTable(n, n2, string);
            return;
        }
        if (n2 < this._ruleStartColumn) {
            return;
        }
        if (n == this._ruleStartRow) {
            return;
        }
        switch (n - this._ruleStartRow) {
            case 1: {
                ActionType.addNewActionType(this._actions, string, n2, n);
                break;
            }
            case 2: {
                this.codeRow(n, n2, string);
                break;
            }
            case 3: {
                this.labelRow(n, n2, string);
                break;
            }
            default: {
                this.nextRule(n, n2, string);
            }
        }
    }

    private void codeRow(int n, int n2, String string) {
        ActionType actionType = this.getActionForColumn(n, n2);
        if (string.trim().equals("") && (actionType.type == 1 || actionType.type == 0)) {
            throw new DecisionTableParseException("Code description - row:" + (n + 1) + " cell number:" + (n2 + 1) + " - does not contain any code specification. It should !");
        }
        actionType.value = string;
    }

    private void labelRow(int n, int n2, String string) {
        ActionType actionType = this.getActionForColumn(n, n2);
        if (!(string.trim().equals("") || actionType.type != 1 && actionType.type != 0)) {
            this._cellComments.put(new Integer(n2), string);
        } else {
            this._cellComments.put(new Integer(n2), "From column: " + Rule.convertColNumToColName(n2));
        }
    }

    private ActionType getActionForColumn(int n, int n2) {
        ActionType actionType = (ActionType)this._actions.get(new Integer(n2));
        if (actionType == null) {
            throw new DecisionTableParseException("Code description - row number:" + (n + 1) + " cell number:" + (n2 + 1) + " - does not have an 'ACTION' or 'CONDITION' column header.");
        }
        return actionType;
    }

    private void nextRule(int n, int n2, String string) {
        ActionType actionType = this.getActionForColumn(n, n2);
        if (n - this._ruleRow > 1) {
            this.finishRuleTable();
            this.processNonRuleCell(n, n2, string);
            return;
        }
        if (n > this._ruleRow) {
            this._currentRule = this.createNewRuleForRow(n);
            this._ruleList.add(this._currentRule);
            ++this._ruleRow;
        }
        if (actionType.type == 2 && !this._currentSequentialFlag) {
            this._currentRule.setSalience(new Integer(string));
        } else if (actionType.type == 4) {
            this._currentRule.setName(string);
        } else if (actionType.type == 5) {
            this._currentRule.setDescription(string);
        } else if (actionType.type == 7) {
            this._currentRule.setActivationrGroup(string);
        } else if (actionType.type == 6) {
            this._currentRule.setNoLoop(string);
        } else if (actionType.type == 3) {
            this.createDuration(n2, string, actionType);
        } else if (actionType.type == 0) {
            this.createCondition(n2, string, actionType);
        } else if (actionType.type == 1) {
            this.createConsequence(n2, string, actionType);
        }
    }

    private Rule createNewRuleForRow(int n) {
        Integer n2 = null;
        if (this._currentSequentialFlag) {
            n2 = new Integer(Rule.calcSalience(n));
        }
        int n3 = n + 1;
        String string = this._currentRulePrefix + "_" + n3;
        Rule rule = new Rule(string, n2, n3);
        rule.setComment("From row number: " + n3);
        return rule;
    }

    private void createCondition(int n, String string, ActionType actionType) {
        Condition condition = new Condition();
        condition.setSnippet(actionType.getSnippet(string));
        condition.setComment(this.cellComment(n));
        this._currentRule.addCondition(condition);
    }

    private void createDuration(int n, String string, ActionType actionType) {
        Duration duration = new Duration();
        duration.setSnippet(string);
        duration.setComment(this.cellComment(n));
        this._currentRule.setDuration(duration);
    }

    private void createConsequence(int n, String string, ActionType actionType) {
        Consequence consequence = new Consequence();
        consequence.setSnippet(actionType.getSnippet(string));
        consequence.setComment(this.cellComment(n));
        this._currentRule.addConsequence(consequence);
    }

    private boolean isCellValueEmpty(String string) {
        return string == null || "".equals(string.trim());
    }

    private String cellComment(int n) {
        return "From column: " + Rule.convertColNumToColName(n);
    }
}

