/*
 * Decompiled with CFR 0.152.
 */
package org.drools.decisiontable.parser.csv;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import org.drools.decisiontable.parser.DecisionTableParseException;
import org.drools.decisiontable.parser.DecisionTableParser;
import org.drools.decisiontable.parser.SheetListener;
import org.drools.decisiontable.parser.csv.CsvLineParser;

public class CsvParser
implements DecisionTableParser {
    private SheetListener _listener;
    private CsvLineParser _lineParser;

    public CsvParser(SheetListener sheetListener, CsvLineParser csvLineParser) {
        this._listener = sheetListener;
        this._lineParser = csvLineParser;
    }

    public void parseFile(InputStream inputStream) {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        try {
            this._listener.startSheet("csv");
            this.processRows(bufferedReader);
            this._listener.finishSheet();
        }
        catch (IOException iOException) {
            throw new DecisionTableParseException("An error occurred reading the CSV data.", iOException);
        }
    }

    private void processRows(BufferedReader bufferedReader) throws IOException {
        String string = bufferedReader.readLine();
        int n = 0;
        while (string != null) {
            List list = this._lineParser.parse(string);
            this._listener.newRow(n, list.size());
            for (int i = 0; i < list.size(); ++i) {
                String string2 = (String)list.get(i);
                this._listener.newCell(n, i, string2);
            }
            ++n;
            string = bufferedReader.readLine();
        }
    }

    private void trimCells(List list) {
        for (int i = list.size() - 1; i > 0; --i) {
            String string = (String)list.get(i);
            if (!string.trim().equals("")) {
                return;
            }
            list.remove(i);
        }
    }
}

