/*
 * Decompiled with CFR 0.152.
 */
package org.drools.decisiontable.parser.xls;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.eventusermodel.HSSFEventFactory;
import org.apache.poi.hssf.eventusermodel.HSSFListener;
import org.apache.poi.hssf.eventusermodel.HSSFRequest;
import org.apache.poi.hssf.record.BOFRecord;
import org.apache.poi.hssf.record.BoolErrRecord;
import org.apache.poi.hssf.record.BoundSheetRecord;
import org.apache.poi.hssf.record.FormulaRecord;
import org.apache.poi.hssf.record.LabelSSTRecord;
import org.apache.poi.hssf.record.NumberRecord;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RowRecord;
import org.apache.poi.hssf.record.SSTRecord;
import org.apache.poi.hssf.record.formula.Ptg;
import org.apache.poi.hssf.record.formula.Ref3DPtg;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.drools.decisiontable.parser.DecisionTableParseException;
import org.drools.decisiontable.parser.DecisionTableParser;
import org.drools.decisiontable.parser.SheetListener;
import org.drools.decisiontable.parser.xls.NullSheetListener;

public class ExcelParser
implements DecisionTableParser,
HSSFListener {
    public static final String DEFAULT_RULESHEET_NAME = "Decision Tables";
    private static final String WORKBOOK = "Workbook";
    public static final String DATE_TARGET_FORMAT = "dd-MMM-yyyy";
    private Map _listners = new HashMap();
    private SheetListener _currentSheetListener = new NullSheetListener();
    private final List _sheetNames = new ArrayList();
    private int _currentSheetNumber = 0;
    private SSTRecord _sstRec = null;
    private boolean _useFirstSheet = false;
    private HSSFWorkbook _workbook = null;

    public ExcelParser(Map map) {
        this._listners = map;
    }

    public ExcelParser(SheetListener sheetListener) {
        this._listners.put(DEFAULT_RULESHEET_NAME, sheetListener);
        this._useFirstSheet = true;
    }

    private void newSheet(String string) {
        this._currentSheetListener.finishSheet();
        this._currentSheetListener = new NullSheetListener();
        if (this._useFirstSheet && this._currentSheetNumber == 1) {
            this._currentSheetListener = this.getFirstSheetListener();
        } else if (this._listners.containsKey(string)) {
            this._currentSheetListener = (SheetListener)this._listners.get(string);
        }
        this._currentSheetListener.startSheet(string);
    }

    private SheetListener getFirstSheetListener() {
        SheetListener sheetListener = (SheetListener)this._listners.values().iterator().next();
        if (sheetListener == null) {
            throw new IllegalStateException("No default first sheet listener found !");
        }
        return sheetListener;
    }

    public void processRecord(Record record) {
        switch (record.getSid()) {
            case 133: {
                BoundSheetRecord boundSheetRecord = (BoundSheetRecord)record;
                this._sheetNames.add(boundSheetRecord.getSheetname());
                break;
            }
            case 2057: {
                BOFRecord bOFRecord = (BOFRecord)record;
                if (bOFRecord.getType() != 16) break;
                this.newSheet((String)this._sheetNames.get(this._currentSheetNumber++));
                break;
            }
            case 520: {
                RowRecord rowRecord = (RowRecord)record;
                this._currentSheetListener.newRow(rowRecord.getRowNumber(), rowRecord.getLastCol() - rowRecord.getFirstCol() + 1);
                break;
            }
            case 252: {
                this._sstRec = (SSTRecord)record;
                break;
            }
            case 253: {
                this.handleText(record);
                break;
            }
            case 515: {
                this.handleNumber(record);
                break;
            }
            case 517: {
                this.handleBool(record);
                break;
            }
            case 6: {
                this.handleFormula(record);
                break;
            }
        }
    }

    private void handleFormula(Record record) {
        FormulaRecord formulaRecord = (FormulaRecord)record;
        Ptg ptg = formulaRecord.peekExpressionToken();
        if (ptg instanceof Ref3DPtg) {
            Ref3DPtg ref3DPtg = (Ref3DPtg)ptg;
            HSSFSheet hSSFSheet = this._workbook.getSheetAt(ref3DPtg.getExternSheetIndex() + 1);
            HSSFRow hSSFRow = hSSFSheet.getRow((int)ref3DPtg.getRow());
            HSSFCell hSSFCell = hSSFRow.getCell(ref3DPtg.getColumn());
            this._currentSheetListener.newCell(formulaRecord.getRow(), formulaRecord.getColumn(), "" + hSSFCell.getStringCellValue());
        }
    }

    private void handleBool(Record record) {
        BoolErrRecord boolErrRecord = (BoolErrRecord)record;
        this._currentSheetListener.newCell(boolErrRecord.getRow(), boolErrRecord.getColumn(), "" + boolErrRecord.getBooleanValue());
    }

    private void handleText(Record record) {
        LabelSSTRecord labelSSTRecord = (LabelSSTRecord)record;
        String string = this._sstRec.getString(labelSSTRecord.getSSTIndex());
        this._currentSheetListener.newCell(labelSSTRecord.getRow(), labelSSTRecord.getColumn(), string);
    }

    private void handleNumber(Record record) {
        NumberRecord numberRecord = (NumberRecord)record;
        String string = null;
        string = "" + numberRecord.getValue();
        string = ExcelParser.removeTrailingZero(string);
        this._currentSheetListener.newCell(numberRecord.getRow(), numberRecord.getColumn(), "" + string);
    }

    static String removeTrailingZero(String string) {
        if (string.endsWith(".0")) {
            string = string.substring(0, string.length() - 2);
        }
        return string;
    }

    public void parseFile(InputStream inputStream) {
        DocumentInputStream documentInputStream = null;
        POIFSFileSystem pOIFSFileSystem = null;
        try {
            pOIFSFileSystem = new POIFSFileSystem(inputStream);
            this._workbook = new HSSFWorkbook(pOIFSFileSystem);
            documentInputStream = pOIFSFileSystem.createDocumentInputStream(WORKBOOK);
            HSSFRequest hSSFRequest = new HSSFRequest();
            hSSFRequest.addListenerForAllRecords((HSSFListener)this);
            HSSFEventFactory hSSFEventFactory = new HSSFEventFactory();
            hSSFEventFactory.processEvents(hSSFRequest, (InputStream)documentInputStream);
        }
        catch (IOException iOException) {
            throw new DecisionTableParseException("Failed to open Excel stream, please check that the content is xls97 format.", iOException);
        }
    }
}

