/*
 * Decompiled with CFR 0.152.
 */
package org.drools.decisiontable.parser;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.drools.decisiontable.model.Condition;
import org.drools.decisiontable.model.Consequence;
import org.drools.decisiontable.model.Rule;
import org.drools.decisiontable.model.SnippetBuilder;
import org.drools.decisiontable.parser.DefaultRuleSheetListener;

public class RuleMatrixSheetListener
extends DefaultRuleSheetListener {
    public static final String AGENDAGROUP_TAG = "AgendaGroup";
    public static final String PRECONDITION_TAG = "Precondition";
    public static final String ACTION_TAG = "Action";
    public static final String HORIZONTALCONDITION_TAG = "HorizontalCondition";
    public static final String VERTICALCONDITION_TAG = "VerticalCondition";
    private int ruleTableRow;
    private int ruleTableColumn;
    private String _currentAgendaGroup;
    private Condition _currentPrecondition;
    private String _action;
    private String _horizontalCondition;
    private String _verticalCondition;
    private List _horizontalConditions = new ArrayList();
    private Condition _currentVerticalCondition;
    private boolean isInRuleTable;
    private Rule firstRule;

    public void newCell(int n, int n2, String string, int n3) {
        if (!this.isInRuleTable) {
            super.newCell(n, n2, string, n3);
            return;
        }
        if (StringUtils.isEmpty((String)string)) {
            return;
        }
        if (n == this.ruleTableRow && n2 > this.ruleTableColumn) {
            this._horizontalConditions.add(this.createCondition(string, this._horizontalCondition));
        } else if (n > this.ruleTableRow && n2 == this.ruleTableColumn) {
            this._currentVerticalCondition = this.createCondition(string, this._verticalCondition);
        } else if (n > this.ruleTableRow && n2 > this.ruleTableColumn) {
            this.createRule(n, n2, string);
        }
    }

    private void createRule(int n, int n2, String string) {
        Rule rule = this.firstRule;
        if (rule == null) {
            rule = new Rule("rule_" + n + "_" + n2, null, n);
            this.addRule(rule);
        } else {
            this.firstRule = null;
            rule.setName("rule_" + n + "_" + n2);
        }
        rule.setAgendaGroup(this._currentAgendaGroup);
        rule.addCondition(this._currentPrecondition);
        rule.addCondition(this._currentVerticalCondition);
        rule.addCondition((Condition)this._horizontalConditions.get(n2 - (this.ruleTableColumn + 1)));
        rule.addConsequence(this.createConsequence(string));
    }

    private Consequence createConsequence(String string) {
        SnippetBuilder snippetBuilder = new SnippetBuilder(this._action);
        String string2 = snippetBuilder.build(string);
        Consequence consequence = new Consequence();
        consequence.setSnippet(string2);
        return consequence;
    }

    private Condition createCondition(String string, String string2) {
        SnippetBuilder snippetBuilder = new SnippetBuilder(string2);
        String string3 = snippetBuilder.build(string);
        Condition condition = new Condition();
        condition.setSnippet(string3);
        return condition;
    }

    public void newRow(int n, int n2) {
    }

    public void finishSheet() {
    }

    protected void postInitRuleTable(int n, int n2, String string) {
        this.firstRule = this.getCurrentRule();
    }

    protected void preInitRuleTable(int n, int n2, String string) {
        this.ruleTableColumn = n2;
        this.ruleTableRow = n;
        this.isInRuleTable = true;
        this._currentAgendaGroup = this.getProperties().getProperty(AGENDAGROUP_TAG, null);
        this._action = this.getProperties().getProperty(ACTION_TAG);
        this._horizontalCondition = this.getProperties().getProperty(HORIZONTALCONDITION_TAG);
        this._verticalCondition = this.getProperties().getProperty(VERTICALCONDITION_TAG);
        String string2 = this.getProperties().getProperty(PRECONDITION_TAG, null);
        if (string2 != null) {
            this._currentPrecondition = new Condition();
            this._currentPrecondition.setSnippet(string2);
        }
    }
}

