/*
 * Decompiled with CFR 0.152.
 */
package org.drools.decisiontable.parser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.drools.decisiontable.model.Condition;
import org.drools.decisiontable.model.Consequence;
import org.drools.decisiontable.model.DRLElement;
import org.drools.decisiontable.model.Duration;
import org.drools.decisiontable.model.Global;
import org.drools.decisiontable.model.Import;
import org.drools.decisiontable.model.Package;
import org.drools.decisiontable.model.Rule;
import org.drools.decisiontable.parser.ActionType;
import org.drools.decisiontable.parser.DecisionTableParseException;
import org.drools.decisiontable.parser.LhsBuilder;
import org.drools.decisiontable.parser.RhsBuilder;
import org.drools.decisiontable.parser.RuleSheetListener;
import org.drools.decisiontable.parser.RuleSheetParserUtil;
import org.drools.decisiontable.parser.SourceBuilder;
import org.drools.decisiontable.parser.xls.PropertiesSheetListener;

public class DefaultRuleSheetListener
implements RuleSheetListener {
    public static final String FUNCTIONS_TAG = "Functions";
    public static final String IMPORT_TAG = "Import";
    public static final String SEQUENTIAL_FLAG = "Sequential";
    public static final String VARIABLES_TAG = "Variables";
    public static final String RULE_TABLE_TAG = "RuleTable";
    public static final String RULESET_TAG = "RuleSet";
    private static final int ACTION_ROW = 1;
    private static final int OBJECT_TYPE_ROW = 2;
    private static final int CODE_ROW = 3;
    private static final int LABEL_ROW = 4;
    private boolean _isInRuleTable = false;
    private int _ruleRow;
    private int _ruleStartColumn;
    private int _ruleStartRow;
    private Rule _currentRule;
    private String _currentRulePrefix;
    private boolean _currentSequentialFlag = false;
    private Map _actions;
    private final HashMap _cellComments = new HashMap();
    private final List _ruleList = new LinkedList();
    private List sourceBuilders = new ArrayList();
    private final PropertiesSheetListener _propertiesListner = new PropertiesSheetListener();
    private final org.drools.rule.Package defaultPackage;

    public DefaultRuleSheetListener() {
        this(null);
    }

    public DefaultRuleSheetListener(org.drools.rule.Package pkg) {
        this.defaultPackage = pkg;
    }

    public Properties getProperties() {
        return this._propertiesListner.getProperties();
    }

    public Package getRuleSet() {
        if (this._ruleList.isEmpty()) {
            throw new DecisionTableParseException("No RuleTable's were found in spreadsheet.");
        }
        Package ruleset = this.buildRuleSet();
        return ruleset;
    }

    protected void addRule(Rule newRule) {
        this._ruleList.add(newRule);
    }

    private Package buildRuleSet() {
        String defaultPackageName = this.defaultPackage != null ? this.defaultPackage.getName() : "rule_table";
        String rulesetName = this.getProperties().getProperty(RULESET_TAG, defaultPackageName);
        Package ruleset = new Package(rulesetName);
        Iterator it = this._ruleList.iterator();
        while (it.hasNext()) {
            ruleset.addRule((Rule)it.next());
        }
        List importList = RuleSheetParserUtil.getImportList(this.getProperties().getProperty(IMPORT_TAG));
        Iterator it2 = importList.iterator();
        while (it2.hasNext()) {
            ruleset.addImport((Import)it2.next());
        }
        List variableList = RuleSheetParserUtil.getVariableList(this.getProperties().getProperty(VARIABLES_TAG));
        Iterator it3 = variableList.iterator();
        while (it3.hasNext()) {
            ruleset.addVariable((Global)it3.next());
        }
        String functions = this.getProperties().getProperty(FUNCTIONS_TAG);
        ruleset.addFunctions(functions);
        return ruleset;
    }

    public void startSheet(String name) {
    }

    public void finishSheet() {
        this._propertiesListner.finishSheet();
        this.finishRuleTable();
        this.flushRule();
    }

    public void newRow(int rowNumber, int columns) {
        if (this._currentRule != null) {
            this.flushRule();
        }
    }

    private void flushRule() {
        Iterator iter = this.sourceBuilders.iterator();
        while (iter.hasNext()) {
            DRLElement con;
            SourceBuilder src = (SourceBuilder)iter.next();
            if (!src.hasValues()) continue;
            if (src instanceof LhsBuilder) {
                con = new Condition();
                ((Condition)con).setSnippet(src.getResult());
                this._currentRule.addCondition((Condition)con);
            } else if (src instanceof RhsBuilder) {
                con = new Consequence();
                ((Consequence)con).setSnippet(src.getResult());
                this._currentRule.addConsequence((Consequence)con);
            }
            src.clearValues();
        }
    }

    public void newCell(int row, int column, String value, int mergedColStart) {
        if (this.isCellValueEmpty(value)) {
            return;
        }
        if (this._isInRuleTable && row == this._ruleStartRow) {
            return;
        }
        if (this._isInRuleTable) {
            this.processRuleCell(row, column, value, mergedColStart);
        } else {
            this.processNonRuleCell(row, column, value);
        }
    }

    private void initRuleTable(int row, int column, String value) {
        this.preInitRuleTable(row, column, value);
        this._isInRuleTable = true;
        this._actions = new HashMap();
        this.sourceBuilders = new ArrayList();
        this._ruleStartColumn = column;
        this._ruleStartRow = row;
        this._ruleRow = row + 4 + 1;
        this._currentRulePrefix = RuleSheetParserUtil.getRuleName(value);
        this._currentSequentialFlag = this.getSequentialFlag();
        this._currentRule = this.createNewRuleForRow(this._ruleRow);
        this._ruleList.add(this._currentRule);
        this.postInitRuleTable(row, column, value);
    }

    protected void preInitRuleTable(int row, int column, String value) {
    }

    protected Rule getCurrentRule() {
        return this._currentRule;
    }

    protected void postInitRuleTable(int row, int column, String value) {
    }

    private boolean getSequentialFlag() {
        String seqFlag = this.getProperties().getProperty(SEQUENTIAL_FLAG);
        return RuleSheetParserUtil.isStringMeaningTrue(seqFlag);
    }

    private void finishRuleTable() {
        if (this._isInRuleTable) {
            this._currentSequentialFlag = false;
            this._isInRuleTable = false;
        }
    }

    private void processNonRuleCell(int row, int column, String value) {
        if (value.startsWith(RULE_TABLE_TAG)) {
            this.initRuleTable(row, column, value);
        } else {
            this._propertiesListner.newCell(row, column, value, -1);
        }
    }

    private void processRuleCell(int row, int column, String value, int mergedColStart) {
        if (value.startsWith(RULE_TABLE_TAG)) {
            this.finishRuleTable();
            this.initRuleTable(row, column, value);
            return;
        }
        if (column < this._ruleStartColumn) {
            return;
        }
        if (row == this._ruleStartRow) {
            return;
        }
        switch (row - this._ruleStartRow) {
            case 1: {
                ActionType.addNewActionType(this._actions, value, column, row);
                break;
            }
            case 2: {
                this.objectTypeRow(row, column, value, mergedColStart);
                break;
            }
            case 3: {
                this.codeRow(row, column, value);
                break;
            }
            case 4: {
                this.labelRow(row, column, value);
                break;
            }
            default: {
                this.nextDataCell(row, column, value);
            }
        }
    }

    private void objectTypeRow(int row, int column, String value, int mergedColStart) {
        if (value.indexOf("$param") > -1 || value.indexOf("$1") > -1) {
            throw new DecisionTableParseException("It looks like you have snippets in the row that is meant for column declarations. Please insert an additional row before the snippets. Row number: " + (row + 1));
        }
        ActionType action = this.getActionForColumn(row, column);
        if (mergedColStart == -1) {
            if (action.type == 0) {
                LhsBuilder src = new LhsBuilder(value);
                action.setSourceBuilder(src);
                this.sourceBuilders.add(src);
            } else if (action.type == 1) {
                RhsBuilder src = new RhsBuilder(value);
                action.setSourceBuilder(src);
                this.sourceBuilders.add(src);
            }
        } else if (column == mergedColStart) {
            if (action.type == 0) {
                action.setSourceBuilder(new LhsBuilder(value));
                this.sourceBuilders.add(action.getSourceBuilder());
            } else if (action.type == 1) {
                action.setSourceBuilder(new RhsBuilder(value));
                this.sourceBuilders.add(action.getSourceBuilder());
            }
        } else {
            ActionType startOfMergeAction = this.getActionForColumn(row, mergedColStart);
            action.setSourceBuilder(startOfMergeAction.getSourceBuilder());
        }
    }

    private void codeRow(int row, int column, String value) {
        ActionType actionType = this.getActionForColumn(row, column);
        if (actionType.getSourceBuilder() == null) {
            if (actionType.type == 0) {
                actionType.setSourceBuilder(new LhsBuilder(null));
                this.sourceBuilders.add(actionType.getSourceBuilder());
            } else if (actionType.type == 1) {
                actionType.setSourceBuilder(new RhsBuilder(null));
                this.sourceBuilders.add(actionType.getSourceBuilder());
            } else if (actionType.type == 2) {
                actionType.setSourceBuilder(new LhsBuilder(null));
                this.sourceBuilders.add(actionType.getSourceBuilder());
            }
        }
        if (value.trim().equals("") && (actionType.type == 1 || actionType.type == 0)) {
            throw new DecisionTableParseException("Code description - row:" + (row + 1) + " cell number:" + (column + 1) + " - does not contain any code specification. It should !");
        }
        actionType.addTemplate(column, value);
    }

    private void labelRow(int row, int column, String value) {
        ActionType actionType = this.getActionForColumn(row, column);
        if (!(value.trim().equals("") || actionType.type != 1 && actionType.type != 0)) {
            this._cellComments.put(new Integer(column), value);
        } else {
            this._cellComments.put(new Integer(column), "From column: " + Rule.convertColNumToColName(column));
        }
    }

    private ActionType getActionForColumn(int row, int column) {
        ActionType actionType = (ActionType)this._actions.get(new Integer(column));
        if (actionType == null) {
            throw new DecisionTableParseException("Code description - row number:" + (row + 1) + " cell number:" + (column + 1) + " - does not have an 'ACTION' or 'CONDITION' column header.");
        }
        return actionType;
    }

    private void nextDataCell(int row, int column, String value) {
        ActionType actionType = this.getActionForColumn(row, column);
        if (row - this._ruleRow > 1) {
            this.finishRuleTable();
            this.processNonRuleCell(row, column, value);
            return;
        }
        if (row > this._ruleRow) {
            this._currentRule = this.createNewRuleForRow(row);
            this._ruleList.add(this._currentRule);
            ++this._ruleRow;
        }
        if (actionType.type == 2 && !this._currentSequentialFlag) {
            this._currentRule.setSalience(new Integer(value));
        } else if (actionType.type == 4) {
            this._currentRule.setName(value);
        } else if (actionType.type == 5) {
            this._currentRule.setDescription(value);
        } else if (actionType.type == 7) {
            this._currentRule.setActivationGroup(value);
        } else if (actionType.type == 6) {
            this._currentRule.setNoLoop(value);
        } else if (actionType.type == 3) {
            this.createDuration(column, value, actionType);
        } else if (actionType.type == 0 || actionType.type == 1) {
            actionType.addCellValue(column, value);
        }
    }

    private Rule createNewRuleForRow(int row) {
        Integer salience = null;
        if (this._currentSequentialFlag) {
            salience = new Integer(Rule.calcSalience(row));
        }
        int spreadsheetRow = row + 1;
        String name = this._currentRulePrefix + "_" + spreadsheetRow;
        Rule rule = new Rule(name, salience, spreadsheetRow);
        rule.setComment("From row number: " + spreadsheetRow);
        return rule;
    }

    private void createDuration(int column, String value, ActionType actionType) {
        Duration dur = new Duration();
        dur.setSnippet(value);
        dur.setComment(this.cellComment(column));
        this._currentRule.setDuration(dur);
    }

    private boolean isCellValueEmpty(String value) {
        return value == null || "".equals(value.trim());
    }

    private String cellComment(int column) {
        return "From column: " + Rule.convertColNumToColName(column);
    }
}

