/*
 * Decompiled with CFR 0.152.
 */
package org.drools.decisiontable.parser;

import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.drools.RuleBase;
import org.drools.RuleBaseFactory;
import org.drools.StatefulSession;
import org.drools.compiler.PackageBuilder;
import org.drools.decisiontable.model.Condition;
import org.drools.decisiontable.model.Consequence;
import org.drools.decisiontable.model.DRLOutput;
import org.drools.decisiontable.model.Global;
import org.drools.decisiontable.model.Import;
import org.drools.decisiontable.model.Package;
import org.drools.decisiontable.model.Rule;
import org.drools.decisiontable.model.SnippetBuilder;
import org.drools.decisiontable.parser.DefaultGenerator;
import org.drools.decisiontable.parser.RuleTemplate;
import org.drools.decisiontable.parser.TemplateContainer;
import org.drools.decisiontable.parser.TemplateRuleBase;

public class DefaultTemplateRuleBase
implements TemplateRuleBase {
    private RuleBase ruleBase;

    public DefaultTemplateRuleBase(TemplateContainer tc) {
        this.ruleBase = this.readRule(this.getDTRules(tc.getTemplates()));
    }

    public StatefulSession newStatefulSession() {
        return this.ruleBase.newStatefulSession();
    }

    private String getDTRules(Map templates) {
        Package p = new Package("org.drools.decisiontable.parser");
        this.addImports(p);
        this.addGlobals(p);
        int i = 1;
        Iterator it = templates.values().iterator();
        while (it.hasNext()) {
            RuleTemplate template = (RuleTemplate)it.next();
            this.createTemplateRule(p, i++, template);
        }
        DRLOutput out = new DRLOutput();
        p.renderDRL(out);
        return out.getDRL();
    }

    private void createTemplateRule(Package p, int index, RuleTemplate template) {
        Rule rule = new Rule(template.getName(), null, index);
        Condition condition = new Condition();
        condition.setSnippet("r : Row()");
        rule.addCondition(condition);
        this.createColumnConditions(template, rule);
        this.createNotColumnConditions(template, rule);
        rule.addConsequence(this.createConsequence(template));
        p.addRule(rule);
    }

    private void createNotColumnConditions(RuleTemplate template, Rule rule) {
        String[] templateNotColumns = template.getNotColumns();
        for (int j = 0; j < templateNotColumns.length; ++j) {
            rule.addCondition(this.createNotCondition(templateNotColumns[j]));
        }
    }

    private void createColumnConditions(RuleTemplate template, Rule rule) {
        List templateColumns = template.getColumns();
        Iterator it1 = templateColumns.iterator();
        while (it1.hasNext()) {
            String column = (String)it1.next();
            rule.addCondition(this.createCondition(column));
        }
    }

    private void addGlobals(Package p) {
        Global global = new Global();
        global.setClassName(DefaultGenerator.class.getName());
        global.setIdentifier("generator");
        p.addVariable(global);
    }

    private void addImports(Package p) {
        Import drlImport1 = new Import();
        drlImport1.setClassName(Map.class.getName());
        Import drlImport2 = new Import();
        drlImport2.setClassName(HashMap.class.getName());
        p.addImport(drlImport1);
        p.addImport(drlImport2);
    }

    private Consequence createConsequence(RuleTemplate template) {
        StringBuffer action = new StringBuffer();
        action.append("generator.generate( \"");
        action.append(template.getName()).append("\", r);");
        Consequence consequence = new Consequence();
        consequence.setSnippet(action.toString());
        return consequence;
    }

    private Condition createCondition(String value) {
        SnippetBuilder snip = new SnippetBuilder("Cell(row == r, column == \"$param\")");
        String result = snip.build(value);
        Condition condition = new Condition();
        condition.setSnippet(result);
        return condition;
    }

    private Condition createNotCondition(String value) {
        SnippetBuilder snip = new SnippetBuilder("not Cell(row == r, column == \"$param\")");
        String result = snip.build(value);
        Condition condition = new Condition();
        condition.setSnippet(result);
        return condition;
    }

    private RuleBase readRule(String drl) {
        try {
            System.out.println(drl);
            StringReader source = new StringReader(drl);
            PackageBuilder builder = new PackageBuilder();
            builder.addPackageFromDrl((Reader)source);
            org.drools.rule.Package pkg = builder.getPackage();
            RuleBase ruleBase = RuleBaseFactory.newRuleBase();
            ruleBase.addPackage(pkg);
            return ruleBase;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

