/*
 * Decompiled with CFR 0.152.
 */
package org.drools.decisiontable.parser;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.drools.util.StringUtils;

public class RuleTemplate {
    private String name;
    private String contents;
    private List columns;
    private List notColumns;

    public RuleTemplate(String n) {
        this.name = n;
        this.columns = new ArrayList();
        this.notColumns = new ArrayList();
    }

    public String getName() {
        return this.name;
    }

    public List getColumns() {
        return this.columns;
    }

    public String[] getNotColumns() {
        return this.notColumns.toArray(new String[this.notColumns.size()]);
    }

    public String getContents() {
        return this.contents;
    }

    public void addColumn(String column) {
        if (column.startsWith("!")) {
            this.notColumns.add(column.substring(1));
        } else {
            this.columns.add(column);
        }
    }

    public void setContents(String contents) {
        this.contents = this.replaceOptionals(contents);
    }

    public String toString() {
        return "RuleTemplate[name," + this.name + "notColumns," + this.notColumns + "contents," + this.columns + "columns";
    }

    private String replaceOptionals(String contents) {
        try {
            Pattern pattern = Pattern.compile("@\\{(.[^}]*)\\}");
            ArrayList<String> columns = new ArrayList<String>(this.getColumns());
            columns.add("row.rowNumber");
            BufferedReader reader = new BufferedReader(new StringReader(contents));
            String line = null;
            StringBuffer newLine = new StringBuffer();
            while ((line = reader.readLine()) != null) {
                Matcher matcher = pattern.matcher(line);
                int optCols = 0;
                while (matcher.find()) {
                    String c = matcher.group(1);
                    if (columns.contains(c)) continue;
                    newLine.append("@if{").append(matcher.group(1)).append(" != null} ");
                    ++optCols;
                }
                newLine.append(line);
                newLine.append(StringUtils.repeat((String)" @end{}", (int)optCols));
                newLine.append("\n");
            }
            return newLine.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

