/*
 * Decompiled with CFR 0.152.
 */
package org.drools.decisiontable.parser;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.drools.decisiontable.parser.DefaultTemplateColumn;
import org.drools.decisiontable.parser.TemplateColumn;
import org.drools.decisiontable.parser.TemplateContainer;
import org.drools.util.StringUtils;

public class RuleTemplate {
    private String name;
    private String contents;
    private List columns;
    private TemplateContainer templateContainer;

    public RuleTemplate(String n, TemplateContainer tc) {
        this.name = n;
        this.columns = new ArrayList();
        this.templateContainer = tc;
    }

    public String getName() {
        return this.name;
    }

    public List getColumns() {
        return this.columns;
    }

    public String getContents() {
        return this.contents;
    }

    public void addColumn(String columnString) {
        DefaultTemplateColumn column = new DefaultTemplateColumn(this.templateContainer, columnString);
        this.columns.add(column);
    }

    public void setContents(String contents) {
        this.contents = this.replaceOptionals(contents);
    }

    public String toString() {
        return "RuleTemplate[name," + this.name + "contents," + this.columns + "columns";
    }

    private String replaceOptionals(String contents) {
        try {
            Pattern pattern = Pattern.compile("@\\{(.[^}]*)\\}");
            Collection columns = this.getColumnNames();
            columns.add("row.rowNumber");
            BufferedReader reader = new BufferedReader(new StringReader(contents));
            String line = null;
            StringBuffer newLine = new StringBuffer();
            while ((line = reader.readLine()) != null) {
                Matcher matcher = pattern.matcher(line);
                int optCols = 0;
                while (matcher.find()) {
                    String c = matcher.group(1);
                    if (columns.contains(c)) continue;
                    newLine.append("@if{").append(matcher.group(1)).append(" != null}");
                    ++optCols;
                }
                newLine.append(line);
                newLine.append(StringUtils.repeat((String)"@end{}", (int)optCols));
                newLine.append("\n");
            }
            return newLine.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Collection getColumnNames() {
        ArrayList<String> columnNames = new ArrayList<String>();
        Iterator it = this.getColumns().iterator();
        while (it.hasNext()) {
            TemplateColumn column = (TemplateColumn)it.next();
            columnNames.add(column.getName());
        }
        return columnNames;
    }
}

