/*
 * Decompiled with CFR 0.152.
 */
package org.drools.decisiontable.parser;

import java.util.Map;
import org.drools.StatefulSession;
import org.drools.decisiontable.parser.ArrayColumn;
import org.drools.decisiontable.parser.Cell;
import org.drools.decisiontable.parser.Column;
import org.drools.decisiontable.parser.Row;
import org.drools.util.StringUtils;

public class ArrayCell
implements Cell {
    Row row;
    String value;
    ArrayColumn column;
    private String[] values;

    public ArrayCell(Row r, ArrayColumn c) {
        this.row = r;
        this.column = c;
    }

    public void addValue(Map vars) {
        for (int i = 0; i < this.values.length; ++i) {
            vars.put(this.column.getName() + i, this.values[i]);
        }
    }

    public Column getColumn() {
        return this.column;
    }

    public Row getRow() {
        return this.row;
    }

    public String getValue() {
        return this.value;
    }

    public void insert(StatefulSession session) {
        session.insert((Object)this);
        for (int i = 0; i < this.values.length; ++i) {
            Cell cell = this.column.getType().createCell(this.row);
            cell.setValue(this.values[i]);
            cell.setIndex(i);
            cell.insert(session);
        }
    }

    public void setIndex(int i) {
        throw new RuntimeException("You cannot call setIndex on an ArrayCell");
    }

    public int getIndex() {
        return -1;
    }

    public void setValue(String v) {
        this.value = v;
        this.values = StringUtils.splitPreserveAllTokens((String)this.value, (String)",");
    }

    public boolean isEmpty() {
        return StringUtils.isEmpty((String)this.value);
    }
}

