/*
 * Decompiled with CFR 0.152.
 */
package org.drools.decisiontable;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.drools.decisiontable.InputType;
import org.drools.decisiontable.parser.DecisionTableParser;
import org.drools.decisiontable.parser.DefaultRuleSheetListener;
import org.drools.decisiontable.parser.RuleSheetListener;
import org.drools.decisiontable.parser.xls.ExcelParser;
import org.drools.template.model.DRLOutput;
import org.drools.template.model.Package;
import org.drools.template.parser.DataListener;

public class SpreadsheetCompiler {
    public String compile(boolean showPackage, InputStream xlsStream, InputType type) {
        return this.compile(xlsStream, type, new DefaultRuleSheetListener(showPackage));
    }

    public String compile(InputStream xlsStream, InputType type) {
        return this.compile(xlsStream, type, new DefaultRuleSheetListener());
    }

    public String compile(InputStream xlsStream, InputType type, RuleSheetListener listener) {
        DecisionTableParser parser = type.createParser(listener);
        parser.parseFile(xlsStream);
        Package rulePackage = listener.getRuleSet();
        DRLOutput out = new DRLOutput();
        rulePackage.renderDRL(out);
        return out.getDRL();
    }

    public String compile(String classPathResource, InputType inputType) {
        InputStream stream = this.getClass().getResourceAsStream(classPathResource);
        try {
            String drl;
            String string = drl = this.compile(stream, inputType);
            return string;
        }
        finally {
            this.closeStream(stream);
        }
    }

    public String compile(InputStream stream, String worksheetName) {
        RuleSheetListener listener = this.getRuleSheetListener(stream, worksheetName);
        Package rulePackage = listener.getRuleSet();
        DRLOutput out = new DRLOutput();
        rulePackage.renderDRL(out);
        return out.getDRL();
    }

    private RuleSheetListener getRuleSheetListener(InputStream stream, String worksheetName) {
        DefaultRuleSheetListener listener = new DefaultRuleSheetListener();
        HashMap<String, List<DataListener>> sheetListeners = new HashMap<String, List<DataListener>>();
        ArrayList<DefaultRuleSheetListener> listeners = new ArrayList<DefaultRuleSheetListener>();
        listeners.add(listener);
        sheetListeners.put(worksheetName, listeners);
        ExcelParser parser = new ExcelParser(sheetListeners);
        parser.parseFile(stream);
        return listener;
    }

    private void closeStream(InputStream stream) {
        try {
            stream.close();
        }
        catch (Exception e) {
            System.err.print("WARNING: Wasn't able to correctly close stream for decision table. " + e.getMessage());
        }
    }
}

