/*
 * Decompiled with CFR 0.152.
 */
package org.drools.decisiontable.parser.xls;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellValue;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.ss.util.CellRangeAddress;
import org.drools.decisiontable.parser.DecisionTableParser;
import org.drools.template.parser.DataListener;
import org.drools.template.parser.DecisionTableParseException;

public class ExcelParser
implements DecisionTableParser {
    public static final String DEFAULT_RULESHEET_NAME = "Decision Tables";
    private Map<String, List<DataListener>> _listeners = new HashMap<String, List<DataListener>>();
    private boolean _useFirstSheet;

    public ExcelParser(Map<String, List<DataListener>> sheetListeners) {
        this._listeners = sheetListeners;
    }

    public ExcelParser(List<DataListener> sheetListeners) {
        this._listeners.put(DEFAULT_RULESHEET_NAME, sheetListeners);
        this._useFirstSheet = true;
    }

    public ExcelParser(DataListener listener) {
        ArrayList<DataListener> listeners = new ArrayList<DataListener>();
        listeners.add(listener);
        this._listeners.put(DEFAULT_RULESHEET_NAME, listeners);
        this._useFirstSheet = true;
    }

    @Override
    public void parseFile(InputStream inStream) {
        try {
            Workbook workbook = WorkbookFactory.create((InputStream)inStream);
            if (this._useFirstSheet) {
                Sheet sheet = workbook.getSheetAt(0);
                this.processSheet(sheet, this._listeners.get(DEFAULT_RULESHEET_NAME));
            } else {
                for (String sheetName : this._listeners.keySet()) {
                    Sheet sheet = workbook.getSheet(sheetName);
                    if (sheet == null) {
                        throw new IllegalStateException("Could not find the sheetName (" + sheetName + ") in the workbook sheetNames.");
                    }
                    this.processSheet(sheet, this._listeners.get(sheetName));
                }
            }
        }
        catch (InvalidFormatException e) {
            throw new DecisionTableParseException("An error occurred opening the workbook. It is possible that the encoding of the document did not match the encoding of the reader.", (Throwable)e);
        }
        catch (IOException e) {
            throw new DecisionTableParseException("Failed to open Excel stream, please check that the content is xls97 format.", (Throwable)e);
        }
    }

    private CellRangeAddress[] getMergedCells(Sheet sheet) {
        CellRangeAddress[] ranges = new CellRangeAddress[sheet.getNumMergedRegions()];
        for (int i = 0; i < ranges.length; ++i) {
            ranges[i] = sheet.getMergedRegion(i);
        }
        return ranges;
    }

    private void processSheet(Sheet sheet, List<? extends DataListener> listeners) {
        int maxRows = sheet.getLastRowNum();
        CellRangeAddress[] mergedRanges = this.getMergedCells(sheet);
        DataFormatter formatter = new DataFormatter();
        FormulaEvaluator formulaEvaluator = sheet.getWorkbook().getCreationHelper().createFormulaEvaluator();
        for (int i = 0; i <= maxRows; ++i) {
            Row row = sheet.getRow(i);
            int lastCellNum = row != null ? row.getLastCellNum() : 0;
            this.newRow(listeners, i, lastCellNum);
            block5: for (int cellNum = 0; cellNum < lastCellNum; ++cellNum) {
                Cell cell = row.getCell(cellNum);
                if (cell == null) continue;
                double num = 0.0;
                CellRangeAddress merged = this.getRangeIfMerged(cell, mergedRanges);
                if (merged != null) {
                    Cell topLeft = sheet.getRow(merged.getFirstRow()).getCell(merged.getFirstColumn());
                    this.newCell(listeners, i, cellNum, formatter.formatCellValue(topLeft), topLeft.getColumnIndex());
                    continue;
                }
                switch (cell.getCellType()) {
                    case 2: {
                        CellValue cv = formulaEvaluator.evaluate(cell);
                        String cellValue = this.getCellValue(cv);
                        this.newCell(listeners, i, cellNum, cellValue, -1);
                        continue block5;
                    }
                    case 0: {
                        num = cell.getNumericCellValue();
                    }
                    default: {
                        if (num - (double)Math.round(num) != 0.0) {
                            this.newCell(listeners, i, cellNum, String.valueOf(num), -1);
                            continue block5;
                        }
                        this.newCell(listeners, i, cellNum, formatter.formatCellValue(cell), -1);
                    }
                }
            }
        }
        this.finishSheet(listeners);
    }

    private String getCellValue(CellValue cv) {
        switch (cv.getCellType()) {
            case 4: {
                return Boolean.toString(cv.getBooleanValue());
            }
            case 0: {
                return String.valueOf(cv.getNumberValue());
            }
        }
        return cv.getStringValue();
    }

    CellRangeAddress getRangeIfMerged(Cell cell, CellRangeAddress[] mergedRanges) {
        for (int i = 0; i < mergedRanges.length; ++i) {
            CellRangeAddress r = mergedRanges[i];
            if (!r.isInRange(cell.getRowIndex(), cell.getColumnIndex())) continue;
            return r;
        }
        return null;
    }

    private void finishSheet(List<? extends DataListener> listeners) {
        for (DataListener dataListener : listeners) {
            dataListener.finishSheet();
        }
    }

    private void newRow(List<? extends DataListener> listeners, int row, int cols) {
        for (DataListener dataListener : listeners) {
            dataListener.newRow(row, cols);
        }
    }

    public void newCell(List<? extends DataListener> listeners, int row, int column, String value, int mergedColStart) {
        for (DataListener dataListener : listeners) {
            dataListener.newCell(row, column, value, mergedColStart);
        }
    }
}

