/*
 * Decompiled with CFR 0.152.
 */
package org.drools.drl.ast.descr;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.drools.drl.ast.descr.AndDescr;
import org.drools.drl.ast.descr.AnnotatedBaseDescr;
import org.drools.drl.ast.descr.AttributeDescr;
import org.drools.drl.ast.descr.UnitDescr;
import org.kie.api.io.Resource;

public class RuleDescr
extends AnnotatedBaseDescr {
    private static final long serialVersionUID = 510L;
    private String name;
    private String parentName;
    private String documentation;
    private Map<String, AttributeDescr> attributes;
    private UnitDescr unit;
    private AndDescr lhs;
    private Object consequence;
    private Map<String, Object> namedConsequence;
    private int consequenceLine;
    private int consequencePattern;
    private int offset;
    private String className;
    private int loadOrder;
    private List<String> errors;

    public RuleDescr() {
        this(null, "");
    }

    public RuleDescr(String name) {
        this(name, "");
    }

    public RuleDescr(String ruleName, String documentation) {
        this.name = ruleName;
        this.documentation = documentation;
        this.attributes = new LinkedHashMap<String, AttributeDescr>();
        this.namedConsequence = new HashMap<String, Object>();
        this.lhs = new AndDescr();
        this.consequence = "";
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.name = (String)in.readObject();
        this.parentName = (String)in.readObject();
        this.documentation = (String)in.readObject();
        this.consequence = in.readObject();
        this.namedConsequence = (Map)in.readObject();
        this.lhs = (AndDescr)in.readObject();
        this.consequenceLine = in.readInt();
        this.consequencePattern = in.readInt();
        this.offset = in.readInt();
        this.attributes = (Map)in.readObject();
        this.className = (String)in.readObject();
        this.loadOrder = in.readInt();
        this.unit = (UnitDescr)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.name);
        out.writeObject(this.parentName);
        out.writeObject(this.documentation);
        out.writeObject(this.consequence);
        out.writeObject(this.namedConsequence);
        out.writeObject(this.lhs);
        out.writeInt(this.consequenceLine);
        out.writeInt(this.consequencePattern);
        out.writeInt(this.offset);
        out.writeObject(this.attributes);
        out.writeObject(this.className);
        out.writeInt(this.loadOrder);
        out.writeObject(this.unit);
    }

    public UnitDescr getUnit() {
        return this.unit;
    }

    public void setUnit(UnitDescr unit) {
        this.unit = unit;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDialect() {
        AttributeDescr dialect = this.attributes.get("dialect");
        return dialect != null ? dialect.getValue() : null;
    }

    public String getSalience() {
        AttributeDescr salience = this.attributes.get("salience");
        return salience != null ? salience.getValue() : null;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getDocumentation() {
        return this.documentation;
    }

    public Map<String, AttributeDescr> getAttributes() {
        return this.attributes;
    }

    public void addAttribute(AttributeDescr attribute) {
        if (attribute != null) {
            if (this.attributes.containsKey(attribute.getName())) {
                this.addError("Duplicate attribute definition: " + attribute.getName());
            } else {
                this.attributes.put(attribute.getName(), attribute);
            }
        }
    }

    public AndDescr getLhs() {
        return this.lhs;
    }

    public void setLhs(AndDescr lhs) {
        this.lhs = lhs;
    }

    public Object getConsequence() {
        return this.consequence;
    }

    public void setConsequence(Object consequence) {
        this.consequence = consequence;
    }

    public Map<String, Object> getNamedConsequences() {
        return this.namedConsequence;
    }

    public void addNamedConsequences(String name, Object consequence) {
        if (this.namedConsequence.containsKey(name)) {
            this.addError("Duplicate consequence name: " + name);
        } else {
            this.namedConsequence.put(name, consequence);
        }
    }

    private void addError(String message) {
        if (this.errors == null) {
            this.errors = new ArrayList<String>();
        }
        this.errors.add(message);
    }

    public void setConsequenceLocation(int line, int pattern) {
        this.consequenceLine = line;
        this.consequencePattern = pattern;
    }

    public void setConsequenceOffset(int offset) {
        this.offset = offset;
    }

    public int getConsequenceOffset() {
        return this.offset;
    }

    public int getConsequenceLine() {
        return this.consequenceLine;
    }

    public int getConsequencePattern() {
        return this.consequencePattern;
    }

    public String getEnabled() {
        AttributeDescr enabled = this.attributes.get("enabled");
        return enabled != null ? enabled.getValue() : null;
    }

    public boolean hasParent() {
        return this.parentName != null;
    }

    public void setParentName(String parentName) {
        this.parentName = parentName;
    }

    public String getParentName() {
        return this.parentName;
    }

    public boolean isRule() {
        return true;
    }

    public boolean isQuery() {
        return false;
    }

    public List<String> getErrors() {
        return this.errors;
    }

    public boolean hasErrors() {
        return this.errors != null;
    }

    public int getLoadOrder() {
        return this.loadOrder;
    }

    public void setLoadOrder(int loadOrder) {
        this.loadOrder = loadOrder;
    }

    @Override
    public void setResource(Resource resource) {
        super.setResource(resource);
        this.lhs.setResource(resource);
    }

    public String toString() {
        return "[Rule name='" + this.name + "']";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.attributes == null ? 0 : this.attributes.hashCode());
        result = 31 * result + (this.className == null ? 0 : this.className.hashCode());
        result = 31 * result + (this.consequence == null ? 0 : this.consequence.hashCode());
        result = 31 * result + this.consequenceLine;
        result = 31 * result + this.consequencePattern;
        result = 31 * result + this.loadOrder;
        result = 31 * result + (this.documentation == null ? 0 : this.documentation.hashCode());
        result = 31 * result + (this.errors == null ? 0 : this.errors.hashCode());
        result = 31 * result + (this.lhs == null ? 0 : this.lhs.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.namedConsequence == null ? 0 : this.namedConsequence.hashCode());
        result = 31 * result + this.offset;
        result = 31 * result + (this.parentName == null ? 0 : this.parentName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RuleDescr other = (RuleDescr)obj;
        if (this.attributes == null ? other.attributes != null : !this.attributes.equals(other.attributes)) {
            return false;
        }
        if (this.className == null ? other.className != null : !this.className.equals(other.className)) {
            return false;
        }
        if (this.consequence == null ? other.consequence != null : !this.consequence.equals(other.consequence)) {
            return false;
        }
        if (this.consequenceLine != other.consequenceLine) {
            return false;
        }
        if (this.consequencePattern != other.consequencePattern) {
            return false;
        }
        if (this.loadOrder != other.loadOrder) {
            return false;
        }
        if (this.documentation == null ? other.documentation != null : !this.documentation.equals(other.documentation)) {
            return false;
        }
        if (this.errors == null ? other.errors != null : !this.errors.equals(other.errors)) {
            return false;
        }
        if (this.lhs == null ? other.lhs != null : !this.lhs.equals(other.lhs)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.namedConsequence == null ? other.namedConsequence != null : !this.namedConsequence.equals(other.namedConsequence)) {
            return false;
        }
        if (this.offset != other.offset) {
            return false;
        }
        return !(this.parentName == null ? other.parentName != null : !this.parentName.equals(other.parentName));
    }
}

