/*
 * Decompiled with CFR 0.152.
 */
package org.drools.drl.parser;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import org.drools.drl.ast.descr.PackageDescr;
import org.drools.drl.parser.DRLFactory;
import org.drools.drl.parser.DroolsError;
import org.drools.drl.parser.DroolsParserException;
import org.drools.drl.parser.ParserError;
import org.drools.drl.parser.antlr4.DRL10ParserWrapper;
import org.drools.drl.parser.antlr4.DRLParserError;
import org.drools.drl.parser.lang.DRLLexer;
import org.drools.drl.parser.lang.DRLParser;
import org.drools.drl.parser.lang.DroolsSentence;
import org.drools.drl.parser.lang.Expander;
import org.drools.drl.parser.lang.ExpanderException;
import org.drools.drl.parser.lang.Location;
import org.drools.drl.parser.lang.dsl.DefaultExpanderResolver;
import org.drools.io.InternalResource;
import org.kie.api.io.Resource;
import org.kie.internal.builder.conf.LanguageLevelOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DrlParser {
    private static final Logger LOG = LoggerFactory.getLogger(DrlParser.class);
    private static final String GENERIC_ERROR_MESSAGE = "Unexpected exception raised while parsing. This is a bug. Please contact the Development team :\n";
    private static final String DEBUG_PARSER_LOG = "parse : ANTLR4_PARSER_ENABLED = {}, languageLevel = {}";
    private final List<DroolsError> results = new ArrayList<DroolsError>();
    private List<DroolsSentence> editorSentences = null;
    private Location location = new Location(0);
    private DRLLexer lexer = null;
    private Resource resource = null;
    public static final String ANTLR4_PARSER_ENABLED_PROPERTY = "drools.drl.antlr4.parser.enabled";
    public static final boolean ANTLR4_PARSER_ENABLED = Boolean.parseBoolean(System.getProperty("drools.drl.antlr4.parser.enabled", "false"));
    public static final LanguageLevelOption DEFAULT_LANGUAGE_LEVEL = ANTLR4_PARSER_ENABLED ? LanguageLevelOption.DRL10 : LanguageLevelOption.DRL6;
    private final LanguageLevelOption languageLevel;

    public DrlParser() {
        this(DEFAULT_LANGUAGE_LEVEL);
    }

    public DrlParser(LanguageLevelOption languageLevel) {
        this.languageLevel = languageLevel;
        if (languageLevel == LanguageLevelOption.DRL5 || languageLevel == LanguageLevelOption.DRL6_STRICT) {
            LOG.warn("{} is deprecated and will be removed in future versions. Please use the default {} or newly introduced {} instead.", new Object[]{languageLevel, LanguageLevelOption.DRL6, LanguageLevelOption.DRL10});
        }
    }

    public PackageDescr parse(Resource resource, String text) throws DroolsParserException {
        this.resource = resource;
        return this.parse(false, text);
    }

    public PackageDescr parse(boolean isEditor, String text) throws DroolsParserException {
        LOG.debug(DEBUG_PARSER_LOG, (Object)ANTLR4_PARSER_ENABLED, (Object)this.languageLevel);
        if (this.languageLevel == LanguageLevelOption.DRL10) {
            return this.compileWithAntlr4Parser(parser -> parser.parse(new StringReader(text)));
        }
        this.lexer = DRLFactory.buildLexer(text, this.languageLevel);
        DRLParser parser2 = DRLFactory.buildParser(this.lexer, this.languageLevel);
        return this.compile(isEditor, parser2);
    }

    public PackageDescr parse(boolean isEditor, Reader reader) throws DroolsParserException {
        LOG.debug(DEBUG_PARSER_LOG, (Object)ANTLR4_PARSER_ENABLED, (Object)this.languageLevel);
        if (this.languageLevel == LanguageLevelOption.DRL10) {
            return this.compileWithAntlr4Parser(parser -> parser.parse(reader));
        }
        this.lexer = DRLFactory.buildLexer(reader, this.languageLevel);
        DRLParser parser2 = DRLFactory.buildParser(this.lexer, this.languageLevel);
        return this.compile(isEditor, parser2);
    }

    public PackageDescr parse(Resource resource, Reader reader) throws DroolsParserException {
        this.resource = resource;
        return this.parse(false, reader);
    }

    public PackageDescr parse(Reader reader) throws DroolsParserException {
        return this.parse(false, reader);
    }

    public PackageDescr parse(Reader drl, Reader dsl) throws DroolsParserException, IOException {
        return this.parse(false, drl, dsl);
    }

    public PackageDescr parse(boolean isEditor, Reader drl, Reader dsl) throws DroolsParserException, IOException {
        StringBuilder text = this.getDRLText(drl);
        return this.parse(text.toString(), dsl);
    }

    public PackageDescr parse(boolean isEditor, String source, Reader dsl) throws DroolsParserException {
        DefaultExpanderResolver resolver = this.getDefaultResolver(dsl);
        Expander expander = resolver.get("*", null);
        String expanded = expander.expand(source);
        if (expander.hasErrors()) {
            this.results.addAll(expander.getErrors());
        }
        return this.parse(isEditor, expanded);
    }

    public PackageDescr parse(String source, Reader dsl) throws DroolsParserException {
        return this.parse(false, source, dsl);
    }

    public PackageDescr parse(Resource resource) throws DroolsParserException, IOException {
        return this.parse(false, resource);
    }

    public PackageDescr parse(Resource resource, InputStream is) throws DroolsParserException, IOException {
        return this.parse(false, resource, is);
    }

    public PackageDescr parse(boolean isEditor, Resource resource) throws DroolsParserException, IOException {
        try (InputStream is = resource.getInputStream();){
            PackageDescr packageDescr = this.parse(isEditor, resource, is);
            return packageDescr;
        }
    }

    public PackageDescr parse(boolean isEditor, Resource resource, InputStream is) throws DroolsParserException, IOException {
        this.resource = resource;
        String encoding = resource instanceof InternalResource ? ((InternalResource)resource).getEncoding() : null;
        LOG.debug(DEBUG_PARSER_LOG, (Object)ANTLR4_PARSER_ENABLED, (Object)this.languageLevel);
        if (this.languageLevel == LanguageLevelOption.DRL10) {
            return this.compileWithAntlr4Parser(parser -> parser.parse(is, encoding));
        }
        this.lexer = DRLFactory.buildLexer(is, encoding, this.languageLevel);
        DRLParser parser2 = DRLFactory.buildParser(this.lexer, this.languageLevel);
        return this.compile(isEditor, parser2);
    }

    private PackageDescr compileWithAntlr4Parser(Function<DRL10ParserWrapper, PackageDescr> packageDescrFunction) throws DroolsParserException {
        try {
            DRL10ParserWrapper parser = new DRL10ParserWrapper(this.resource);
            PackageDescr packageDescr = packageDescrFunction.apply(parser);
            for (DRLParserError drlParserError : parser.getErrors()) {
                ParserError err = new ParserError(this.resource, drlParserError.getMessage(), drlParserError.getLineNumber(), drlParserError.getColumn());
                this.results.add(err);
            }
            return !this.hasErrors() ? packageDescr : null;
        }
        catch (Exception e) {
            LOG.error("Exception", (Throwable)e);
            ParserError err = new ParserError(this.resource, GENERIC_ERROR_MESSAGE + e.toString() + "\n" + Arrays.toString(e.getStackTrace()), -1, 0);
            this.results.add(err);
            throw new DroolsParserException(GENERIC_ERROR_MESSAGE + e.getMessage(), e);
        }
    }

    public String getExpandedDRL(String source, Reader dsl) throws DroolsParserException {
        DefaultExpanderResolver resolver = this.getDefaultResolver(dsl);
        return this.getExpandedDRL(source, resolver);
    }

    public String getExpandedDRL(String source, DefaultExpanderResolver resolver) throws DroolsParserException {
        Expander expander = resolver.get("*", null);
        String expanded = expander.expand(source);
        if (expander.hasErrors()) {
            Object err = "";
            for (ExpanderException ex : expander.getErrors()) {
                err = (String)err + "\n Line:[" + ex.getLine() + "] " + ex.getMessage();
            }
            throw new DroolsParserException((String)err);
        }
        return expanded;
    }

    private StringBuilder getDRLText(Reader reader) throws IOException {
        int len;
        StringBuilder text = new StringBuilder();
        char[] buf = new char[1024];
        while ((len = reader.read(buf)) >= 0) {
            text.append(buf, 0, len);
        }
        return text;
    }

    public boolean hasErrors() {
        return !this.results.isEmpty();
    }

    public List<DroolsError> getErrors() {
        return this.results;
    }

    private PackageDescr compile(boolean isEditor, DRLParser parser) throws DroolsParserException {
        PackageDescr pkgDescr = null;
        try {
            if (isEditor) {
                parser.enableEditorInterface();
            }
            pkgDescr = parser.compilationUnit(this.resource);
            this.editorSentences = parser.getEditorInterface();
            this.makeErrorList(parser);
            if (isEditor || !this.hasErrors()) {
                return pkgDescr;
            }
            return null;
        }
        catch (Exception e) {
            LOG.error("Exception", (Throwable)e);
            ParserError err = new ParserError(this.resource, GENERIC_ERROR_MESSAGE + e.toString() + "\n" + Arrays.toString(e.getStackTrace()), -1, 0);
            this.results.add(err);
            if (isEditor) {
                return pkgDescr;
            }
            throw new DroolsParserException(GENERIC_ERROR_MESSAGE + e.getMessage(), e);
        }
    }

    private void makeErrorList(DRLParser parser) {
        ParserError err;
        for (DroolsParserException recogErr : this.lexer.getErrors()) {
            err = new ParserError(this.resource, recogErr.getMessage(), recogErr.getLineNumber(), recogErr.getColumn());
            this.results.add(err);
        }
        for (DroolsParserException recogErr : parser.getErrors()) {
            err = new ParserError(this.resource, recogErr.getMessage(), recogErr.getLineNumber(), recogErr.getColumn());
            this.results.add(err);
        }
    }

    public Location getLocation() {
        return this.location;
    }

    public DefaultExpanderResolver getDefaultResolver(Reader dsl) throws DroolsParserException {
        DefaultExpanderResolver resolver;
        try {
            resolver = new DefaultExpanderResolver(dsl);
        }
        catch (IOException e) {
            throw new DroolsParserException("Error parsing the DSL.", e);
        }
        return resolver;
    }

    public List<DroolsSentence> getEditorSentences() {
        return this.editorSentences;
    }
}

