/*
 * Decompiled with CFR 0.152.
 */
package org.drools.drl.parser.antlr4;

import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.drools.drl.ast.descr.PackageDescr;
import org.drools.drl.parser.antlr4.DRL10Parser;
import org.drools.drl.parser.antlr4.DRL10ParserHelper;
import org.drools.drl.parser.antlr4.DRLErrorListener;
import org.drools.drl.parser.antlr4.DRLParserError;
import org.kie.api.io.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DRL10ParserWrapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(DRL10ParserWrapper.class);
    private final List<DRLParserError> errors = new ArrayList<DRLParserError>();
    private final Resource resource;

    public DRL10ParserWrapper(Resource resource) {
        this.resource = resource;
    }

    public PackageDescr parse(String drl) {
        DRL10Parser drlParser = DRL10ParserHelper.createDrlParser(drl);
        return this.parse(drlParser);
    }

    public PackageDescr parse(InputStream is, String encoding) {
        DRL10Parser drlParser = DRL10ParserHelper.createDrlParser(is, encoding);
        return this.parse(drlParser);
    }

    public PackageDescr parse(Reader reader) {
        DRL10Parser drlParser = DRL10ParserHelper.createDrlParser(reader);
        return this.parse(drlParser);
    }

    private PackageDescr parse(DRL10Parser drlParser) {
        DRLErrorListener errorListener = new DRLErrorListener();
        drlParser.addErrorListener((ANTLRErrorListener)errorListener);
        DRL10Parser.CompilationUnitContext cxt = drlParser.compilationUnit();
        this.errors.addAll(errorListener.getErrors());
        try {
            return DRL10ParserHelper.compilationUnitContext2PackageDescr(cxt, drlParser.getTokenStream(), this.resource);
        }
        catch (Exception e) {
            LOGGER.error("Exception while creating PackageDescr", (Throwable)e);
            this.errors.add(new DRLParserError(e));
            return null;
        }
    }

    public List<DRLParserError> getErrors() {
        return this.errors;
    }

    public List<String> getErrorMessages() {
        return this.errors.stream().map(DRLParserError::getMessage).collect(Collectors.toList());
    }

    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }
}

