/*
 * Decompiled with CFR 0.152.
 */
package org.drools.drl.parser.antlr4;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeVisitor;
import org.antlr.v4.runtime.tree.RuleNode;
import org.drools.drl.ast.descr.AccumulateDescr;
import org.drools.drl.ast.descr.AccumulateImportDescr;
import org.drools.drl.ast.descr.AndDescr;
import org.drools.drl.ast.descr.AnnotationDescr;
import org.drools.drl.ast.descr.AttributeDescr;
import org.drools.drl.ast.descr.BaseDescr;
import org.drools.drl.ast.descr.BehaviorDescr;
import org.drools.drl.ast.descr.CollectDescr;
import org.drools.drl.ast.descr.ConditionalBranchDescr;
import org.drools.drl.ast.descr.DeclarativeInvokerDescr;
import org.drools.drl.ast.descr.EntryPointDeclarationDescr;
import org.drools.drl.ast.descr.EntryPointDescr;
import org.drools.drl.ast.descr.EnumDeclarationDescr;
import org.drools.drl.ast.descr.EnumLiteralDescr;
import org.drools.drl.ast.descr.EvalDescr;
import org.drools.drl.ast.descr.ExistsDescr;
import org.drools.drl.ast.descr.ExprConstraintDescr;
import org.drools.drl.ast.descr.ForallDescr;
import org.drools.drl.ast.descr.FromDescr;
import org.drools.drl.ast.descr.FunctionDescr;
import org.drools.drl.ast.descr.FunctionImportDescr;
import org.drools.drl.ast.descr.GlobalDescr;
import org.drools.drl.ast.descr.GroupByDescr;
import org.drools.drl.ast.descr.ImportDescr;
import org.drools.drl.ast.descr.MVELExprDescr;
import org.drools.drl.ast.descr.NamedConsequenceDescr;
import org.drools.drl.ast.descr.NotDescr;
import org.drools.drl.ast.descr.OrDescr;
import org.drools.drl.ast.descr.PackageDescr;
import org.drools.drl.ast.descr.PatternDescr;
import org.drools.drl.ast.descr.PatternSourceDescr;
import org.drools.drl.ast.descr.QueryDescr;
import org.drools.drl.ast.descr.RuleDescr;
import org.drools.drl.ast.descr.TypeDeclarationDescr;
import org.drools.drl.ast.descr.TypeFieldDescr;
import org.drools.drl.ast.descr.UnitDescr;
import org.drools.drl.ast.descr.WindowDeclarationDescr;
import org.drools.drl.ast.descr.WindowReferenceDescr;
import org.drools.drl.parser.antlr4.Antlr4ParserStringUtils;
import org.drools.drl.parser.antlr4.BaseDescrFactory;
import org.drools.drl.parser.antlr4.DRL10Parser;
import org.drools.drl.parser.antlr4.DRL10ParserBaseVisitor;
import org.drools.drl.parser.antlr4.DRL10ParserHelper;
import org.drools.drl.parser.antlr4.DescrHelper;
import org.drools.drl.parser.util.ParserStringUtils;
import org.drools.util.StringUtils;
import org.kie.api.io.Resource;

public class DRLVisitorImpl
extends DRL10ParserBaseVisitor<Object> {
    private final TokenStream tokenStream;
    private final Resource resource;

    public DRLVisitorImpl(TokenStream tokenStream, Resource resource) {
        this.tokenStream = tokenStream;
        this.resource = resource;
    }

    @Override
    public PackageDescr visitCompilationUnit(DRL10Parser.CompilationUnitContext ctx) {
        PackageDescr packageDescr = BaseDescrFactory.builder(new PackageDescr()).withParserRuleContext(ctx).withResource(this.resource).build();
        if (ctx.packagedef() != null) {
            packageDescr.setName(DRL10ParserHelper.getTextWithoutErrorNode((ParseTree)ctx.packagedef().name));
        }
        List<BaseDescr> descrList = this.visitDescrChildren((RuleNode)ctx);
        this.applyChildrenDescrs(packageDescr, descrList);
        return packageDescr;
    }

    private void applyChildrenDescrs(PackageDescr packageDescr, List<BaseDescr> descrList) {
        descrList.forEach(descr -> {
            if (descr instanceof UnitDescr) {
                descr.setNamespace(packageDescr.getNamespace());
                packageDescr.setUnit((UnitDescr)descr);
            } else if (descr instanceof GlobalDescr) {
                descr.setNamespace(packageDescr.getNamespace());
                packageDescr.addGlobal((GlobalDescr)descr);
            } else if (descr instanceof FunctionImportDescr) {
                descr.setNamespace(packageDescr.getNamespace());
                packageDescr.addFunctionImport((FunctionImportDescr)descr);
            } else if (descr instanceof AccumulateImportDescr) {
                descr.setNamespace(packageDescr.getNamespace());
                packageDescr.addAccumulateImport((AccumulateImportDescr)descr);
            } else if (descr instanceof ImportDescr) {
                descr.setNamespace(packageDescr.getNamespace());
                packageDescr.addImport((ImportDescr)descr);
            } else if (descr instanceof FunctionDescr) {
                FunctionDescr functionDescr = (FunctionDescr)descr;
                functionDescr.setNamespace(packageDescr.getNamespace());
                AttributeDescr dialect = packageDescr.getAttribute("dialect");
                if (dialect != null) {
                    functionDescr.setDialect(dialect.getValue());
                }
                packageDescr.addFunction(functionDescr);
            } else if (descr instanceof TypeDeclarationDescr) {
                packageDescr.addTypeDeclaration((TypeDeclarationDescr)descr);
            } else if (descr instanceof EntryPointDeclarationDescr) {
                packageDescr.addEntryPointDeclaration((EntryPointDeclarationDescr)descr);
            } else if (descr instanceof WindowDeclarationDescr) {
                packageDescr.addWindowDeclaration((WindowDeclarationDescr)descr);
            } else if (descr instanceof EnumDeclarationDescr) {
                packageDescr.addEnumDeclaration((EnumDeclarationDescr)descr);
            } else if (descr instanceof AttributeDescr) {
                descr.setNamespace(packageDescr.getNamespace());
                packageDescr.addAttribute((AttributeDescr)descr);
            } else if (descr instanceof RuleDescr) {
                RuleDescr ruleDescr = (RuleDescr)descr;
                packageDescr.addRule(ruleDescr);
                packageDescr.afterRuleAdded(ruleDescr);
                ruleDescr.setNamespace(packageDescr.getNamespace());
                ruleDescr.setUnit(packageDescr.getUnit());
            }
        });
    }

    @Override
    public UnitDescr visitUnitdef(DRL10Parser.UnitdefContext ctx) {
        return BaseDescrFactory.builder(new UnitDescr(ctx.name.getText())).withParserRuleContext(ctx).withResource(this.resource).build();
    }

    @Override
    public BaseDescr visitDrlStatementdef(DRL10Parser.DrlStatementdefContext ctx) {
        return this.visitDescrChildren((RuleNode)ctx).get(0);
    }

    @Override
    public GlobalDescr visitGlobaldef(DRL10Parser.GlobaldefContext ctx) {
        return BaseDescrFactory.builder(new GlobalDescr(ctx.drlIdentifier().getText(), ctx.type().getText())).withParserRuleContext(ctx).withResource(this.resource).build();
    }

    @Override
    public ImportDescr visitImportStandardDef(DRL10Parser.ImportStandardDefContext ctx) {
        String target = ctx.drlQualifiedName().getText() + (ctx.MUL() != null ? ".*" : "");
        if (ctx.DRL_FUNCTION() != null || ctx.STATIC() != null) {
            FunctionImportDescr functionImportDescr = BaseDescrFactory.builder(new FunctionImportDescr()).withParserRuleContext(ctx).withResource(this.resource).build();
            functionImportDescr.setTarget(target);
            return functionImportDescr;
        }
        ImportDescr importDescr = BaseDescrFactory.builder(new ImportDescr()).withParserRuleContext(ctx).withResource(this.resource).build();
        importDescr.setTarget(target);
        return importDescr;
    }

    @Override
    public AccumulateImportDescr visitImportAccumulateDef(DRL10Parser.ImportAccumulateDefContext ctx) {
        AccumulateImportDescr accumulateImportDescr = BaseDescrFactory.builder(new AccumulateImportDescr()).withParserRuleContext(ctx).withResource(this.resource).build();
        accumulateImportDescr.setTarget(ctx.drlQualifiedName().getText());
        accumulateImportDescr.setFunctionName(ctx.drlIdentifier().getText());
        return accumulateImportDescr;
    }

    @Override
    public FunctionDescr visitFunctiondef(DRL10Parser.FunctiondefContext ctx) {
        FunctionDescr functionDescr = BaseDescrFactory.builder(new FunctionDescr()).withParserRuleContext(ctx).withResource(this.resource).build();
        if (ctx.typeTypeOrVoid() != null) {
            functionDescr.setReturnType(Antlr4ParserStringUtils.getTextPreservingWhitespace(ctx.typeTypeOrVoid()));
        } else {
            functionDescr.setReturnType("void");
        }
        functionDescr.setName(ctx.drlIdentifier().getText());
        DRL10Parser.FormalParametersContext formalParametersContext = ctx.formalParameters();
        DRL10Parser.FormalParameterListContext formalParameterListContext = formalParametersContext.formalParameterList();
        if (formalParameterListContext != null) {
            List<DRL10Parser.FormalParameterContext> formalParameterContexts = formalParameterListContext.formalParameter();
            formalParameterContexts.forEach(formalParameterContext -> {
                DRL10Parser.TypeTypeContext typeTypeContext = formalParameterContext.typeType();
                DRL10Parser.VariableDeclaratorIdContext variableDeclaratorIdContext = formalParameterContext.variableDeclaratorId();
                functionDescr.addParameter(typeTypeContext.getText(), variableDeclaratorIdContext.getText());
            });
        }
        functionDescr.setBody(Antlr4ParserStringUtils.getTextPreservingWhitespace(ctx.drlBlock().drlBlockStatement()));
        return functionDescr;
    }

    @Override
    public BaseDescr visitDeclaredef(DRL10Parser.DeclaredefContext ctx) {
        return this.visitDescrChildren((RuleNode)ctx).get(0);
    }

    @Override
    public TypeDeclarationDescr visitTypeDeclaration(DRL10Parser.TypeDeclarationContext ctx) {
        TypeDeclarationDescr typeDeclarationDescr = BaseDescrFactory.builder(new TypeDeclarationDescr()).withParserRuleContext(ctx).withResource(this.resource).build();
        typeDeclarationDescr.setTypeName(ctx.name.getText());
        if (ctx.DRL_TRAIT() != null) {
            typeDeclarationDescr.setTrait(true);
        }
        if (ctx.EXTENDS() != null) {
            for (DRL10Parser.DrlQualifiedNameContext superType : ctx.superTypes) {
                typeDeclarationDescr.addSuperType(superType.getText());
            }
        }
        ctx.drlAnnotation().stream().map(this::visitDrlAnnotation).forEach(arg_0 -> ((TypeDeclarationDescr)typeDeclarationDescr).addAnnotation(arg_0));
        ctx.field().stream().map(this::visitField).forEach(arg_0 -> ((TypeDeclarationDescr)typeDeclarationDescr).addField(arg_0));
        return typeDeclarationDescr;
    }

    @Override
    public EnumDeclarationDescr visitEnumDeclaration(DRL10Parser.EnumDeclarationContext ctx) {
        EnumDeclarationDescr enumDeclarationDescr = BaseDescrFactory.builder(new EnumDeclarationDescr()).withParserRuleContext(ctx).withResource(this.resource).build();
        enumDeclarationDescr.setTypeName(ctx.name.getText());
        ctx.drlAnnotation().stream().map(this::visitDrlAnnotation).forEach(arg_0 -> ((EnumDeclarationDescr)enumDeclarationDescr).addAnnotation(arg_0));
        List<BaseDescr> descrList = this.visitDescrChildren((RuleNode)ctx.enumeratives());
        descrList.stream().filter(EnumLiteralDescr.class::isInstance).map(EnumLiteralDescr.class::cast).forEach(arg_0 -> ((EnumDeclarationDescr)enumDeclarationDescr).addLiteral(arg_0));
        ctx.field().stream().map(this::visitField).forEach(arg_0 -> ((EnumDeclarationDescr)enumDeclarationDescr).addField(arg_0));
        return enumDeclarationDescr;
    }

    @Override
    public EnumLiteralDescr visitEnumerative(DRL10Parser.EnumerativeContext ctx) {
        EnumLiteralDescr enumLiteralDescr = BaseDescrFactory.builder(new EnumLiteralDescr(ctx.drlIdentifier().getText())).withParserRuleContext(ctx).withResource(this.resource).build();
        ctx.expression().stream().map(Antlr4ParserStringUtils::getTextPreservingWhitespace).forEach(arg_0 -> ((EnumLiteralDescr)enumLiteralDescr).addConstructorArg(arg_0));
        return enumLiteralDescr;
    }

    @Override
    public EntryPointDeclarationDescr visitEntryPointDeclaration(DRL10Parser.EntryPointDeclarationContext ctx) {
        EntryPointDeclarationDescr entryPointDeclarationDescr = BaseDescrFactory.builder(new EntryPointDeclarationDescr()).withParserRuleContext(ctx).withResource(this.resource).build();
        entryPointDeclarationDescr.setEntryPointId(ParserStringUtils.safeStripStringDelimiters(ctx.name.getText()));
        ctx.drlAnnotation().stream().map(this::visitDrlAnnotation).forEach(arg_0 -> ((EntryPointDeclarationDescr)entryPointDeclarationDescr).addAnnotation(arg_0));
        return entryPointDeclarationDescr;
    }

    @Override
    public WindowDeclarationDescr visitWindowDeclaration(DRL10Parser.WindowDeclarationContext ctx) {
        WindowDeclarationDescr windowDeclarationDescr = BaseDescrFactory.builder(new WindowDeclarationDescr()).withParserRuleContext(ctx).withResource(this.resource).build();
        windowDeclarationDescr.setName(ctx.name.getText());
        ctx.drlAnnotation().stream().map(this::visitDrlAnnotation).forEach(arg_0 -> ((WindowDeclarationDescr)windowDeclarationDescr).addAnnotation(arg_0));
        windowDeclarationDescr.setPattern((PatternDescr)this.visitLhsPatternBind(ctx.lhsPatternBind()));
        return windowDeclarationDescr;
    }

    @Override
    public RuleDescr visitRuledef(DRL10Parser.RuledefContext ctx) {
        RuleDescr ruleDescr = BaseDescrFactory.builder(new RuleDescr(ParserStringUtils.safeStripStringDelimiters(ctx.name.getText()))).withParserRuleContext(ctx).withResource(this.resource).build();
        if (ctx.EXTENDS() != null) {
            ruleDescr.setParentName(ParserStringUtils.safeStripStringDelimiters(ctx.parentName.getText()));
        }
        ctx.drlAnnotation().stream().map(this::visitDrlAnnotation).forEach(arg_0 -> ((RuleDescr)ruleDescr).addAnnotation(arg_0));
        if (ctx.attributes() != null) {
            List<BaseDescr> descrList = this.visitDescrChildren((RuleNode)ctx.attributes());
            descrList.stream().filter(AttributeDescr.class::isInstance).map(AttributeDescr.class::cast).forEach(arg_0 -> ((RuleDescr)ruleDescr).addAttribute(arg_0));
        }
        if (ctx.lhs() != null) {
            AndDescr rootDescr = ruleDescr.getLhs();
            Object lhsDescrList = this.visitLhs(ctx.lhs());
            lhsDescrList.forEach(arg_0 -> ((AndDescr)rootDescr).addOrMerge(arg_0));
            DescrHelper.populateCommonProperties(rootDescr, ctx.lhs().lhsExpression());
        } else {
            ruleDescr.setLhs(BaseDescrFactory.builder(new AndDescr()).withResource(this.resource).build());
        }
        if (ctx.rhs() != null) {
            ruleDescr.setConsequenceLocation(ctx.rhs().getStart().getLine(), ctx.rhs().getStart().getCharPositionInLine());
            ruleDescr.setConsequence((Object)Antlr4ParserStringUtils.getTokenTextPreservingWhitespace(ctx.rhs().consequenceBody(), this.tokenStream));
            ctx.rhs().namedConsequence().forEach(namedConsequenceCtx -> {
                String name = Antlr4ParserStringUtils.extractNamedConsequenceName(namedConsequenceCtx.RHS_NAMED_CONSEQUENCE_THEN().getText());
                String body = Antlr4ParserStringUtils.getTokenTextPreservingWhitespace(namedConsequenceCtx.consequenceBody(), this.tokenStream);
                ruleDescr.addNamedConsequences(name, (Object)body);
            });
        }
        return ruleDescr;
    }

    @Override
    public QueryDescr visitQuerydef(DRL10Parser.QuerydefContext ctx) {
        QueryDescr queryDescr = BaseDescrFactory.builder(new QueryDescr(ParserStringUtils.safeStripStringDelimiters(ctx.name.getText()))).withParserRuleContext(ctx).withResource(this.resource).build();
        DRL10Parser.ParametersContext parametersContext = ctx.parameters();
        if (parametersContext != null) {
            List<DRL10Parser.ParameterContext> parameterContexts = parametersContext.parameter();
            parameterContexts.forEach(parameterContext -> {
                String type = parameterContext.type() != null ? parameterContext.type().getText() : "Object";
                String name = parameterContext.drlIdentifier().getText();
                queryDescr.addParameter(type, name);
            });
        }
        ctx.drlAnnotation().stream().map(this::visitDrlAnnotation).forEach(arg_0 -> ((QueryDescr)queryDescr).addAnnotation(arg_0));
        AndDescr rootDescr = queryDescr.getLhs();
        List<BaseDescr> lhsDescrList = this.visitDescrChildren((RuleNode)ctx.queryLhs());
        lhsDescrList.forEach(arg_0 -> ((AndDescr)rootDescr).addOrMerge(arg_0));
        DescrHelper.populateCommonProperties(rootDescr, ctx.queryLhs());
        return queryDescr;
    }

    @Override
    public AnnotationDescr visitDrlAnnotation(DRL10Parser.DrlAnnotationContext ctx) {
        if (ctx.anno != null) {
            if (ctx.anno.result == null) {
                throw new IllegalStateException("anno.result must not be null!");
            }
            return BaseDescrFactory.builder(ctx.anno.result).withParserRuleContext(ctx).withResource(this.resource).build();
        }
        AnnotationDescr annotationDescr = BaseDescrFactory.builder(new AnnotationDescr(ctx.name.getText())).withParserRuleContext(ctx).withResource(this.resource).build();
        if (ctx.chunk() != null) {
            annotationDescr.setValue((Object)Antlr4ParserStringUtils.getTextPreservingWhitespace(ctx.chunk()));
        }
        return annotationDescr;
    }

    @Override
    public TypeFieldDescr visitField(DRL10Parser.FieldContext ctx) {
        TypeFieldDescr typeFieldDescr = BaseDescrFactory.builder(new TypeFieldDescr()).withParserRuleContext(ctx).withResource(this.resource).build();
        typeFieldDescr.setFieldName(ctx.label().drlIdentifier().getText());
        typeFieldDescr.setPattern(new PatternDescr(ctx.type().getText()));
        if (ctx.ASSIGN() != null) {
            typeFieldDescr.setInitExpr(Antlr4ParserStringUtils.getTextPreservingWhitespace(ctx.initExpr));
        }
        ctx.drlAnnotation().stream().map(this::visitDrlAnnotation).forEach(arg_0 -> ((TypeFieldDescr)typeFieldDescr).addAnnotation(arg_0));
        return typeFieldDescr;
    }

    @Override
    public AttributeDescr visitExpressionAttribute(DRL10Parser.ExpressionAttributeContext ctx) {
        AttributeDescr attributeDescr = BaseDescrFactory.builder(new AttributeDescr(ctx.name.getText())).withParserRuleContext(ctx).withResource(this.resource).build();
        attributeDescr.setValue(Antlr4ParserStringUtils.getTextPreservingWhitespace(ctx.conditionalAttributeValue()));
        attributeDescr.setType(AttributeDescr.Type.EXPRESSION);
        return attributeDescr;
    }

    @Override
    public AttributeDescr visitBooleanAttribute(DRL10Parser.BooleanAttributeContext ctx) {
        AttributeDescr attributeDescr = BaseDescrFactory.builder(new AttributeDescr(ctx.name.getText())).withParserRuleContext(ctx).withResource(this.resource).build();
        attributeDescr.setValue(ctx.BOOL_LITERAL() != null ? ctx.BOOL_LITERAL().getText() : "true");
        attributeDescr.setType(AttributeDescr.Type.BOOLEAN);
        return attributeDescr;
    }

    @Override
    public AttributeDescr visitStringAttribute(DRL10Parser.StringAttributeContext ctx) {
        AttributeDescr attributeDescr = BaseDescrFactory.builder(new AttributeDescr(ctx.name.getText())).withParserRuleContext(ctx).withResource(this.resource).build();
        attributeDescr.setValue(StringUtils.unescapeJava((String)ParserStringUtils.safeStripStringDelimiters(ctx.DRL_STRING_LITERAL().getText())));
        attributeDescr.setType(AttributeDescr.Type.STRING);
        return attributeDescr;
    }

    @Override
    public AttributeDescr visitStringListAttribute(DRL10Parser.StringListAttributeContext ctx) {
        AttributeDescr attributeDescr = BaseDescrFactory.builder(new AttributeDescr(ctx.name.getText())).withParserRuleContext(ctx).withResource(this.resource).build();
        List<String> valueList = ctx.DRL_STRING_LITERAL().stream().map(ParseTree::getText).collect(Collectors.toList());
        attributeDescr.setValue(DRLVisitorImpl.createStringList(valueList));
        attributeDescr.setType(AttributeDescr.Type.LIST);
        return attributeDescr;
    }

    private static String createStringList(List<String> valueList) {
        StringBuilder sb = new StringBuilder();
        sb.append("[ ");
        for (int i = 0; i < valueList.size(); ++i) {
            sb.append(valueList.get(i));
            if (i >= valueList.size() - 1) continue;
            sb.append(", ");
        }
        sb.append(" ]");
        return sb.toString();
    }

    @Override
    public AttributeDescr visitIntOrChunkAttribute(DRL10Parser.IntOrChunkAttributeContext ctx) {
        AttributeDescr attributeDescr = BaseDescrFactory.builder(new AttributeDescr(ctx.name.getText())).withParserRuleContext(ctx).withResource(this.resource).build();
        if (ctx.DECIMAL_LITERAL() != null) {
            attributeDescr.setValue(ctx.DECIMAL_LITERAL().getText());
            attributeDescr.setType(AttributeDescr.Type.NUMBER);
        } else {
            attributeDescr.setValue(Antlr4ParserStringUtils.getTextPreservingWhitespace(ctx.chunk()));
            attributeDescr.setType(AttributeDescr.Type.EXPRESSION);
        }
        return attributeDescr;
    }

    @Override
    public List<BaseDescr> visitLhs(DRL10Parser.LhsContext ctx) {
        if (ctx.lhsExpression() != null) {
            return this.visitDescrChildren((RuleNode)ctx);
        }
        return new ArrayList<BaseDescr>();
    }

    @Override
    public BaseDescr visitLhsPatternBind(DRL10Parser.LhsPatternBindContext ctx) {
        if (ctx.lhsPattern().size() == 1) {
            return this.getSinglePatternDescr(ctx);
        }
        if (ctx.lhsPattern().size() > 1) {
            return this.getOrDescrWithMultiplePatternDescr(ctx);
        }
        return null;
    }

    private PatternDescr getSinglePatternDescr(DRL10Parser.LhsPatternBindContext ctx) {
        List<BaseDescr> patternDescrList = this.visitDescrChildren((RuleNode)ctx);
        if (patternDescrList.isEmpty() || !(patternDescrList.get(0) instanceof PatternDescr)) {
            throw new IllegalStateException("lhsPatternBind must have at least one lhsPattern : " + ctx.getText());
        }
        PatternDescr patternDescr = (PatternDescr)patternDescrList.get(0);
        if (ctx.label() != null) {
            patternDescr.setIdentifier(ctx.label().drlIdentifier().getText());
        } else if (ctx.unif() != null) {
            patternDescr.setIdentifier(ctx.unif().drlIdentifier().getText());
            patternDescr.setUnification(true);
        }
        DescrHelper.refreshPatternDescrProperties(patternDescr, ctx);
        return patternDescr;
    }

    private OrDescr getOrDescrWithMultiplePatternDescr(DRL10Parser.LhsPatternBindContext ctx) {
        OrDescr orDescr = BaseDescrFactory.builder(new OrDescr()).withParserRuleContext(ctx).withResource(this.resource).build();
        List<BaseDescr> descrList = this.visitDescrChildren((RuleNode)ctx);
        descrList.stream().filter(PatternDescr.class::isInstance).map(PatternDescr.class::cast).forEach(patternDescr -> {
            if (ctx.label() != null) {
                patternDescr.setIdentifier(ctx.label().drlIdentifier().getText());
            }
            orDescr.addDescr((BaseDescr)patternDescr);
        });
        return orDescr;
    }

    @Override
    public PatternDescr visitLhsPattern(DRL10Parser.LhsPatternContext ctx) {
        if (ctx.xpathPrimary() != null) {
            String constraint = this.visitConstraintChildren(ctx);
            ExprConstraintDescr constraintDescr = BaseDescrFactory.builder(new ExprConstraintDescr(constraint)).withParserRuleContext(ctx).withResource(this.resource).build();
            constraintDescr.setType(ExprConstraintDescr.Type.NAMED);
            constraintDescr.setPosition(0);
            PatternDescr patternDescr = BaseDescrFactory.builder(new PatternDescr()).withParserRuleContext(ctx).withResource(this.resource).build();
            patternDescr.addConstraint((BaseDescr)constraintDescr);
            return patternDescr;
        }
        PatternDescr patternDescr = BaseDescrFactory.builder(new PatternDescr(ctx.objectType.getText())).withParserRuleContext(ctx).withResource(this.resource).build();
        if (ctx.QUESTION() != null) {
            patternDescr.setQuery(true);
        }
        if (ctx.patternFilter() != null) {
            patternDescr.addBehavior(this.visitPatternFilter(ctx.patternFilter()));
        }
        if (ctx.patternSource() != null) {
            PatternSourceDescr patternSourceDescr = (PatternSourceDescr)this.visitPatternSource(ctx.patternSource());
            patternSourceDescr.setResource(patternDescr.getResource());
            patternDescr.setSource(patternSourceDescr);
        }
        ctx.drlAnnotation().stream().map(this::visitDrlAnnotation).forEach(arg_0 -> ((PatternDescr)patternDescr).addAnnotation(arg_0));
        List<ExprConstraintDescr> constraintDescrList = this.visitConstraints(ctx.positionalConstraints(), ctx.constraints());
        constraintDescrList.forEach(descr -> this.addToPatternDescr(patternDescr, (ExprConstraintDescr)descr));
        return patternDescr;
    }

    private void addToPatternDescr(PatternDescr patternDescr, ExprConstraintDescr exprConstraintDescr) {
        exprConstraintDescr.setResource(patternDescr.getResource());
        patternDescr.addConstraint((BaseDescr)exprConstraintDescr);
    }

    @Override
    public NamedConsequenceDescr visitNamedConsequenceInvocation(DRL10Parser.NamedConsequenceInvocationContext ctx) {
        NamedConsequenceDescr namedConsequenceDescr = BaseDescrFactory.builder(new NamedConsequenceDescr(ctx.drlIdentifier().getText())).withParserRuleContext(ctx).withResource(this.resource).build();
        return namedConsequenceDescr;
    }

    @Override
    public NamedConsequenceDescr visitBreakingNamedConsequenceInvocation(DRL10Parser.BreakingNamedConsequenceInvocationContext ctx) {
        NamedConsequenceDescr namedConsequenceDescr = BaseDescrFactory.builder(new NamedConsequenceDescr(ctx.drlIdentifier().getText())).withParserRuleContext(ctx).withResource(this.resource).build();
        namedConsequenceDescr.setBreaking(true);
        return namedConsequenceDescr;
    }

    @Override
    public ConditionalBranchDescr visitConditionalBranch(DRL10Parser.ConditionalBranchContext ctx) {
        ConditionalBranchDescr conditionalBranchDescr = BaseDescrFactory.builder(new ConditionalBranchDescr()).withParserRuleContext(ctx).withResource(this.resource).build();
        EvalDescr evalDescr = BaseDescrFactory.builder(new EvalDescr()).withParserRuleContext(ctx.conditionalOrExpression()).withResource(this.resource).build();
        evalDescr.setContent((Object)Antlr4ParserStringUtils.getTextPreservingWhitespace(ctx.conditionalOrExpression()));
        conditionalBranchDescr.setCondition(evalDescr);
        if (ctx.do1 != null) {
            namedConsequenceDescr = this.visitNamedConsequenceInvocation(ctx.do1);
            conditionalBranchDescr.setConsequence(namedConsequenceDescr);
        } else if (ctx.break1 != null) {
            namedConsequenceDescr = this.visitBreakingNamedConsequenceInvocation(ctx.break1);
            conditionalBranchDescr.setConsequence(namedConsequenceDescr);
        }
        if (ctx.do2 != null) {
            elseBranchDescr = BaseDescrFactory.builder(new ConditionalBranchDescr()).withParserRuleContext(ctx.do2).withResource(this.resource).build();
            conditionalBranchDescr.setElseBranch(elseBranchDescr);
            NamedConsequenceDescr namedConsequenceDescr = this.visitNamedConsequenceInvocation(ctx.do2);
            elseBranchDescr.setConsequence(namedConsequenceDescr);
        } else if (ctx.break2 != null) {
            elseBranchDescr = BaseDescrFactory.builder(new ConditionalBranchDescr()).withParserRuleContext(ctx.break2).withResource(this.resource).build();
            conditionalBranchDescr.setElseBranch(elseBranchDescr);
            NamedConsequenceDescr namedConsequenceDescr = this.visitBreakingNamedConsequenceInvocation(ctx.break2);
            elseBranchDescr.setConsequence(namedConsequenceDescr);
        } else if (ctx.conditionalBranch() != null) {
            ConditionalBranchDescr nestedConditionalBranchDescr = this.visitConditionalBranch(ctx.conditionalBranch());
            conditionalBranchDescr.setElseBranch(nestedConditionalBranchDescr);
        }
        return conditionalBranchDescr;
    }

    @Override
    public ForallDescr visitLhsForall(DRL10Parser.LhsForallContext ctx) {
        ForallDescr forallDescr = BaseDescrFactory.builder(new ForallDescr()).withParserRuleContext(ctx).withResource(this.resource).build();
        this.visitDescrChildren((RuleNode)ctx).forEach(arg_0 -> ((ForallDescr)forallDescr).addDescr(arg_0));
        return forallDescr;
    }

    @Override
    public PatternDescr visitLhsAccumulate(DRL10Parser.LhsAccumulateContext ctx) {
        AccumulateDescr accumulateDescr = BaseDescrFactory.builder(new AccumulateDescr()).withParserRuleContext(ctx).withResource(this.resource).build();
        accumulateDescr.setInput((BaseDescr)this.wrapWithAndDescr(this.visitLhsAndDef(ctx.lhsAndDef()), ctx.lhsAndDef()));
        for (DRL10Parser.AccumulateFunctionContext accumulateFunctionContext : ctx.accumulateFunction()) {
            accumulateDescr.addFunction(this.visitAccumulateFunction(accumulateFunctionContext));
        }
        PatternDescr patternDescr = BaseDescrFactory.builder(new PatternDescr("Object")).withResource(this.resource).build();
        patternDescr.setSource((PatternSourceDescr)accumulateDescr);
        Object constraintDescrList = this.visitConstraints(ctx.constraints());
        constraintDescrList.forEach(arg_0 -> ((PatternDescr)patternDescr).addConstraint(arg_0));
        return patternDescr;
    }

    private AndDescr wrapWithAndDescr(BaseDescr baseDescr, ParserRuleContext ctx) {
        if (baseDescr instanceof AndDescr) {
            AndDescr andDescr = (AndDescr)baseDescr;
            return andDescr;
        }
        AndDescr andDescr = BaseDescrFactory.builder(new AndDescr()).withParserRuleContext(ctx).build();
        andDescr.addDescr(baseDescr);
        return andDescr;
    }

    @Override
    public Object visitLhsGroupBy(DRL10Parser.LhsGroupByContext ctx) {
        GroupByDescr groupByDescr = BaseDescrFactory.builder(new GroupByDescr()).withParserRuleContext(ctx).withResource(this.resource).build();
        groupByDescr.setInput(this.visitLhsAndDef(ctx.lhsAndDef()));
        if (ctx.groupByKeyBinding().label() != null) {
            groupByDescr.setGroupingKey(ctx.groupByKeyBinding().label().drlIdentifier().getText());
        }
        groupByDescr.setGroupingFunction(Antlr4ParserStringUtils.getTextPreservingWhitespace(ctx.groupByKeyBinding().conditionalExpression()));
        for (DRL10Parser.AccumulateFunctionContext accumulateFunctionContext : ctx.accumulateFunction()) {
            groupByDescr.addFunction(this.visitAccumulateFunction(accumulateFunctionContext));
        }
        PatternDescr patternDescr = BaseDescrFactory.builder(new PatternDescr("Object")).withResource(this.resource).build();
        patternDescr.setSource((PatternSourceDescr)groupByDescr);
        Object constraintDescrList = this.visitConstraints(ctx.constraints());
        constraintDescrList.forEach(arg_0 -> ((PatternDescr)patternDescr).addConstraint(arg_0));
        return patternDescr;
    }

    @Override
    public BehaviorDescr visitPatternFilter(DRL10Parser.PatternFilterContext ctx) {
        BehaviorDescr behaviorDescr = BaseDescrFactory.builder(new BehaviorDescr()).withParserRuleContext(ctx).withResource(this.resource).build();
        behaviorDescr.setType(ctx.DRL_WINDOW().getText());
        behaviorDescr.setSubType(ctx.drlIdentifier().getText());
        List<DRL10Parser.ExpressionContext> expressionContexts = ctx.expressionList().expression();
        List parameters = expressionContexts.stream().map(Antlr4ParserStringUtils::getTextPreservingWhitespace).collect(Collectors.toList());
        behaviorDescr.setParameters(parameters);
        return behaviorDescr;
    }

    @Override
    public FromDescr visitFromExpression(DRL10Parser.FromExpressionContext ctx) {
        FromDescr fromDescr = BaseDescrFactory.builder(new FromDescr()).withParserRuleContext(ctx).withResource(this.resource).build();
        fromDescr.setDataSource((DeclarativeInvokerDescr)new MVELExprDescr(Antlr4ParserStringUtils.getTextPreservingWhitespace(ctx)));
        return fromDescr;
    }

    @Override
    public CollectDescr visitFromCollect(DRL10Parser.FromCollectContext ctx) {
        CollectDescr collectDescr = BaseDescrFactory.builder(new CollectDescr()).withParserRuleContext(ctx).withResource(this.resource).build();
        collectDescr.setInputPattern((PatternDescr)this.visitLhsPatternBind(ctx.lhsPatternBind()));
        return collectDescr;
    }

    @Override
    public AccumulateDescr visitFromAccumulate(DRL10Parser.FromAccumulateContext ctx) {
        AccumulateDescr accumulateDescr = BaseDescrFactory.builder(new AccumulateDescr()).withParserRuleContext(ctx).withResource(this.resource).build();
        accumulateDescr.setInput((BaseDescr)this.wrapWithAndDescr(this.visitLhsAndDef(ctx.lhsAndDef()), ctx.lhsAndDef()));
        if (ctx.DRL_INIT() != null) {
            accumulateDescr.setInitCode(Antlr4ParserStringUtils.getTextPreservingWhitespace(ctx.initBlockStatements));
            accumulateDescr.setActionCode(Antlr4ParserStringUtils.getTextPreservingWhitespace(ctx.actionBlockStatements));
            if (ctx.DRL_REVERSE() != null) {
                accumulateDescr.setReverseCode(Antlr4ParserStringUtils.getTextPreservingWhitespace(ctx.reverseBlockStatements));
            }
            accumulateDescr.setResultCode(Antlr4ParserStringUtils.getTextPreservingWhitespace(ctx.resultBlockStatements));
        } else {
            accumulateDescr.addFunction(this.visitAccumulateFunction(ctx.accumulateFunction()));
        }
        return accumulateDescr;
    }

    @Override
    public AccumulateDescr.AccumulateFunctionCallDescr visitAccumulateFunction(DRL10Parser.AccumulateFunctionContext ctx) {
        String function = ctx.drlIdentifier().getText();
        String bind = null;
        boolean unify = false;
        if (ctx.label() != null) {
            bind = ctx.label().drlIdentifier().getText();
        } else if (ctx.unif() != null) {
            bind = ctx.unif().drlIdentifier().getText();
            unify = true;
        }
        String[] params = (String[])ctx.conditionalExpressions().conditionalExpression().stream().map(Antlr4ParserStringUtils::getTextPreservingWhitespace).toArray(String[]::new);
        return new AccumulateDescr.AccumulateFunctionCallDescr(function, bind, unify, params);
    }

    @Override
    public EntryPointDescr visitFromEntryPoint(DRL10Parser.FromEntryPointContext ctx) {
        return BaseDescrFactory.builder(new EntryPointDescr(ParserStringUtils.safeStripStringDelimiters(ctx.stringId().getText()))).withParserRuleContext(ctx).withResource(this.resource).build();
    }

    @Override
    public WindowReferenceDescr visitFromWindow(DRL10Parser.FromWindowContext ctx) {
        return BaseDescrFactory.builder(new WindowReferenceDescr(ctx.drlIdentifier().getText())).withParserRuleContext(ctx).withResource(this.resource).build();
    }

    @Override
    public List<ExprConstraintDescr> visitConstraints(DRL10Parser.ConstraintsContext ctx) {
        ArrayList<ExprConstraintDescr> exprConstraintDescrList = new ArrayList<ExprConstraintDescr>();
        this.populateExprConstraintDescrList(ctx, exprConstraintDescrList);
        return exprConstraintDescrList;
    }

    private List<ExprConstraintDescr> visitConstraints(DRL10Parser.PositionalConstraintsContext positionalCtx, DRL10Parser.ConstraintsContext ctx) {
        ArrayList<ExprConstraintDescr> exprConstraintDescrList = new ArrayList<ExprConstraintDescr>();
        this.populateExprConstraintDescrList(positionalCtx, exprConstraintDescrList);
        this.populateExprConstraintDescrList(ctx, exprConstraintDescrList);
        return exprConstraintDescrList;
    }

    private void populateExprConstraintDescrList(ParserRuleContext ctx, List<ExprConstraintDescr> exprConstraintDescrList) {
        if (ctx == null) {
            return;
        }
        List<BaseDescr> descrList = this.visitDescrChildren((RuleNode)ctx);
        for (BaseDescr descr : descrList) {
            if (!(descr instanceof ExprConstraintDescr)) continue;
            ExprConstraintDescr exprConstraintDescr = (ExprConstraintDescr)descr;
            exprConstraintDescr.setType(ctx instanceof DRL10Parser.PositionalConstraintsContext ? ExprConstraintDescr.Type.POSITIONAL : ExprConstraintDescr.Type.NAMED);
            exprConstraintDescr.setPosition(exprConstraintDescrList.size());
            exprConstraintDescrList.add(exprConstraintDescr);
        }
    }

    @Override
    public List<ExprConstraintDescr> visitConstraint(DRL10Parser.ConstraintContext ctx) {
        ArrayList<ExprConstraintDescr> descrList = new ArrayList<ExprConstraintDescr>();
        if (ctx.nestedConstraint() != null) {
            return this.visitNestedConstraint(ctx.nestedConstraint());
        }
        String constraint = this.visitConstraintChildren(ctx);
        if (!constraint.isEmpty()) {
            ExprConstraintDescr constraintDescr = BaseDescrFactory.builder(new ExprConstraintDescr(constraint)).withParserRuleContext(ctx).withResource(this.resource).build();
            constraintDescr.setType(ExprConstraintDescr.Type.NAMED);
            descrList.add(constraintDescr);
            return descrList;
        }
        return descrList;
    }

    @Override
    public List<ExprConstraintDescr> visitNestedConstraint(DRL10Parser.NestedConstraintContext ctx) {
        Token prefixStartToken = ctx.start;
        Token prefixEndToken = this.tokenStream.get(ctx.LPAREN().getSymbol().getTokenIndex() - 1);
        String prefix = this.tokenStream.getText(prefixStartToken, prefixEndToken);
        Object exprConstraintDescr = this.visitConstraints(ctx.constraints());
        exprConstraintDescr.forEach(d -> d.setText(ParserStringUtils.appendPrefix(prefix, d.getText())));
        return exprConstraintDescr;
    }

    @Override
    public String visitDrlIdentifier(DRL10Parser.DrlIdentifierContext ctx) {
        return ctx.getText();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ExistsDescr visitLhsExists(DRL10Parser.LhsExistsContext ctx) {
        ExistsDescr existsDescr = BaseDescrFactory.builder(new ExistsDescr()).withParserRuleContext(ctx).withResource(this.resource).build();
        if (ctx.lhsExpression() != null) {
            List<BaseDescr> baseDescrs = this.visitDescrChildren((RuleNode)ctx);
            if (baseDescrs.size() != 1) throw new IllegalStateException("'exists()' children descr size must be 1 : " + ctx.getText());
            existsDescr.addDescr(baseDescrs.get(0));
            return existsDescr;
        } else {
            BaseDescr descr = this.visitLhsPatternBind(ctx.lhsPatternBind());
            existsDescr.addDescr(descr);
        }
        return existsDescr;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public NotDescr visitLhsNot(DRL10Parser.LhsNotContext ctx) {
        NotDescr notDescr = BaseDescrFactory.builder(new NotDescr()).withParserRuleContext(ctx).withResource(this.resource).build();
        if (ctx.lhsExpression() != null) {
            List<BaseDescr> baseDescrs = this.visitDescrChildren((RuleNode)ctx);
            if (baseDescrs.size() != 1) throw new IllegalStateException("'not()' children descr size must be 1 : " + ctx.getText());
            notDescr.addDescr(baseDescrs.get(0));
            return notDescr;
        } else {
            BaseDescr descr = this.visitLhsPatternBind(ctx.lhsPatternBind());
            notDescr.addDescr(descr);
        }
        return notDescr;
    }

    @Override
    public EvalDescr visitLhsEval(DRL10Parser.LhsEvalContext ctx) {
        return BaseDescrFactory.builder(new EvalDescr((Object)Antlr4ParserStringUtils.getTextPreservingWhitespace(ctx.conditionalOrExpression()))).withParserRuleContext(ctx).withResource(this.resource).build();
    }

    @Override
    public List<BaseDescr> visitLhsExpressionEnclosed(DRL10Parser.LhsExpressionEnclosedContext ctx) {
        return this.visitDescrChildren((RuleNode)ctx);
    }

    @Override
    public BaseDescr visitLhsOr(DRL10Parser.LhsOrContext ctx) {
        List<DescrNodePair> descrList = this.visitDescrChildrenForDescrNodePair((RuleNode)ctx);
        if (descrList.size() == 1) {
            return descrList.get(0).getDescr();
        }
        OrDescr orDescr = BaseDescrFactory.builder(new OrDescr()).withParserRuleContext(ctx).withResource(this.resource).build();
        List<BaseDescr> flattenedDescrs = this.flattenOrDescr(descrList);
        flattenedDescrs.forEach(descr -> {
            if (descr instanceof AnnotationDescr) {
                AnnotationDescr annotationDescr = (AnnotationDescr)descr;
                orDescr.addAnnotation(annotationDescr);
            } else {
                orDescr.addDescr(descr);
            }
        });
        return orDescr;
    }

    private List<BaseDescr> flattenOrDescr(List<DescrNodePair> descrList) {
        ArrayList<BaseDescr> flattenedDescrs = new ArrayList<BaseDescr>();
        for (DescrNodePair descrNodePair : descrList) {
            BaseDescr descr = descrNodePair.getDescr();
            ParseTree node = descrNodePair.getNode();
            if (descr instanceof OrDescr) {
                OrDescr orDescr = (OrDescr)descr;
                if (!(node instanceof DRL10Parser.LhsExpressionEnclosedContext)) {
                    flattenedDescrs.addAll(orDescr.getDescrs());
                    flattenedDescrs.addAll(orDescr.getAnnotations());
                    continue;
                }
            }
            flattenedDescrs.add(descr);
        }
        return flattenedDescrs;
    }

    @Override
    public BaseDescr visitLhsAnd(DRL10Parser.LhsAndContext ctx) {
        return this.createAndDescr(ctx);
    }

    private BaseDescr createAndDescr(ParserRuleContext ctx) {
        List<DescrNodePair> descrList = this.visitDescrChildrenForDescrNodePair((RuleNode)ctx);
        if (descrList.size() == 1) {
            return descrList.get(0).getDescr();
        }
        AndDescr andDescr = BaseDescrFactory.builder(new AndDescr()).withParserRuleContext(ctx).withResource(this.resource).build();
        List<BaseDescr> flattenedDescrs = this.flattenAndDescr(descrList);
        flattenedDescrs.forEach(descr -> {
            if (descr instanceof AnnotationDescr) {
                AnnotationDescr annotationDescr = (AnnotationDescr)descr;
                andDescr.addAnnotation(annotationDescr);
            } else {
                andDescr.addDescr(descr);
            }
        });
        return andDescr;
    }

    private List<BaseDescr> flattenAndDescr(List<DescrNodePair> descrList) {
        ArrayList<BaseDescr> flattenedDescrs = new ArrayList<BaseDescr>();
        for (DescrNodePair descrNodePair : descrList) {
            BaseDescr descr = descrNodePair.getDescr();
            ParseTree node = descrNodePair.getNode();
            if (descr instanceof AndDescr) {
                AndDescr andDescr = (AndDescr)descr;
                if (!(node instanceof DRL10Parser.LhsExpressionEnclosedContext)) {
                    flattenedDescrs.addAll(andDescr.getDescrs());
                    flattenedDescrs.addAll(andDescr.getAnnotations());
                    continue;
                }
            }
            flattenedDescrs.add(descr);
        }
        return flattenedDescrs;
    }

    @Override
    public BaseDescr visitLhsAndDef(DRL10Parser.LhsAndDefContext ctx) {
        return this.createAndDescr(ctx);
    }

    @Override
    public BaseDescr visitLhsUnary(DRL10Parser.LhsUnaryContext ctx) {
        List<BaseDescr> children = this.visitDescrChildren((RuleNode)ctx);
        if (children.size() > 1) {
            AndDescr andDescr = BaseDescrFactory.builder(new AndDescr()).withParserRuleContext(ctx).withResource(this.resource).build();
            children.forEach(arg_0 -> ((AndDescr)andDescr).addDescr(arg_0));
            return andDescr;
        }
        if (children.size() == 1) {
            return children.get(0);
        }
        return null;
    }

    private List<BaseDescr> visitDescrChildren(RuleNode node) {
        ArrayList<BaseDescr> aggregator = new ArrayList<BaseDescr>();
        int n = node.getChildCount();
        for (int i = 0; i < n && this.shouldVisitNextChild(node, aggregator); ++i) {
            ParseTree c = node.getChild(i);
            Object childResult = c.accept((ParseTreeVisitor)this);
            if (childResult instanceof BaseDescr) {
                aggregator.add((BaseDescr)childResult);
                continue;
            }
            if (!(childResult instanceof List)) continue;
            aggregator.addAll((List)childResult);
        }
        return aggregator;
    }

    private List<DescrNodePair> visitDescrChildrenForDescrNodePair(RuleNode node) {
        ArrayList<DescrNodePair> aggregator = new ArrayList<DescrNodePair>();
        int n = node.getChildCount();
        for (int i = 0; i < n && this.shouldVisitNextChild(node, aggregator); ++i) {
            ParseTree c = node.getChild(i);
            Object childResult = c.accept((ParseTreeVisitor)this);
            if (childResult instanceof BaseDescr) {
                aggregator.add(new DescrNodePair((BaseDescr)childResult, c));
                continue;
            }
            if (!(childResult instanceof List)) continue;
            List descrList = (List)childResult;
            descrList.forEach(descr -> aggregator.add(new DescrNodePair((BaseDescr)descr, c)));
        }
        return aggregator;
    }

    private String visitConstraintChildren(ParserRuleContext ctx) {
        return Antlr4ParserStringUtils.getTokenTextPreservingWhitespace(ctx, this.tokenStream);
    }

    private static class DescrNodePair {
        private final BaseDescr descr;
        private final ParseTree node;

        private DescrNodePair(BaseDescr descr, ParseTree node) {
            this.descr = descr;
            this.node = node;
        }

        public BaseDescr getDescr() {
            return this.descr;
        }

        public ParseTree getNode() {
            return this.node;
        }
    }
}

