/*
 * Decompiled with CFR 0.152.
 */
package org.drools.drl.parser.antlr4;

import java.util.Set;
import org.antlr.v4.runtime.CharStream;
import org.drools.drl.parser.antlr4.ParserHelper;

public class LexerHelper {
    private static final Set<Character> semiAndWS = Set.of(Character.valueOf(';'), Character.valueOf(' '), Character.valueOf('\t'), Character.valueOf('\n'), Character.valueOf('\r'));
    private static final Set<Character> delimiters = Set.of(Character.valueOf(';'), Character.valueOf(' '), Character.valueOf('\t'), Character.valueOf('\n'), Character.valueOf('\r'), Character.valueOf('\"'), Character.valueOf('\''));
    private static final Set<String> statementKeywordsList = Set.of(ParserHelper.statementKeywords);
    private static final Set<String> attributeKeywordsList = Set.of("salience", "enabled", "no-loop", "auto-focus", "lock-on-active", "agenda-group", "activation-group", "ruleflow-group", "date-effective", "date-expires", "dialect", "calendars", "timer", "duration", "refract", "direct");
    private final CharStream input;
    private int lookAheadCounter;

    public LexerHelper(CharStream input) {
        this.input = input;
        this.lookAheadCounter = 1;
    }

    boolean isRhsDrlEnd() {
        if (!this.validateDrlEnd()) {
            return false;
        }
        this.skipSemiAndWSAndComment();
        return this.validateEOForNextStatement();
    }

    private boolean validateDrlEnd() {
        return this.captureNextToken().equals("end");
    }

    private String captureNextToken() {
        int la;
        StringBuilder sb = new StringBuilder();
        while (!delimiters.contains(Character.valueOf((char)(la = this.input.LA(this.lookAheadCounter)))) && la != -1) {
            sb.append((char)la);
            ++this.lookAheadCounter;
        }
        return sb.toString();
    }

    private void skipSemiAndWSAndComment() {
        do {
            this.skipSemiAndWS();
        } while (this.skipComment());
    }

    private void skipSemiAndWS() {
        int la;
        while (semiAndWS.contains(Character.valueOf((char)(la = this.input.LA(this.lookAheadCounter))))) {
            ++this.lookAheadCounter;
        }
    }

    private boolean skipComment() {
        boolean skipped = false;
        int la1 = this.input.LA(this.lookAheadCounter);
        int la2 = this.input.LA(this.lookAheadCounter + 1);
        if (la1 == 47 && la2 == 47) {
            this.skipSingleLineComment();
            skipped = true;
        } else if (la1 == 47 && la2 == 42) {
            this.skipMultiLineComment();
            skipped = true;
        }
        return skipped;
    }

    private void skipSingleLineComment() {
        int la;
        while ((la = this.input.LA(this.lookAheadCounter)) != 10 && la != -1) {
            ++this.lookAheadCounter;
        }
    }

    private void skipMultiLineComment() {
        int la;
        while ((la = this.input.LA(this.lookAheadCounter)) != -1) {
            if (la == 42 && this.input.LA(this.lookAheadCounter + 1) == 47) {
                this.lookAheadCounter += 2;
                break;
            }
            ++this.lookAheadCounter;
        }
    }

    private boolean validateEOForNextStatement() {
        if (this.input.LA(this.lookAheadCounter) == -1) {
            return true;
        }
        String nextToken = this.captureNextToken();
        return statementKeywordsList.contains(nextToken) || attributeKeywordsList.contains(nextToken);
    }
}

