/*
 * Decompiled with CFR 0.152.
 */
package org.drools.drl.quarkus.util.deployment;

import io.quarkus.arc.deployment.GeneratedBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.builditem.GeneratedResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.maven.dependency.ResolvedDependency;
import io.quarkus.vertx.http.deployment.spi.AdditionalStaticResourceBuildItem;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.drools.codegen.common.AppPaths;
import org.drools.codegen.common.DroolsModelBuildContext;
import org.drools.codegen.common.GeneratedFile;
import org.drools.codegen.common.GeneratedFileType;
import org.drools.codegen.common.context.QuarkusDroolsModelBuildContext;
import org.drools.core.util.Drools;
import org.drools.drl.quarkus.util.deployment.GeneratedFileWriter;
import org.drools.wiring.api.ComponentsSupplier;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.kie.api.internal.utils.KieService;
import org.kie.memorycompiler.JavaCompiler;
import org.kie.memorycompiler.JavaCompilerSettings;
import org.kie.memorycompiler.KieMemoryCompiler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DroolsQuarkusResourceUtils {
    static final String HOT_RELOAD_SUPPORT_PACKAGE = "org.kie.kogito.app";
    static final String HOT_RELOAD_SUPPORT_CLASS = "HotReloadSupportClass";
    static final String HOT_RELOAD_SUPPORT_FQN = "org.kie.kogito.app.HotReloadSupportClass";
    public static final String HOT_RELOAD_SUPPORT_PATH = "org.kie.kogito.app.HotReloadSupportClass".replace('.', '/');
    private static final Logger LOGGER = LoggerFactory.getLogger(DroolsQuarkusResourceUtils.class);
    private static final GeneratedFileWriter.Builder generatedFileWriterBuilder;
    private static final DotName RULE_UNIT_DEF_INTERFACE;
    private static final String RULE_UNIT_DEF_PRODUCER = "import javax.enterprise.context.Dependent;\nimport javax.enterprise.inject.Produces;\n\nimport org.drools.ruleunits.api.RuleUnit;\nimport org.drools.ruleunits.api.RuleUnitProvider;\n\n@Dependent\npublic class $RULE_UNIT_NAME$Producer {\n\n    @Produces\n    public RuleUnit<$RULE_UNIT_NAME$> produceRuleUnit() {\n        return RuleUnitProvider.get().getRuleUnit(new $RULE_UNIT_NAME$());\n    }\n}\n";

    private DroolsQuarkusResourceUtils() {
    }

    public static DroolsModelBuildContext createDroolsBuildContext(Path outputTarget, Iterable<Path> paths, IndexView index) {
        AppPaths.BuildTool buildTool = AppPaths.BuildTool.findBuildTool();
        AppPaths appPaths = AppPaths.fromQuarkus((Path)outputTarget, paths, (AppPaths.BuildTool)buildTool);
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        DroolsModelBuildContext context = QuarkusDroolsModelBuildContext.builder().withClassLoader(classLoader).withClassAvailabilityResolver(className -> DroolsQuarkusResourceUtils.classAvailabilityResolver(classLoader, index, className)).withAppPaths(appPaths).build();
        return context;
    }

    private static boolean classAvailabilityResolver(ClassLoader classLoader, IndexView index, String className) {
        if (index != null) {
            boolean classFound;
            DotName classDotName = DotName.createSimple((String)className);
            boolean bl = classFound = !index.getAnnotations(classDotName).isEmpty() || index.getClassByName(classDotName) != null;
            if (classFound) {
                return true;
            }
        }
        try {
            classLoader.loadClass(className);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static void dumpFilesToDisk(AppPaths appPaths, Collection<GeneratedFile> generatedFiles) {
        generatedFileWriterBuilder.build(appPaths.getFirstProjectPath()).writeAll(generatedFiles);
    }

    public static void registerResources(Collection<GeneratedFile> generatedFiles, BuildProducer<AdditionalStaticResourceBuildItem> staticResProducer, BuildProducer<NativeImageResourceBuildItem> resource, BuildProducer<GeneratedResourceBuildItem> genResBI) {
        for (GeneratedFile f : generatedFiles) {
            if (f.category() == GeneratedFileType.Category.INTERNAL_RESOURCE || f.category() == GeneratedFileType.Category.STATIC_HTTP_RESOURCE) {
                genResBI.produce((BuildItem)new GeneratedResourceBuildItem(f.relativePath(), f.contents(), true));
                resource.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{f.relativePath()}));
            }
            if (f.category() != GeneratedFileType.Category.STATIC_HTTP_RESOURCE) continue;
            String resoucePath = f.relativePath().substring("META-INF/resources/".length() - 1);
            staticResProducer.produce((BuildItem)new AdditionalStaticResourceBuildItem(resoucePath, false));
        }
    }

    public static Collection<GeneratedBeanBuildItem> compileGeneratedSources(DroolsModelBuildContext context, Collection<ResolvedDependency> dependencies, Collection<GeneratedFile> generatedFiles, boolean useDebugSymbols) {
        Map<String, String> sourcesMap = DroolsQuarkusResourceUtils.getSourceMap(generatedFiles);
        if (sourcesMap.isEmpty()) {
            LOGGER.info("No Java source to compile");
            return Collections.emptyList();
        }
        JavaCompilerSettings compilerSettings = DroolsQuarkusResourceUtils.createJavaCompilerSettings(context, dependencies, useDebugSymbols);
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        return DroolsQuarkusResourceUtils.makeBuildItems(KieMemoryCompiler.compileNoLoad(sourcesMap, (ClassLoader)classLoader, (JavaCompilerSettings)compilerSettings));
    }

    private static JavaCompilerSettings createJavaCompilerSettings(DroolsModelBuildContext context, Collection<ResolvedDependency> dependencies, boolean useDebugSymbols) {
        JavaCompilerSettings compilerSettings = JavaCompiler.getCompiler().createDefaultSettings();
        compilerSettings.addOption("-proc:none");
        if (useDebugSymbols) {
            compilerSettings.addOption("-g");
            compilerSettings.addOption("-parameters");
        }
        for (Path classPath : context.getAppPaths().getClassesPaths()) {
            compilerSettings.addClasspath(classPath.toFile());
        }
        for (ResolvedDependency i : dependencies) {
            if (i.isResolved()) {
                compilerSettings.addClasspath(i.getResolvedPaths().getSinglePath().toFile());
                continue;
            }
            LOGGER.info("Ignoring non-resolved dependency {}", (Object)i.getKey().toGacString());
        }
        return compilerSettings;
    }

    private static Map<String, String> getSourceMap(Collection<GeneratedFile> generatedFiles) {
        HashMap<String, String> sourcesMap = new HashMap<String, String>();
        for (GeneratedFile javaFile : generatedFiles) {
            if (javaFile.category() != GeneratedFileType.Category.SOURCE) continue;
            sourcesMap.put(DroolsQuarkusResourceUtils.toClassName(javaFile.relativePath()), new String(javaFile.contents()));
        }
        return sourcesMap;
    }

    public static Collection<GeneratedBeanBuildItem> makeBuildItems(Map<String, byte[]> byteCodeMap) {
        ArrayList<GeneratedBeanBuildItem> buildItems = new ArrayList<GeneratedBeanBuildItem>();
        for (Map.Entry<String, byte[]> byteCode : byteCodeMap.entrySet()) {
            buildItems.add(new GeneratedBeanBuildItem(byteCode.getKey(), byteCode.getValue()));
        }
        return buildItems;
    }

    public static String toClassName(String sourceName) {
        if (sourceName.startsWith("./")) {
            sourceName = sourceName.substring(2);
        }
        if (sourceName.endsWith(".java")) {
            sourceName = sourceName.substring(0, sourceName.length() - 5);
        } else if (sourceName.endsWith(".class")) {
            sourceName = sourceName.substring(0, sourceName.length() - 6);
        }
        return sourceName.replace('/', '.').replace('\\', '.');
    }

    public static String getHotReloadSupportSource() {
        return "package org.kie.kogito.app;\n@io.quarkus.runtime.Startup()\npublic class HotReloadSupportClass {\nprivate static final String ID = \"" + UUID.randomUUID() + "\";\n}";
    }

    public static List<GeneratedFile> getRuleUnitDefProducerSource(IndexView indexView) {
        return indexView.getAllKnownImplementors(RULE_UNIT_DEF_INTERFACE).stream().map(ClassInfo::name).map(DroolsQuarkusResourceUtils::generateRuleUnitDefProducerSource).collect(Collectors.toList());
    }

    private static GeneratedFile generateRuleUnitDefProducerSource(DotName ruleUnitDefName) {
        String source = "package " + ruleUnitDefName.packagePrefix() + ";\n\n" + RULE_UNIT_DEF_PRODUCER.replaceAll("\\$RULE_UNIT_NAME\\$", ruleUnitDefName.withoutPackagePrefix());
        return new GeneratedFile(GeneratedFileType.SOURCE, ruleUnitDefName.toString().replace('.', '/') + "Producer.java", source);
    }

    static {
        if (Drools.isNativeImage() && !((ComponentsSupplier)KieService.load(ComponentsSupplier.class)).getClass().getSimpleName().equals("StaticComponentsSupplier")) {
            throw new IllegalStateException("Cannot run quarkus extension in native mode with module org.drools:drools-wiring-dynamic. Please remove it from your classpath.");
        }
        generatedFileWriterBuilder = new GeneratedFileWriter.Builder("target/classes", System.getProperty("drools.codegen.sources.directory", "target/generated-sources/drools/"), System.getProperty("drools.codegen.resources.directory", "target/generated-resources/drools/"), "target/generated-sources/drools/");
        RULE_UNIT_DEF_INTERFACE = DotName.createSimple((String)"org.drools.ruleunits.dsl.RuleUnitDefinition");
    }
}

