/*
 * Decompiled with CFR 0.152.
 */
package org.drools.drlonyaml.todrl;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateExceptionHandler;
import java.io.StringWriter;
import java.io.Writer;
import org.drools.drlonyaml.model.DrlPackage;
import org.drools.drlonyaml.model.Utils;

public class YAMLtoDrlDumper {
    public static final Configuration CONFIGURATION = YAMLtoDrlDumper.config();

    private static Configuration config() {
        Configuration cfg = new Configuration(Configuration.VERSION_2_3_32);
        cfg.setClassForTemplateLoading(YAMLtoDrlDumper.class, "/");
        cfg.setDefaultEncoding("UTF-8");
        cfg.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        cfg.setLogTemplateExceptions(false);
        cfg.setWrapUncheckedExceptions(true);
        cfg.setFallbackOnNullLoopVariable(false);
        return cfg;
    }

    public static String dumpDRL(DrlPackage drl) throws Exception {
        Template temp = CONFIGURATION.getTemplate("drl.ftl");
        StringWriter out = new StringWriter();
        temp.process((Object)drl, (Writer)out);
        String result = ((Object)out).toString();
        ((Writer)out).close();
        return result;
    }

    public static String yaml2drl(String yaml) throws Exception {
        DrlPackage readValue = (DrlPackage)Utils.getYamlMapper().readValue(yaml, DrlPackage.class);
        return YAMLtoDrlDumper.dumpDRL(readValue);
    }
}

