/*
 * Decompiled with CFR 0.152.
 */
package org.drools.games;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JFrame;
import org.drools.games.GameConfiguration;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.EntryPoint;

public class GameUI {
    private GameConfiguration conf;
    private Canvas canvas;
    KieSession ksession;

    public GameUI(KieSession ksession, GameConfiguration conf) {
        this.ksession = ksession;
        this.conf = conf;
    }

    public Graphics getGraphics() {
        return this.canvas.getBufferStrategy().getDrawGraphics();
    }

    public Canvas getCanvas() {
        return this.canvas;
    }

    public void init() {
        this.canvas = new Canvas();
        this.canvas.setBackground(Color.BLACK);
        this.canvas.setSize(new Dimension(this.conf.getWindowWidth(), this.conf.getWindowHeight()));
        GameKeyListener klistener = new GameKeyListener(this.ksession.getEntryPoint("KeyPressedStream"), this.ksession.getEntryPoint("KeyReleasedStream"));
        this.canvas.addKeyListener(klistener);
        this.canvas.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                GameUI.this.canvas.requestFocus();
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        JFrame frame = new JFrame();
        frame.setResizable(false);
        frame.setDefaultCloseOperation(this.conf.isExitOnClose() ? 3 : 2);
        frame.setSize(new Dimension(this.conf.getWindowWidth(), this.conf.getWindowHeight()));
        frame.setBackground(Color.BLACK);
        frame.add(this.canvas);
        frame.pack();
        frame.setVisible(true);
        frame.setLocationRelativeTo(null);
        this.canvas.createBufferStrategy(2);
        this.canvas.requestFocus();
    }

    public synchronized void show() {
        this.canvas.getBufferStrategy().show();
        Toolkit.getDefaultToolkit().sync();
    }

    public static class GameKeyListener
    implements KeyListener {
        EntryPoint keyPressedEntryPoint;
        EntryPoint keyReleasedEntryPoint;

        public GameKeyListener(EntryPoint keyPressedEntryPoint, EntryPoint keyReleasedEntryPoint) {
            this.keyPressedEntryPoint = keyPressedEntryPoint;
            this.keyReleasedEntryPoint = keyReleasedEntryPoint;
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            this.keyPressedEntryPoint.insert((Object)e);
        }

        @Override
        public void keyReleased(KeyEvent e) {
            this.keyReleasedEntryPoint.insert((Object)e);
        }
    }
}

