/*
 * Decompiled with CFR 0.152.
 */
package org.drools.examples.traits;

import java.util.Collection;
import org.drools.core.io.impl.ClassPathResource;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceType;
import org.kie.internal.KnowledgeBase;
import org.kie.internal.KnowledgeBaseFactory;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.runtime.StatefulKnowledgeSession;

public class TraitExample {
    private static StatefulKnowledgeSession getSession(String drl) {
        KnowledgeBuilder kBuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kBuilder.add((Resource)new ClassPathResource("org/drools/examples/traits/" + drl), ResourceType.DRL);
        if (kBuilder.hasErrors()) {
            System.err.println(kBuilder.getErrors().toString());
        }
        KnowledgeBase kBase = KnowledgeBaseFactory.newKnowledgeBase();
        kBase.addKnowledgePackages(kBuilder.getKnowledgePackages());
        return kBase.newStatefulKnowledgeSession();
    }

    public static void run(String demo) {
        StatefulKnowledgeSession kSession = TraitExample.getSession(demo);
        kSession.fireAllRules();
        Collection c = kSession.getObjects();
        System.out.println("------------------------- " + c.size() + " ----------------------");
        for (Object o : c) {
            System.out.println(" \t --- " + o);
        }
        System.out.println("-----------------------------------------------------------------");
        kSession.dispose();
    }

    public static void main(String[] args) {
        TraitExample.run("noTraits.drl");
        TraitExample.run("traitsDon.drl");
        TraitExample.run("multipleTraits.drl");
        TraitExample.run("traitsMixins.drl");
        TraitExample.run("traitsShed.drl");
    }
}

