/*
 * Decompiled with CFR 0.152.
 */
package org.drools.games.wumpus;

import java.util.Random;
import org.drools.games.wumpus.WumpusWorldConfiguration;
import org.drools.games.wumpus.view.GameUI;
import org.kie.api.KieServices;
import org.kie.api.runtime.Channel;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;

public class WumpusWorldMain {
    public static void main(String[] args) {
        KieContainer kc = KieServices.Factory.get().getKieClasspathContainer();
        new WumpusWorldMain().init(kc, true);
    }

    public void init(KieContainer kc, boolean exitOnClose) {
        final KieSession serverKsession = kc.newKieSession("WumpusMainKS");
        final KieSession clientKsession = kc.newKieSession("WumpusClientKS");
        serverKsession.getChannels().put("sensors", new Channel(){

            public void send(Object object) {
                clientKsession.insert(object);
                clientKsession.fireAllRules();
            }
        });
        clientKsession.getChannels().put("commands", new Channel(){

            public void send(Object object) {
                serverKsession.insert(object);
                serverKsession.fireAllRules();
            }
        });
        WumpusWorldConfiguration wumpusWorldConfiguration = new WumpusWorldConfiguration();
        wumpusWorldConfiguration.setExitOnClose(exitOnClose);
        serverKsession.setGlobal("wumpusWorldConfiguration", (Object)wumpusWorldConfiguration);
        serverKsession.setGlobal("randomInteger", (Object)new Random());
        GameUI gameUI = new GameUI(serverKsession, wumpusWorldConfiguration);
        serverKsession.insert((Object)gameUI);
        serverKsession.insert((Object)gameUI.getGameView());
        new Thread(new Runnable(){

            @Override
            public void run() {
                serverKsession.fireUntilHalt();
            }
        }).start();
        new Thread(new Runnable(){

            @Override
            public void run() {
                clientKsession.fireUntilHalt();
            }
        }).start();
    }
}

