/*
 * Decompiled with CFR 0.152.
 */
package org.drools.examples.helloworld;

import java.util.ArrayList;
import java.util.List;
import org.kie.api.KieServices;
import org.kie.api.event.KieRuntimeEventManager;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.event.rule.DebugAgendaEventListener;
import org.kie.api.event.rule.DebugRuleRuntimeEventListener;
import org.kie.api.event.rule.RuleRuntimeEventListener;
import org.kie.api.logger.KieRuntimeLogger;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;

public class HelloWorldExample {
    public static final void main(String[] args) {
        KieServices ks = KieServices.get();
        KieContainer kc = ks.getKieClasspathContainer();
        HelloWorldExample.execute(ks, kc);
    }

    public static void execute(KieServices ks, KieContainer kc) {
        KieSession ksession = kc.newKieSession("HelloWorldKS");
        ksession.setGlobal("list", new ArrayList());
        ksession.addEventListener((AgendaEventListener)new DebugAgendaEventListener());
        ksession.addEventListener((RuleRuntimeEventListener)new DebugRuleRuntimeEventListener());
        KieRuntimeLogger logger = ks.getLoggers().newFileLogger((KieRuntimeEventManager)ksession, "./helloworld");
        Message message = new Message();
        message.setMessage("Hello World");
        message.setStatus(0);
        ksession.insert((Object)message);
        ksession.fireAllRules();
        logger.close();
        ksession.dispose();
    }

    public static class Message {
        public static final int HELLO = 0;
        public static final int GOODBYE = 1;
        private String message;
        private int status;

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public int getStatus() {
            return this.status;
        }

        public void setStatus(int status) {
            this.status = status;
        }

        public static Message doSomething(Message message) {
            return message;
        }

        public boolean isSomething(String msg, List<Object> list) {
            list.add(this);
            return this.message.equals(msg);
        }
    }
}

