/*
 * Decompiled with CFR 0.152.
 */
package org.drools.examples.troubleticket;

import org.drools.examples.troubleticket.Customer;
import org.drools.examples.troubleticket.Ticket;
import org.kie.api.KieServices;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.FactHandle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TroubleTicketExampleWithDT {
    private static final Logger LOG = LoggerFactory.getLogger(TroubleTicketExampleWithDT.class);

    public static void main(String[] args) {
        KieContainer kc = KieServices.Factory.get().getKieClasspathContainer();
        TroubleTicketExampleWithDT.execute(kc);
    }

    public static void execute(KieContainer kc) {
        KieSession ksession = kc.newKieSession("TroubleTicketWithDTKS");
        Customer a = new Customer("A", "Drools", "Gold");
        Customer b = new Customer("B", "Drools", "Platinum");
        Customer c = new Customer("C", "Drools", "Silver");
        Customer d = new Customer("D", "Drools", "Silver");
        Ticket t1 = new Ticket(a);
        Ticket t2 = new Ticket(b);
        Ticket t3 = new Ticket(c);
        Ticket t4 = new Ticket(d);
        ksession.insert((Object)a);
        ksession.insert((Object)b);
        ksession.insert((Object)c);
        ksession.insert((Object)d);
        ksession.insert((Object)t1);
        ksession.insert((Object)t2);
        FactHandle ft3 = ksession.insert((Object)t3);
        ksession.insert((Object)t4);
        ksession.fireAllRules();
        t3.setStatus("Done");
        ksession.update(ft3, (Object)t3);
        try {
            System.err.println("[[ Sleeping 5 seconds ]]");
            Thread.sleep(5000L);
        }
        catch (InterruptedException e) {
            LOG.error("Exception", (Throwable)e);
        }
        System.err.println("[[ awake ]]");
        ksession.dispose();
    }
}

