/*
 * Decompiled with CFR 0.152.
 */
package drools.rex;

import java.io.InputStream;
import java.rmi.RemoteException;
import java.util.Properties;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.drools.agent.KnowledgeAgent;
import org.drools.io.ResourceChangeScannerConfiguration;
import org.drools.io.ResourceFactory;
import scala.MatchError;
import scala.ScalaObject;

public class AgentListener
implements ServletContextListener,
ScalaObject {
    public void contextDestroyed(ServletContextEvent ev) {
        ev.getServletContext().log("Stopping knowledge agent service");
        ResourceFactory.getResourceChangeNotifierService().stop();
        ResourceFactory.getResourceChangeScannerService().stop();
    }

    public void contextInitialized(ServletContextEvent ev) {
        ev.getServletContext().log("Starting knowledge agent service...");
        ResourceFactory.getResourceChangeNotifierService().start();
        ResourceFactory.getResourceChangeScannerService().start();
        InputStream inputStream = KnowledgeAgent.class.getResourceAsStream("/scanner.properties");
        if (inputStream == null) {
            ev.getServletContext().log("Using default scanner settings...");
        } else {
            if (inputStream == null) {
                throw new MatchError((Object)inputStream);
            }
            Properties props = new Properties();
            props.load(inputStream);
            ResourceChangeScannerConfiguration conf = ResourceFactory.getResourceChangeScannerService().newResourceChangeScannerConfiguration(props);
            ResourceFactory.getResourceChangeScannerService().configure(conf);
            ev.getServletContext().log("Using scanner.properties");
        }
    }

    public int $tag() throws RemoteException {
        return ScalaObject.class.$tag((ScalaObject)this);
    }
}

