/*
 * Decompiled with CFR 0.152.
 */
package drools.rex;

import java.rmi.RemoteException;
import javax.servlet.http.HttpSession;
import org.drools.agent.KnowledgeAgent;
import org.drools.agent.KnowledgeAgentFactory;
import org.drools.io.ResourceFactory;
import org.drools.runtime.StatefulKnowledgeSession;
import scala.ScalaObject;
import scala.StringBuilder;

public class ExecutionServerHelper
implements ScalaObject {
    private final String AGENT_CONFIG_DIRECTORY;
    private final String KNOWLEDGE_SESSION;
    private final HttpSession session;

    public ExecutionServerHelper(HttpSession session) {
        this.session = session;
        this.KNOWLEDGE_SESSION = "knowledge.session";
        this.AGENT_CONFIG_DIRECTORY = "agent-config-directory";
    }

    public StatefulKnowledgeSession newKnowledgeSession(String agentName) {
        this.removeKnowledgeSession();
        String agentFile = new StringBuilder().append((Object)"/").append((Object)agentName).append((Object)".xml").toString();
        String agentConfigDir = this.session().getServletContext().getInitParameter(this.AGENT_CONFIG_DIRECTORY());
        KnowledgeAgent knowledgeAgent = KnowledgeAgentFactory.newKnowledgeAgent((String)agentFile);
        if (agentConfigDir.startsWith("classpath:")) {
            knowledgeAgent.applyChangeSet(ResourceFactory.newClassPathResource((String)new StringBuilder().append((Object)agentConfigDir.replace("classpath:", "")).append((Object)agentFile).toString()));
        } else {
            knowledgeAgent.applyChangeSet(ResourceFactory.newUrlResource((String)new StringBuilder().append((Object)agentConfigDir).append((Object)agentFile).toString()));
        }
        StatefulKnowledgeSession knowledgeSession = knowledgeAgent.getKnowledgeBase().newStatefulKnowledgeSession();
        this.session().setAttribute(this.KNOWLEDGE_SESSION(), (Object)knowledgeSession);
        return knowledgeSession;
    }

    public void removeKnowledgeSession() {
        StatefulKnowledgeSession knowledgeSession = this.getKnowledgeSession();
        StatefulKnowledgeSession statefulKnowledgeSession = knowledgeSession;
        if (statefulKnowledgeSession != null && !statefulKnowledgeSession.equals(null) && knowledgeSession instanceof StatefulKnowledgeSession) {
            knowledgeSession.dispose();
            this.session().removeAttribute(this.KNOWLEDGE_SESSION());
        }
    }

    public StatefulKnowledgeSession getKnowledgeSession() {
        return (StatefulKnowledgeSession)this.session().getAttribute(this.KNOWLEDGE_SESSION());
    }

    public String AGENT_CONFIG_DIRECTORY() {
        return this.AGENT_CONFIG_DIRECTORY;
    }

    public String KNOWLEDGE_SESSION() {
        return this.KNOWLEDGE_SESSION;
    }

    public HttpSession session() {
        return this.session;
    }

    public int $tag() throws RemoteException {
        return ScalaObject.class.$tag((ScalaObject)this);
    }
}

