/*
 * Decompiled with CFR 0.152.
 */
package drools.rex;

import drools.rex.LoopDetectorListener$;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import org.drools.event.rule.ActivationCancelledEvent;
import org.drools.event.rule.ActivationCreatedEvent;
import org.drools.event.rule.AfterActivationFiredEvent;
import org.drools.event.rule.AgendaEventListener;
import org.drools.event.rule.AgendaGroupPoppedEvent;
import org.drools.event.rule.AgendaGroupPushedEvent;
import org.drools.event.rule.BeforeActivationFiredEvent;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.Iterable;
import scala.MatchError;
import scala.Predef$;
import scala.ScalaObject;
import scala.Seq;
import scala.StringBuilder;
import scala.Tuple2;
import scala.runtime.BoxedArray;
import scala.runtime.BoxedObjectArray;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoopDetectorListener
implements AgendaEventListener,
ScalaObject {
    private ArrayList firingTrail;
    private int currentCount;
    private final Function1 logger;
    private final int loopSize;
    private final int firingsOfInterest;

    public LoopDetectorListener(int firingsOfInterest, int loopSize, Function1<String, Object> logger) {
        this.firingsOfInterest = firingsOfInterest;
        this.loopSize = loopSize;
        this.logger = logger;
        this.currentCount = 0;
        this.firingTrail = new ArrayList(firingsOfInterest);
    }

    public String inv(List<String> a, int i) {
        return a.get(a.size() - i - 1);
    }

    public Tuple2<String[], Integer> locateLoop(List<String> list) {
        String endVal = this.inv(list, 0);
        Object object = ScalaRunTime$.MODULE$.arrayValue(Array$.MODULE$.apply((Seq)new BoxedObjectArray((Object[])new String[]{endVal})), String.class);
        String[] pattern = (String[])(object instanceof BoxedArray ? ScalaRunTime$.MODULE$.arrayValue((BoxedArray)object, String.class) : object);
        boolean cycleSuspected = false;
        boolean confirmed = false;
        int cycleY = 0;
        int cycleX = 0;
        for (int i = 1; i < list.size() - 1 && !confirmed; ++i) {
            String v;
            String string = v = this.inv(list, i);
            String string2 = endVal;
            if (string != null ? !string.equals(string2) : string2 != null) continue;
            cycleSuspected = true;
            cycleX = 0;
            cycleY = i;
            Object object2 = ScalaRunTime$.MODULE$.arrayValue(Array$.MODULE$.apply((Seq)new BoxedObjectArray((Object[])new String[]{endVal})), String.class);
            String[] repeatingItems = (String[])(object2 instanceof BoxedArray ? ScalaRunTime$.MODULE$.arrayValue((BoxedArray)object2, String.class) : object2);
            while (cycleSuspected) {
                ++cycleX;
                if (++cycleY < list.size()) {
                    String string3 = this.inv(list, cycleX);
                    String string4 = this.inv(list, cycleY);
                    if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                        if (cycleX == i) {
                            confirmed = true;
                        }
                        if (confirmed) continue;
                        Object object3 = ScalaRunTime$.MODULE$.arrayValue(new BoxedObjectArray((Object[])repeatingItems).$plus$plus((Iterable)Array$.MODULE$.apply((Seq)new BoxedObjectArray((Object[])new String[]{this.inv(list, cycleX)}))), String.class);
                        repeatingItems = (String[])(object3 instanceof BoxedArray ? ScalaRunTime$.MODULE$.arrayValue((BoxedArray)object3, String.class) : object3);
                        continue;
                    }
                    if (cycleX >= i) {
                        pattern = repeatingItems;
                    }
                    cycleSuspected = false;
                    continue;
                }
                pattern = repeatingItems;
                cycleSuspected = false;
            }
        }
        return new Tuple2((Object)Predef$.MODULE$.forceArrayProjection(new BoxedObjectArray((Object[])pattern).reverse()), (Object)BoxesRunTime.boxToInteger((int)cycleY));
    }

    public void agendaGroupPushed(AgendaGroupPushedEvent event) {
    }

    public void activationCreated(ActivationCreatedEvent event) {
    }

    public void beforeActivationFired(BeforeActivationFiredEvent event) {
    }

    public void agendaGroupPopped(AgendaGroupPoppedEvent event) {
    }

    public void activationCancelled(ActivationCancelledEvent event) {
    }

    public void afterActivationFired(AfterActivationFiredEvent event) {
        this.currentCount_$eq(this.currentCount() + 1);
        if (this.currentCount() > this.firingsOfInterest) {
            if (this.currentCount() % this.firingsOfInterest == 0) {
                int repetitions;
                Tuple2<String[], Integer> tuple2 = this.locateLoop(this.firingTrail());
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                Tuple2 tuple22 = new Tuple2(tuple2._1(), tuple2._2());
                String[] loop = (String[])(tuple22._1() instanceof BoxedArray ? ScalaRunTime$.MODULE$.arrayValue((BoxedArray)tuple22._1(), String.class) : tuple22._1());
                int number = BoxesRunTime.unboxToInt((Object)tuple22._2());
                int n = repetitions = loop.length > 0 ? number / loop.length : 0;
                if (repetitions >= this.loopSize) {
                    this.logger.apply((Object)new StringBuilder().append(this.currentCount()).append((Object)" firings of rule names: [").append(new BoxedObjectArray((Object[])loop).foldLeft((Object)"", (Function2)new $anonfun$afterActivationFired$1(this))).append((Object)"]").toString());
                    event.getKnowledgeRuntime().halt();
                }
                this.firingTrail_$eq(new ArrayList<String>());
            } else {
                this.firingTrail().add(event.getActivation().getRule().getName());
            }
        }
    }

    public void firingTrail_$eq(ArrayList<String> x$1) {
        this.firingTrail = x$1;
    }

    public ArrayList<String> firingTrail() {
        return this.firingTrail;
    }

    public void currentCount_$eq(int x$1) {
        this.currentCount = x$1;
    }

    public int currentCount() {
        return this.currentCount;
    }

    public int $tag() throws RemoteException {
        return ScalaObject.class.$tag((ScalaObject)this);
    }
}

