/*
 * Decompiled with CFR 0.152.
 */
package org.drools.grid.remote;

import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.drools.KnowledgeBaseFactoryService;
import org.drools.builder.KnowledgeBuilderFactoryService;
import org.drools.grid.Grid;
import org.drools.grid.GridNode;
import org.drools.grid.GridServiceDescription;
import org.drools.grid.io.ConversationManager;
import org.drools.grid.io.impl.CommandImpl;
import org.drools.grid.remote.ConversationUtil;
import org.drools.grid.remote.KnowledgeBaseProviderRemoteClient;
import org.drools.grid.remote.KnowledgeBuilderProviderRemoteClient;
import org.drools.grid.remote.StatefulKnowledgeSessionRemoteClient;
import org.drools.grid.remote.mina.MinaConnector;
import org.drools.util.ServiceRegistry;
import org.drools.util.ServiceRegistryImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GridNodeRemoteClient<T>
implements GridNode {
    private GridServiceDescription gsd;
    private Grid grid;
    private final Map<String, Object> localContext = new ConcurrentHashMap<String, Object>();
    private final ServiceRegistry serviceRegistry = ServiceRegistryImpl.getInstance();
    private MinaConnector connector = new MinaConnector();

    public GridNodeRemoteClient(Grid grid, GridServiceDescription gsd) {
        this.gsd = gsd;
        this.grid = grid;
        this.init(this.localContext);
    }

    @Override
    public <T> T get(String identifier, Class<T> cls) {
        Object service = this.localContext.get(identifier);
        if (service == null) {
            service = this.serviceRegistry.get(cls);
        }
        return (T)service;
    }

    @Override
    public <T> T get(Class<T> serviceClass) {
        return this.get(serviceClass.getName(), serviceClass);
    }

    @Override
    public void set(String identifier, Object object) {
        if (!(object instanceof StatefulKnowledgeSessionRemoteClient)) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
        String localId = UUID.randomUUID().toString();
        CommandImpl cmd = new CommandImpl("registerKsession", Arrays.asList(identifier, ((StatefulKnowledgeSessionRemoteClient)object).getInstanceId()));
        ConversationManager connm = this.grid.get(ConversationManager.class);
        ConversationUtil.sendMessage(connm, (InetSocketAddress)this.gsd.getAddresses().get("socket").getObject(), this.gsd.getId(), cmd);
    }

    @Override
    public String getId() {
        return this.gsd.getId();
    }

    @Override
    public void init(Object context) {
        this.localContext.put(KnowledgeBuilderFactoryService.class.getName(), new KnowledgeBuilderProviderRemoteClient(this.grid, this.gsd));
        this.localContext.put(KnowledgeBaseFactoryService.class.getName(), new KnowledgeBaseProviderRemoteClient(this.grid, this.gsd));
    }

    @Override
    public void dispose() {
        this.connector.close();
    }
}

