/*
 * Decompiled with CFR 0.152.
 */
package org.drools.grid.task;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.core.session.IoSession;
import org.drools.SystemEventListener;
import org.drools.eventmessaging.EventKey;
import org.drools.eventmessaging.EventTriggerTransport;
import org.drools.grid.generic.GenericIoWriter;
import org.drools.grid.generic.GenericMessageHandler;
import org.drools.grid.generic.Message;
import org.drools.grid.task.GenericEventTransport;
import org.drools.task.Attachment;
import org.drools.task.Comment;
import org.drools.task.Content;
import org.drools.task.Task;
import org.drools.task.service.Command;
import org.drools.task.service.CommandName;
import org.drools.task.service.ContentData;
import org.drools.task.service.Operation;
import org.drools.task.service.TaskService;
import org.drools.task.service.TaskServiceSession;

public class TaskServerMessageHandlerImpl
implements GenericMessageHandler {
    private final TaskService service;
    private final Map<String, GenericIoWriter> clients;
    private final SystemEventListener systemEventListener;

    public TaskServerMessageHandlerImpl(TaskService service, SystemEventListener systemEventListener) {
        this.service = service;
        this.clients = new HashMap<String, GenericIoWriter>();
        this.systemEventListener = systemEventListener;
    }

    public void exceptionCaught(IoSession session, Throwable cause) throws Exception {
        this.systemEventListener.exception("Uncaught exception on Server", cause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void messageReceived(GenericIoWriter session, Message msg) throws Exception {
        Command cmd = (Command)msg.getPayload();
        TaskServiceSession taskSession = this.service.createSession();
        CommandName response = null;
        try {
            this.systemEventListener.debug("Message received on server : " + cmd.getName());
            this.systemEventListener.debug("Arguments : " + Arrays.toString(cmd.getArguments().toArray()));
            switch (cmd.getName()) {
                case OperationRequest: {
                    response = CommandName.OperationResponse;
                    Operation operation = (Operation)cmd.getArguments().get(0);
                    this.systemEventListener.debug("Command receieved on server was operation of type: " + operation);
                    long taskId = (Long)cmd.getArguments().get(1);
                    String userId = (String)cmd.getArguments().get(2);
                    String targetEntityId = null;
                    if (cmd.getArguments().size() > 3) {
                        targetEntityId = (String)cmd.getArguments().get(3);
                    }
                    ContentData data = null;
                    if (cmd.getArguments().size() > 4) {
                        data = (ContentData)cmd.getArguments().get(4);
                    }
                    taskSession.taskOperation(operation, taskId, userId, targetEntityId, data);
                    List args = Collections.emptyList();
                    Command resultsCmnd = new Command(cmd.getId(), CommandName.OperationResponse, args);
                    session.write(new Message(msg.getSessionId(), msg.getResponseId(), msg.isAsync(), (Object)resultsCmnd), null);
                    return;
                }
                case GetTaskRequest: {
                    response = CommandName.GetTaskResponse;
                    long taskId = (Long)cmd.getArguments().get(0);
                    Task task = taskSession.getTask(taskId);
                    ArrayList<Task> args = new ArrayList<Task>(1);
                    args.add(task);
                    Command resultsCmnd = new Command(cmd.getId(), CommandName.GetTaskResponse, args);
                    session.write(new Message(msg.getSessionId(), msg.getResponseId(), msg.isAsync(), (Object)resultsCmnd), null);
                    return;
                }
                case AddTaskRequest: {
                    response = CommandName.AddTaskResponse;
                    Task task = (Task)cmd.getArguments().get(0);
                    ContentData content = (ContentData)cmd.getArguments().get(1);
                    taskSession.addTask(task, content);
                    ArrayList<Long> args = new ArrayList<Long>(1);
                    args.add(task.getId());
                    Command resultsCmnd = new Command(cmd.getId(), CommandName.AddTaskResponse, args);
                    session.write(new Message(msg.getSessionId(), msg.getResponseId(), msg.isAsync(), (Object)resultsCmnd), null);
                    return;
                }
                case AddCommentRequest: {
                    response = CommandName.AddCommentResponse;
                    Comment comment = (Comment)cmd.getArguments().get(1);
                    taskSession.addComment(((Long)cmd.getArguments().get(0)).longValue(), comment);
                    ArrayList<Long> args = new ArrayList<Long>(1);
                    args.add(comment.getId());
                    Command resultsCmnd = new Command(cmd.getId(), CommandName.AddCommentResponse, args);
                    session.write(new Message(msg.getSessionId(), msg.getResponseId(), msg.isAsync(), (Object)resultsCmnd), null);
                    return;
                }
                case DeleteCommentRequest: {
                    response = CommandName.DeleteCommentResponse;
                    long taskId = (Long)cmd.getArguments().get(0);
                    long commentId = (Long)cmd.getArguments().get(1);
                    taskSession.deleteComment(taskId, commentId);
                    Command resultsCmnd = new Command(cmd.getId(), CommandName.DeleteCommentResponse, Collections.emptyList());
                    session.write(new Message(msg.getSessionId(), msg.getResponseId(), msg.isAsync(), (Object)resultsCmnd), null);
                    return;
                }
                case AddAttachmentRequest: {
                    response = CommandName.AddAttachmentResponse;
                    Attachment attachment = (Attachment)cmd.getArguments().get(1);
                    Content content = (Content)cmd.getArguments().get(2);
                    taskSession.addAttachment(((Long)cmd.getArguments().get(0)).longValue(), attachment, content);
                    ArrayList<Long> args = new ArrayList<Long>(2);
                    args.add(attachment.getId());
                    args.add(content.getId());
                    Command resultsCmnd = new Command(cmd.getId(), CommandName.AddAttachmentResponse, args);
                    session.write(new Message(msg.getSessionId(), msg.getResponseId(), msg.isAsync(), (Object)resultsCmnd), null);
                    return;
                }
                case DeleteAttachmentRequest: {
                    response = CommandName.DeleteAttachmentResponse;
                    long taskId = (Long)cmd.getArguments().get(0);
                    long attachmentId = (Long)cmd.getArguments().get(1);
                    long contentId = (Long)cmd.getArguments().get(2);
                    taskSession.deleteAttachment(taskId, attachmentId, contentId);
                    Command resultsCmnd = new Command(cmd.getId(), CommandName.DeleteAttachmentResponse, Collections.emptyList());
                    session.write(new Message(msg.getSessionId(), msg.getResponseId(), msg.isAsync(), (Object)resultsCmnd), null);
                    return;
                }
                case SetDocumentContentRequest: {
                    response = CommandName.SetDocumentContentResponse;
                    long taskId = (Long)cmd.getArguments().get(0);
                    Content content = (Content)cmd.getArguments().get(1);
                    taskSession.setDocumentContent(taskId, content);
                    ArrayList<Long> args = new ArrayList<Long>(1);
                    args.add(content.getId());
                    Command resultsCmnd = new Command(cmd.getId(), CommandName.SetDocumentContentResponse, args);
                    session.write(new Message(msg.getSessionId(), msg.getResponseId(), msg.isAsync(), (Object)resultsCmnd), null);
                    return;
                }
                case GetContentRequest: {
                    response = CommandName.GetContentResponse;
                    long contentId = (Long)cmd.getArguments().get(0);
                    Content content = taskSession.getContent(contentId);
                    ArrayList<Content> args = new ArrayList<Content>(1);
                    args.add(content);
                    Command resultsCmnd = new Command(cmd.getId(), CommandName.GetContentResponse, args);
                    session.write(new Message(msg.getSessionId(), msg.getResponseId(), msg.isAsync(), (Object)resultsCmnd), null);
                    return;
                }
                case QueryTasksOwned: {
                    response = CommandName.QueryTaskSummaryResponse;
                    List results = taskSession.getTasksOwned((String)cmd.getArguments().get(0), (String)cmd.getArguments().get(1));
                    ArrayList<List> args = new ArrayList<List>(1);
                    args.add(results);
                    Command resultsCmnd = new Command(cmd.getId(), CommandName.QueryTaskSummaryResponse, args);
                    session.write(new Message(msg.getSessionId(), msg.getResponseId(), msg.isAsync(), (Object)resultsCmnd), null);
                    return;
                }
                case QueryTasksAssignedAsBusinessAdministrator: {
                    response = CommandName.QueryTaskSummaryResponse;
                    List results = taskSession.getTasksAssignedAsBusinessAdministrator((String)cmd.getArguments().get(0), (String)cmd.getArguments().get(1));
                    ArrayList<List> args = new ArrayList<List>(1);
                    args.add(results);
                    Command resultsCmnd = new Command(cmd.getId(), CommandName.QueryTaskSummaryResponse, args);
                    session.write(new Message(msg.getSessionId(), msg.getResponseId(), msg.isAsync(), (Object)resultsCmnd), null);
                    return;
                }
                case QueryTasksAssignedAsPotentialOwner: {
                    response = CommandName.QueryTaskSummaryResponse;
                    List results = taskSession.getTasksAssignedAsPotentialOwner((String)cmd.getArguments().get(0), (String)cmd.getArguments().get(1));
                    ArrayList<List> args = new ArrayList<List>(1);
                    args.add(results);
                    Command resultsCmnd = new Command(cmd.getId(), CommandName.QueryTaskSummaryResponse, args);
                    session.write(new Message(msg.getSessionId(), msg.getResponseId(), msg.isAsync(), (Object)resultsCmnd), null);
                    return;
                }
                case QueryTasksAssignedAsPotentialOwnerWithGroup: {
                    response = CommandName.QueryTaskSummaryResponse;
                    List results = taskSession.getTasksAssignedAsPotentialOwner((String)cmd.getArguments().get(0), (List)cmd.getArguments().get(1), (String)cmd.getArguments().get(2));
                    ArrayList<List> args = new ArrayList<List>(1);
                    args.add(results);
                    Command resultsCmnd = new Command(cmd.getId(), CommandName.QueryTaskSummaryResponse, args);
                    session.write(new Message(msg.getSessionId(), msg.getResponseId(), msg.isAsync(), (Object)resultsCmnd), null);
                    return;
                }
                case QueryTasksAssignedAsPotentialOwnerByGroup: {
                    response = CommandName.QueryTaskSummaryResponse;
                    List results = taskSession.getTasksAssignedAsPotentialOwnerByGroup((String)cmd.getArguments().get(0), (String)cmd.getArguments().get(1));
                    ArrayList<List> args = new ArrayList<List>(1);
                    args.add(results);
                    Command resultsCmnd = new Command(cmd.getId(), CommandName.QueryTaskSummaryResponse, args);
                    session.write(new Message(msg.getSessionId(), msg.getResponseId(), msg.isAsync(), (Object)resultsCmnd), null);
                    return;
                }
                case QuerySubTasksAssignedAsPotentialOwner: {
                    response = CommandName.QueryTaskSummaryResponse;
                    List results = taskSession.getSubTasksAssignedAsPotentialOwner(((Long)cmd.getArguments().get(0)).longValue(), (String)cmd.getArguments().get(1), (String)cmd.getArguments().get(2));
                    ArrayList<List> args = new ArrayList<List>(1);
                    args.add(results);
                    Command resultsCmnd = new Command(cmd.getId(), CommandName.QueryTaskSummaryResponse, args);
                    session.write(new Message(msg.getSessionId(), msg.getResponseId(), msg.isAsync(), (Object)resultsCmnd), null);
                    return;
                }
                case QueryGetSubTasksByParentTaskId: {
                    response = CommandName.QueryTaskSummaryResponse;
                    List results = taskSession.getSubTasksByParent(((Long)cmd.getArguments().get(0)).longValue(), (String)cmd.getArguments().get(1));
                    ArrayList<List> args = new ArrayList<List>(1);
                    args.add(results);
                    Command resultsCmnd = new Command(cmd.getId(), CommandName.QueryTaskSummaryResponse, args);
                    session.write(new Message(msg.getSessionId(), msg.getResponseId(), msg.isAsync(), (Object)resultsCmnd), null);
                    return;
                }
                case QueryTasksAssignedAsTaskInitiator: {
                    response = CommandName.QueryTaskSummaryResponse;
                    List results = taskSession.getTasksAssignedAsTaskInitiator((String)cmd.getArguments().get(0), (String)cmd.getArguments().get(1));
                    ArrayList<List> args = new ArrayList<List>(1);
                    args.add(results);
                    Command resultsCmnd = new Command(cmd.getId(), CommandName.QueryTaskSummaryResponse, args);
                    session.write(new Message(msg.getSessionId(), msg.getResponseId(), msg.isAsync(), (Object)resultsCmnd), null);
                    return;
                }
                case QueryTasksAssignedAsExcludedOwner: {
                    response = CommandName.QueryTaskSummaryResponse;
                    List results = taskSession.getTasksAssignedAsExcludedOwner((String)cmd.getArguments().get(0), (String)cmd.getArguments().get(1));
                    ArrayList<List> args = new ArrayList<List>(1);
                    args.add(results);
                    Command resultsCmnd = new Command(cmd.getId(), CommandName.QueryTaskSummaryResponse, args);
                    session.write(new Message(msg.getSessionId(), msg.getResponseId(), msg.isAsync(), (Object)resultsCmnd), null);
                    return;
                }
                case QueryTasksAssignedAsRecipient: {
                    response = CommandName.QueryTaskSummaryResponse;
                    List results = taskSession.getTasksAssignedAsRecipient((String)cmd.getArguments().get(0), (String)cmd.getArguments().get(1));
                    ArrayList<List> args = new ArrayList<List>(1);
                    args.add(results);
                    Command resultsCmnd = new Command(cmd.getId(), CommandName.QueryTaskSummaryResponse, args);
                    session.write(new Message(msg.getSessionId(), msg.getResponseId(), msg.isAsync(), (Object)resultsCmnd), null);
                    return;
                }
                case QueryTasksAssignedAsTaskStakeholder: {
                    response = CommandName.QueryTaskSummaryResponse;
                    List results = taskSession.getTasksAssignedAsTaskStakeholder((String)cmd.getArguments().get(0), (String)cmd.getArguments().get(1));
                    ArrayList<List> args = new ArrayList<List>(1);
                    args.add(results);
                    Command resultsCmnd = new Command(cmd.getId(), CommandName.QueryTaskSummaryResponse, args);
                    session.write(new Message(msg.getSessionId(), msg.getResponseId(), msg.isAsync(), (Object)resultsCmnd), null);
                    return;
                }
                case RegisterForEventRequest: {
                    response = CommandName.EventTriggerResponse;
                    EventKey key = (EventKey)cmd.getArguments().get(0);
                    boolean remove = (Boolean)cmd.getArguments().get(1);
                    String uuid = (String)cmd.getArguments().get(2);
                    this.clients.put(uuid, session);
                    GenericEventTransport transport = new GenericEventTransport(String.valueOf(msg.getSessionId()), msg.getResponseId(), this.clients, remove);
                    this.service.getEventKeys().register(key, (EventTriggerTransport)transport);
                    return;
                }
                case RegisterClient: {
                    String uuid = (String)cmd.getArguments().get(0);
                    this.clients.put(uuid, session);
                    return;
                }
                default: {
                    this.systemEventListener.debug("Unknown command recieved on server");
                    return;
                }
            }
        }
        catch (RuntimeException e) {
            this.systemEventListener.exception(e.getMessage(), (Throwable)e);
            e.printStackTrace(System.err);
            ArrayList<RuntimeException> list = new ArrayList<RuntimeException>(1);
            list.add(e);
            Command resultsCmnd = new Command(cmd.getId(), response, list);
            session.write(new Message(msg.getSessionId(), msg.getResponseId(), msg.isAsync(), (Object)resultsCmnd), null);
            return;
        }
        finally {
            taskSession.dispose();
        }
    }

    public void sessionIdle(IoSession session, IdleStatus status) throws Exception {
        this.systemEventListener.debug("Server IDLE " + session.getIdleCount(status));
    }
}

