/*
 * Decompiled with CFR 0.152.
 */
package net.sf.webdav.methods;

import java.io.IOException;
import java.io.InputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.webdav.ResourceLocks;
import net.sf.webdav.WebdavStore;
import net.sf.webdav.exceptions.AccessDeniedException;
import net.sf.webdav.exceptions.WebdavException;
import net.sf.webdav.methods.AbstractMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DoPut
extends AbstractMethod {
    private static Logger log = LoggerFactory.getLogger((String)"net.sf.webdav.methods");
    private WebdavStore store;
    private ResourceLocks resLocks;
    private boolean readOnly;
    private boolean lazyFolderCreationOnPut;

    public DoPut(WebdavStore store, ResourceLocks resLocks, boolean readOnly, boolean lazyFolderCreationOnPut) {
        this.store = store;
        this.resLocks = resLocks;
        this.readOnly = readOnly;
        this.lazyFolderCreationOnPut = lazyFolderCreationOnPut;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        log.trace("-- " + this.getClass().getName());
        if (!this.readOnly) {
            String path = this.getRelativePath(req);
            String parentPath = this.getParentPath(path);
            String lockOwner = "doPut" + System.currentTimeMillis() + req.toString();
            if (this.resLocks.lock(path, lockOwner, true, -1)) {
                try {
                    if (parentPath != null && !this.store.isFolder(parentPath) && this.lazyFolderCreationOnPut) {
                        this.store.createFolder(parentPath);
                    }
                    if (this.store.isFolder(path)) return;
                    if (!this.store.objectExists(path)) {
                        this.store.createResource(path);
                        resp.setStatus(201);
                    } else {
                        String userAgent = req.getHeader("User-Agent");
                        if (userAgent.contains("WebDAVFS/1.5")) {
                            log.trace("DoPut.execute() : do workaround for user agent '" + userAgent + "'");
                            resp.setStatus(201);
                        } else {
                            resp.setStatus(204);
                        }
                    }
                    this.store.setResourceContent(path, (InputStream)req.getInputStream(), null, null);
                    resp.setContentLength((int)this.store.getResourceLength(path));
                    return;
                }
                catch (AccessDeniedException e) {
                    resp.sendError(403);
                    return;
                }
                catch (WebdavException e) {
                    resp.sendError(500);
                    return;
                }
                finally {
                    this.resLocks.unlock(path, lockOwner);
                }
            } else {
                resp.sendError(500);
            }
            return;
        } else {
            resp.sendError(403);
        }
    }
}

