/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.modeldriven.ui;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.ChangeListener;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;
import org.drools.guvnor.client.common.ClickableLabel;
import org.drools.guvnor.client.common.DirtyableComposite;
import org.drools.guvnor.client.common.DirtyableFlexTable;
import org.drools.guvnor.client.common.ImageButton;
import org.drools.guvnor.client.common.SmallLabel;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.modeldriven.HumanReadable;
import org.drools.guvnor.client.modeldriven.SuggestionCompletionEngine;
import org.drools.guvnor.client.modeldriven.brl.CompositeFieldConstraint;
import org.drools.guvnor.client.modeldriven.brl.FactPattern;
import org.drools.guvnor.client.modeldriven.brl.FieldConstraint;
import org.drools.guvnor.client.modeldriven.brl.IPattern;
import org.drools.guvnor.client.modeldriven.brl.ISingleFieldConstraint;
import org.drools.guvnor.client.modeldriven.brl.SingleFieldConstraint;
import org.drools.guvnor.client.modeldriven.ui.ConstraintValueEditor;
import org.drools.guvnor.client.modeldriven.ui.FactPatternWidget;
import org.drools.guvnor.client.modeldriven.ui.RuleModeller;
import org.drools.guvnor.client.modeldriven.ui.factPattern.Connectives;
import org.drools.guvnor.client.modeldriven.ui.factPattern.PopupCreator;

public class FactPatternWidget
extends DirtyableComposite {
    private FactPattern pattern;
    private SuggestionCompletionEngine completions;
    private RuleModeller modeller;
    private DirtyableFlexTable layout = new DirtyableFlexTable();
    private Connectives connectives;
    private PopupCreator popupCreator;
    private boolean bindable;
    private Constants constants = (Constants)GWT.create(Constants.class);

    public FactPatternWidget(RuleModeller mod, IPattern p, SuggestionCompletionEngine com, boolean canBind) {
        this.pattern = (FactPattern)p;
        this.completions = com;
        this.modeller = mod;
        this.bindable = canBind;
        this.connectives = new Connectives();
        this.connectives.setCompletions(this.completions);
        this.connectives.setModeller(this.modeller);
        this.connectives.setPattern(this.pattern);
        this.popupCreator = new PopupCreator();
        this.popupCreator.setBindable(this.bindable);
        this.popupCreator.setCompletions(this.completions);
        this.popupCreator.setModeller(this.modeller);
        this.popupCreator.setPattern(this.pattern);
        this.layout.setWidget(0, 0, this.getPatternLabel());
        FlexTable.FlexCellFormatter formatter = this.layout.getFlexCellFormatter();
        formatter.setAlignment(0, 0, HasHorizontalAlignment.ALIGN_CENTER, HasVerticalAlignment.ALIGN_MIDDLE);
        formatter.setStyleName(0, 0, "modeller-fact-TypeHeader");
        ArrayList sortedConst = this.sortConstraints(this.pattern.getFieldConstraints());
        this.pattern.setFieldConstraints((List)sortedConst);
        this.drawConstraints(sortedConst);
        if (this.bindable) {
            this.layout.setStyleName("modeller-fact-pattern-Widget");
        }
        this.initWidget((Widget)this.layout);
    }

    private void drawConstraints(ArrayList sortedConst) {
        DirtyableFlexTable table = new DirtyableFlexTable();
        this.layout.setWidget(1, 0, (Widget)table);
        ArrayList<FieldConstraint> parents = new ArrayList<FieldConstraint>();
        int i = 0;
        while (i < sortedConst.size()) {
            int tabs = -1;
            FieldConstraint current = (FieldConstraint)sortedConst.get(i);
            if (current instanceof SingleFieldConstraint) {
                SingleFieldConstraint single = (SingleFieldConstraint)current;
                FieldConstraint parent = single.parent;
                for (int j = 0; j < parents.size(); ++j) {
                    FieldConstraint storedParent = (FieldConstraint)parents.get(j);
                    if (storedParent == null || !storedParent.equals(parent)) continue;
                    tabs = j + 1;
                    for (int k = j + 1; k < parents.size(); ++k) {
                        parents.remove(j + 1);
                    }
                    parents.add(current);
                    break;
                }
                if (tabs < 0) {
                    tabs = 0;
                    parents.add(current);
                }
            }
            this.renderFieldConstraint(table, i, current, true, tabs);
            int currentRow = i++;
            ImageButton clear = new ImageButton("images/delete_item_small.gif");
            clear.setTitle(this.constants.RemoveThisWholeRestriction());
            clear.addClickListener((ClickListener)new /* Unavailable Anonymous Inner Class!! */);
            table.setWidget(currentRow, 5, (Widget)clear);
        }
    }

    private ArrayList sortConstraints(FieldConstraint[] constraints) {
        ArrayList<Object> sortedConst = new ArrayList<Object>(constraints.length);
        for (int i = 0; i < constraints.length; ++i) {
            FieldConstraint current = constraints[i];
            if (current instanceof SingleFieldConstraint) {
                SingleFieldConstraint single = (SingleFieldConstraint)current;
                int index = sortedConst.indexOf(single.parent);
                if (single.parent == null) {
                    sortedConst.add(single);
                    continue;
                }
                if (index >= 0) {
                    sortedConst.add(index + 1, single);
                    continue;
                }
                this.insertSingleFieldConstraint(single, sortedConst);
                continue;
            }
            sortedConst.add(current);
        }
        return sortedConst;
    }

    private void insertSingleFieldConstraint(SingleFieldConstraint fieldConst, ArrayList sortedConst) {
        if (fieldConst.parent instanceof SingleFieldConstraint) {
            this.insertSingleFieldConstraint((SingleFieldConstraint)fieldConst.parent, sortedConst);
        }
        sortedConst.add(fieldConst);
    }

    private void renderFieldConstraint(DirtyableFlexTable inner, int row, FieldConstraint constraint, boolean showBinding, int tabs) {
        if (constraint instanceof SingleFieldConstraint) {
            this.renderSingleFieldConstraint(this.modeller, inner, row, (SingleFieldConstraint)constraint, showBinding, tabs);
        } else if (constraint instanceof CompositeFieldConstraint) {
            inner.setWidget(row, 0, this.compositeFieldConstraintEditor((CompositeFieldConstraint)constraint));
            inner.getFlexCellFormatter().setColSpan(row, 0, 5);
        }
    }

    private Widget compositeFieldConstraintEditor(CompositeFieldConstraint constraint) {
        HorizontalPanel horiz = new HorizontalPanel();
        String desc = null;
        ImageButton edit = new ImageButton("images/edit_tiny.gif");
        edit.setTitle(this.constants.AddAFieldToThisNestedConstraint());
        2 click = new /* Unavailable Anonymous Inner Class!! */;
        edit.addClickListener((ClickListener)click);
        desc = constraint.compositeJunctionType.equals("&&") ? this.constants.AllOf() : this.constants.AnyOf();
        horiz.add((Widget)edit);
        horiz.add((Widget)new ClickableLabel(desc, (ClickListener)click));
        FieldConstraint[] nested = constraint.constraints;
        DirtyableFlexTable inner = new DirtyableFlexTable();
        inner.setStyleName("modeller-inner-nested-Constraints");
        if (nested != null) {
            for (int i = 0; i < nested.length; ++i) {
                this.renderFieldConstraint(inner, i, nested[i], false, 0);
                int currentRow = i;
                ImageButton clear = new ImageButton("images/delete_item_small.gif");
                clear.setTitle(this.constants.RemoveThisNestedRestriction());
                clear.addClickListener((ClickListener)new /* Unavailable Anonymous Inner Class!! */);
                inner.setWidget(i, 5, (Widget)clear);
            }
        }
        horiz.add((Widget)inner);
        return horiz;
    }

    private void renderSingleFieldConstraint(RuleModeller modeller, DirtyableFlexTable inner, int row, SingleFieldConstraint constraint, boolean showBinding, int tabs) {
        if (constraint.constraintValueType != 5) {
            inner.setWidget(row, 0, this.fieldLabel(constraint, showBinding, tabs * 20));
            inner.setWidget(row, 1, this.operatorDropDown(constraint));
            inner.setWidget(row, 2, this.valueEditor(constraint, constraint.fieldType));
            inner.setWidget(row, 3, this.connectives.connectives(constraint, constraint.fieldType));
            ImageButton addConnective = new ImageButton("images/add_connective.gif");
            addConnective.setTitle(this.constants.AddMoreOptionsToThisFieldsValues());
            addConnective.addClickListener((ClickListener)new /* Unavailable Anonymous Inner Class!! */);
            inner.setWidget(row, 4, (Widget)addConnective);
        } else if (constraint.constraintValueType == 5) {
            inner.setWidget(row, 0, this.predicateEditor(constraint));
            inner.getFlexCellFormatter().setColSpan(row, 0, 5);
        }
    }

    private Widget predicateEditor(SingleFieldConstraint c) {
        HorizontalPanel pred = new HorizontalPanel();
        pred.setWidth("100%");
        Image img = new Image("images/function_assets.gif");
        img.setTitle(this.constants.FormulaBooleanTip());
        pred.add((Widget)img);
        if (c.value == null) {
            c.value = "";
        }
        TextBox box = new TextBox();
        box.setText(c.value);
        box.addChangeListener((ChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        box.setWidth("100%");
        pred.add((Widget)box);
        return pred;
    }

    private Widget getPatternLabel() {
        HorizontalPanel horiz = new HorizontalPanel();
        ImageButton edit = new ImageButton("images/edit_tiny.gif");
        edit.setTitle(this.constants.AddOrBindToCondition());
        6 click = new /* Unavailable Anonymous Inner Class!! */;
        edit.addClickListener((ClickListener)click);
        if (this.pattern.boundName != null) {
            horiz.add((Widget)new ClickableLabel(this.pattern.factType + " <b>[" + this.pattern.boundName + "]</b>", (ClickListener)click));
        } else {
            horiz.add((Widget)new ClickableLabel(this.pattern.factType, (ClickListener)click));
        }
        horiz.add((Widget)edit);
        return horiz;
    }

    private Widget valueEditor(SingleFieldConstraint c, String factType) {
        return new ConstraintValueEditor(this.pattern, c.fieldName, (ISingleFieldConstraint)c, this.modeller, c.fieldType);
    }

    private Widget operatorDropDown(SingleFieldConstraint c) {
        String[] ops = this.completions.getOperatorCompletions(this.pattern.factType, c.fieldName);
        ListBox box = new ListBox();
        box.addItem(this.constants.pleaseChoose(), "");
        for (int i = 0; i < ops.length; ++i) {
            String op = ops[i];
            box.addItem(HumanReadable.getOperatorDisplayName((String)op), op);
            if (!op.equals(c.operator)) continue;
            box.setSelectedIndex(i + 1);
        }
        box.addChangeListener((ChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        return box;
    }

    private Widget fieldLabel(SingleFieldConstraint con, boolean showBinding, int padding) {
        HorizontalPanel ab = new HorizontalPanel();
        ab.setStyleName("modeller-field-Label");
        if (!con.isBound()) {
            if (this.bindable && showBinding) {
                8 click = new /* Unavailable Anonymous Inner Class!! */;
                ImageButton bind = new ImageButton("images/edit_tiny.gif", this.constants.GiveFieldVarName());
                bind.addClickListener((ClickListener)click);
                ClickableLabel cl = new ClickableLabel(con.fieldName, (ClickListener)click);
                DOM.setStyleAttribute((Element)cl.getElement(), (String)"marginLeft", (String)("" + padding + "pt"));
                ab.add((Widget)cl);
                ab.add((Widget)bind);
            } else {
                ab.add((Widget)new SmallLabel(con.fieldName));
            }
        } else {
            ab.add((Widget)new SmallLabel(con.fieldName));
            ab.add((Widget)new SmallLabel(" <b>[" + con.fieldBinding + "]</b>"));
        }
        return ab;
    }

    public boolean isDirty() {
        return this.layout.hasDirty();
    }

    static /* synthetic */ Constants access$000(FactPatternWidget x0) {
        return x0.constants;
    }

    static /* synthetic */ FactPattern access$100(FactPatternWidget x0) {
        return x0.pattern;
    }

    static /* synthetic */ RuleModeller access$200(FactPatternWidget x0) {
        return x0.modeller;
    }

    static /* synthetic */ PopupCreator access$300(FactPatternWidget x0) {
        return x0.popupCreator;
    }

    static /* synthetic */ SuggestionCompletionEngine access$400(FactPatternWidget x0) {
        return x0.completions;
    }
}

