/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.modeldriven.ui;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.ChangeListener;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.KeyboardListener;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import org.drools.guvnor.client.common.DirtyableHorizontalPane;
import org.drools.guvnor.client.common.FormStyleLayout;
import org.drools.guvnor.client.common.SmallLabel;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.modeldriven.brl.RuleAttribute;
import org.drools.guvnor.client.modeldriven.brl.RuleMetadata;
import org.drools.guvnor.client.modeldriven.brl.RuleModel;
import org.drools.guvnor.client.modeldriven.ui.RuleModeller;

public class RuleAttributeWidget
extends Composite {
    private FormStyleLayout layout;
    private RuleModel model;
    private RuleModeller parent;
    private Constants constants = (Constants)GWT.create(Constants.class);

    public RuleAttributeWidget(RuleModeller parent, RuleModel model) {
        this.parent = parent;
        this.model = model;
        this.layout = new FormStyleLayout();
        RuleMetadata[] meta = model.metadataList;
        if (meta.length > 0) {
            HorizontalPanel hp = new HorizontalPanel();
            hp.add((Widget)new SmallLabel(this.constants.Metadata2()));
            this.layout.addRow((Widget)hp);
        }
        for (int i = 0; i < meta.length; ++i) {
            RuleMetadata rmd = meta[i];
            this.layout.addAttribute(rmd.attributeName, this.getEditorWidget(rmd, i));
        }
        RuleAttribute[] attrs = model.attributes;
        if (attrs.length > 0) {
            HorizontalPanel hp = new HorizontalPanel();
            hp.add((Widget)new SmallLabel(this.constants.Attributes1()));
            this.layout.addRow((Widget)hp);
        }
        for (int i = 0; i < attrs.length; ++i) {
            RuleAttribute at = attrs[i];
            this.layout.addAttribute(at.attributeName, this.getEditorWidget(at, i));
        }
        this.initWidget((Widget)this.layout);
    }

    public static ListBox getAttributeList() {
        Constants cons = (Constants)GWT.create(Constants.class);
        ListBox list = new ListBox();
        list.addItem(cons.Choose());
        list.addItem("salience");
        list.addItem("enabled");
        list.addItem("date-effective");
        list.addItem("date-expires");
        list.addItem("no-loop");
        list.addItem("agenda-group");
        list.addItem("activation-group");
        list.addItem("duration");
        list.addItem("auto-focus");
        list.addItem("lock-on-active");
        list.addItem("ruleflow-group");
        list.addItem("dialect");
        return list;
    }

    private Widget getEditorWidget(RuleAttribute at, int idx) {
        if (at.attributeName.equals("no-loop")) {
            return this.getRemoveIcon(idx);
        }
        Object editor = null;
        editor = at.attributeName.equals("enabled") || at.attributeName.equals("auto-focus") || at.attributeName.equals("lock-on-active") ? this.checkBoxEditor(at) : this.textBoxEditor(at);
        DirtyableHorizontalPane horiz = new DirtyableHorizontalPane();
        horiz.add(editor);
        horiz.add((Widget)this.getRemoveIcon(idx));
        return horiz;
    }

    private Widget getEditorWidget(RuleMetadata rm, int idx) {
        TextBox editor = null;
        editor = this.textBoxEditor(rm);
        DirtyableHorizontalPane horiz = new DirtyableHorizontalPane();
        horiz.add((Widget)editor);
        horiz.add((Widget)this.getRemoveMetaIcon(idx));
        return horiz;
    }

    private Widget checkBoxEditor(RuleAttribute at) {
        CheckBox box = new CheckBox();
        if (at.value == null) {
            box.setChecked(true);
            at.value = "true";
        } else {
            box.setChecked(at.value.equals("true"));
        }
        box.addClickListener((ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        return box;
    }

    private TextBox textBoxEditor(RuleAttribute at) {
        TextBox box = new TextBox();
        box.setVisibleLength(at.value.length() < 3 ? 3 : at.value.length());
        box.setText(at.value);
        box.addChangeListener((ChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        if (at.attributeName.equals("date-effective") || at.attributeName.equals("date-expires")) {
            if (at.value == null || "".equals(at.value)) {
                box.setText("");
            }
            box.setVisibleLength(10);
        }
        box.addKeyboardListener((KeyboardListener)new /* Unavailable Anonymous Inner Class!! */);
        return box;
    }

    private TextBox textBoxEditor(RuleMetadata rm) {
        TextBox box = new TextBox();
        box.setVisibleLength(rm.value.length() < 3 ? 3 : rm.value.length());
        box.setText(rm.value);
        box.addChangeListener((ChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        box.addKeyboardListener((KeyboardListener)new /* Unavailable Anonymous Inner Class!! */);
        return box;
    }

    private Image getRemoveIcon(int idx) {
        Image remove = new Image("images/delete_item_small.gif");
        remove.addClickListener((ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        return remove;
    }

    private Image getRemoveMetaIcon(int idx) {
        Image remove = new Image("images/delete_item_small.gif");
        remove.addClickListener((ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        return remove;
    }

    static /* synthetic */ Constants access$000(RuleAttributeWidget x0) {
        return x0.constants;
    }

    static /* synthetic */ RuleModel access$100(RuleAttributeWidget x0) {
        return x0.model;
    }

    static /* synthetic */ RuleModeller access$200(RuleAttributeWidget x0) {
        return x0.parent;
    }
}

