/*
 * Decompiled with CFR 0.152.
 */
package net.sf.webdav;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Enumeration;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.webdav.MethodExecutor;
import net.sf.webdav.MimeTyper;
import net.sf.webdav.ResourceLocks;
import net.sf.webdav.WebDavServletBean;
import net.sf.webdav.WebdavStore;
import net.sf.webdav.exceptions.UnauthenticatedException;
import net.sf.webdav.exceptions.WebdavException;
import net.sf.webdav.methods.DoCopy;
import net.sf.webdav.methods.DoDelete;
import net.sf.webdav.methods.DoGet;
import net.sf.webdav.methods.DoHead;
import net.sf.webdav.methods.DoLock;
import net.sf.webdav.methods.DoMkcol;
import net.sf.webdav.methods.DoMove;
import net.sf.webdav.methods.DoNotImplemented;
import net.sf.webdav.methods.DoOptions;
import net.sf.webdav.methods.DoPropfind;
import net.sf.webdav.methods.DoPut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebDavServletBean
extends HttpServlet {
    private static Logger log = LoggerFactory.getLogger(WebDavServletBean.class);
    private static final boolean readOnly = false;
    private ResourceLocks resLocks;
    private WebdavStore store;
    private HashMap methodMap = new HashMap();

    public WebDavServletBean() {
        this.resLocks = new ResourceLocks();
        try {
            MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException();
        }
    }

    public void init(WebdavStore store, String dftIndexFile, String insteadOf404, int nocontentLenghHeaders, boolean lazyFolderCreationOnPut) throws ServletException {
        this.store = store;
        1 mimeTyper = new /* Unavailable Anonymous Inner Class!! */;
        this.register("GET", (MethodExecutor)new DoGet(store, dftIndexFile, insteadOf404, this.resLocks, (MimeTyper)mimeTyper, nocontentLenghHeaders));
        this.register("HEAD", (MethodExecutor)new DoHead(store, dftIndexFile, insteadOf404, this.resLocks, (MimeTyper)mimeTyper, nocontentLenghHeaders));
        DoDelete doDelete = (DoDelete)this.register("DELETE", (MethodExecutor)new DoDelete(store, this.resLocks, false));
        DoCopy doCopy = (DoCopy)this.register("COPY", (MethodExecutor)new DoCopy(store, this.resLocks, doDelete, false));
        this.register("LOCK", (MethodExecutor)new DoLock(store, this.resLocks, false));
        this.register("MOVE", (MethodExecutor)new DoMove(this.resLocks, doDelete, doCopy, false));
        this.register("MKCOL", (MethodExecutor)new DoMkcol(store, this.resLocks, false));
        this.register("OPTIONS", (MethodExecutor)new DoOptions(store, this.resLocks));
        this.register("PUT", (MethodExecutor)new DoPut(store, this.resLocks, false, lazyFolderCreationOnPut));
        this.register("PROPFIND", (MethodExecutor)new DoPropfind(store, this.resLocks, false, (MimeTyper)mimeTyper));
        this.register("PROPPATCH", (MethodExecutor)new DoNotImplemented(false));
        this.register("*NO*IMPL*", (MethodExecutor)new DoNotImplemented(false));
    }

    private MethodExecutor register(String methodName, MethodExecutor method) {
        this.methodMap.put(methodName, method);
        return method;
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String methodName = req.getMethod();
        this.debugRequest(methodName, req);
        try {
            this.store.begin(req.getUserPrincipal());
            this.store.checkAuthentication();
            resp.setStatus(200);
            try {
                MethodExecutor methodExecutor = (MethodExecutor)this.methodMap.get(methodName);
                if (methodExecutor == null) {
                    methodExecutor = (MethodExecutor)this.methodMap.get("*NO*IMPL*");
                }
                methodExecutor.execute(req, resp);
                this.store.commit();
            }
            catch (IOException e) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                e.printStackTrace(pw);
                log.error("IOException: " + sw.toString());
                resp.sendError(500);
                this.store.rollback();
                throw new ServletException((Throwable)e);
            }
        }
        catch (UnauthenticatedException e) {
            resp.sendError(403);
        }
        catch (WebdavException e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            log.error("WebdavException: " + sw.toString());
            throw new ServletException((Throwable)e);
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            log.error("Exception: " + sw.toString());
        }
    }

    private void debugRequest(String methodName, HttpServletRequest req) {
        String s;
        log.trace("-----------");
        log.trace("WebdavServlet\n request: methodName = " + methodName);
        log.trace("time: " + System.currentTimeMillis());
        log.trace("path: " + req.getRequestURI());
        log.trace("-----------");
        Enumeration e = req.getHeaderNames();
        while (e.hasMoreElements()) {
            s = (String)e.nextElement();
            log.trace("header: " + s + " " + req.getHeader(s));
        }
        e = req.getAttributeNames();
        while (e.hasMoreElements()) {
            s = (String)e.nextElement();
            log.trace("attribute: " + s + " " + req.getAttribute(s));
        }
        e = req.getParameterNames();
        while (e.hasMoreElements()) {
            s = (String)e.nextElement();
            log.trace("parameter: " + s + " " + req.getParameter(s));
        }
    }
}

