/*
 * Decompiled with CFR 0.152.
 */
package net.sf.webdav.methods;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.webdav.MimeTyper;
import net.sf.webdav.ResourceLocks;
import net.sf.webdav.WebdavStore;
import net.sf.webdav.exceptions.AccessDeniedException;
import net.sf.webdav.exceptions.ObjectAlreadyExistsException;
import net.sf.webdav.exceptions.WebdavException;
import net.sf.webdav.methods.AbstractMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DoHead
extends AbstractMethod {
    protected String dftIndexFile;
    protected WebdavStore store;
    protected String insteadOf404;
    protected ResourceLocks resLocks;
    protected MimeTyper mimeTyper;
    protected int contLength;
    private static Logger log = LoggerFactory.getLogger((String)"net.sf.webdav.methods");

    public DoHead(WebdavStore store, String dftIndexFile, String insteadOf404, ResourceLocks resourceLocks, MimeTyper mimeTyper, int contentLengthHeader) {
        this.store = store;
        this.dftIndexFile = dftIndexFile;
        this.insteadOf404 = insteadOf404;
        this.resLocks = resourceLocks;
        this.mimeTyper = mimeTyper;
        this.contLength = contentLengthHeader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String lockOwner;
        boolean bUriExists = false;
        String path = this.getRelativePath(req);
        log.trace("-- " + this.getClass().getName());
        log.debug("-- do " + req.getMethod());
        if (this.store.isFolder(path)) {
            bUriExists = true;
            if (this.dftIndexFile != null && !this.dftIndexFile.trim().equals("")) {
                resp.sendRedirect(resp.encodeRedirectURL(req.getRequestURI() + this.dftIndexFile));
                return;
            }
        }
        if (!this.store.objectExists(path)) {
            if (this.insteadOf404 != null && !this.insteadOf404.trim().equals("")) {
                path = this.insteadOf404;
            }
        } else {
            bUriExists = true;
        }
        if (this.resLocks.lock(path, lockOwner = "doGet" + System.currentTimeMillis() + req.toString(), false, 0)) {
            try {
                if (this.store.isResource(path)) {
                    String mimeType;
                    if (path.endsWith("/") || path.endsWith("\\")) {
                        resp.sendError(404, req.getRequestURI());
                    }
                    long lastModified = this.store.getLastModified(path).getTime();
                    resp.setDateHeader("last-modified", lastModified);
                    long resourceLength = this.store.getResourceLength(path);
                    if (this.contLength == 1 && resourceLength > 0L) {
                        if (resourceLength <= Integer.MAX_VALUE) {
                            resp.setContentLength((int)resourceLength);
                        } else {
                            resp.setHeader("content-length", "" + resourceLength);
                        }
                    }
                    if ((mimeType = this.mimeTyper.getMimeType(path)) != null) {
                        resp.setContentType(mimeType);
                    } else {
                        int lastSlash = path.replace('\\', '/').lastIndexOf(47);
                        int lastDot = path.indexOf(".", lastSlash);
                        if (lastDot == -1) {
                            resp.setContentType("text/html");
                        }
                    }
                    this.doBody(resp, path);
                }
                this.folderBody(path, resp, req);
            }
            catch (AccessDeniedException e) {
                resp.sendError(403);
            }
            catch (ObjectAlreadyExistsException e) {
                resp.sendError(404, req.getRequestURI());
            }
            catch (WebdavException e) {
                resp.sendError(500);
            }
            finally {
                this.resLocks.unlock(path, lockOwner);
            }
        } else {
            resp.sendError(500);
        }
        if (!bUriExists) {
            resp.setStatus(404);
        }
    }

    protected void folderBody(String path, HttpServletResponse resp, HttpServletRequest req) throws IOException {
    }

    protected void doBody(HttpServletResponse resp, String path) throws IOException {
    }
}

