/*
 * Decompiled with CFR 0.152.
 */
package net.sf.webdav.methods;

import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Locale;
import java.util.TimeZone;
import java.util.Vector;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.sf.webdav.MimeTyper;
import net.sf.webdav.ResourceLocks;
import net.sf.webdav.WebdavStatus;
import net.sf.webdav.WebdavStore;
import net.sf.webdav.exceptions.AccessDeniedException;
import net.sf.webdav.exceptions.WebdavException;
import net.sf.webdav.fromcatalina.URLEncoder;
import net.sf.webdav.fromcatalina.XMLWriter;
import net.sf.webdav.methods.AbstractMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class DoPropfind
extends AbstractMethod {
    private static Logger log = LoggerFactory.getLogger((String)"net.sf.webdav.methods");
    protected static URLEncoder urlEncoder;
    protected static final SimpleDateFormat creationDateFormat;
    private static final int INFINITY = 3;
    private static final int FIND_BY_PROPERTY = 0;
    private static final int FIND_ALL_PROP = 1;
    private static final int FIND_PROPERTY_NAMES = 2;
    private WebdavStore store;
    private ResourceLocks resLocks;
    private boolean readOnly;
    private MimeTyper mimeTyper;

    public DoPropfind(WebdavStore store, ResourceLocks resLocks, boolean readOnly, MimeTyper mimeTyper) {
        this.store = store;
        this.resLocks = resLocks;
        this.readOnly = readOnly;
        this.mimeTyper = mimeTyper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        log.trace("-- " + this.getClass().getName());
        String lockOwner = "doPropfind" + System.currentTimeMillis() + req.toString();
        String path = this.getCleanPath(this.getRelativePath(req));
        int depth = this.getDepth(req);
        if (this.resLocks.lock(path, lockOwner, false, depth)) {
            try {
                if (!this.store.objectExists(path)) {
                    resp.sendError(404, req.getRequestURI());
                    return;
                }
                Vector properties = null;
                int propertyFindType = 1;
                Node propNode = null;
                this.getPropertyNodeAndType(propNode, propertyFindType, (ServletRequest)req);
                if (propertyFindType == 0) {
                    properties = this.getPropertiesFromXML(propNode);
                }
                resp.setStatus(207);
                resp.setContentType("text/xml; charset=UTF-8");
                XMLWriter generatedXML = new XMLWriter((Writer)resp.getWriter());
                generatedXML.writeXMLHeader();
                generatedXML.writeElement(null, "multistatus xmlns=\"DAV:\"", 0);
                if (depth == 0) {
                    this.parseProperties(req, generatedXML, path, propertyFindType, properties, this.mimeTyper.getMimeType(path));
                } else {
                    this.recursiveParseProperties(path, req, generatedXML, propertyFindType, properties, depth, this.mimeTyper.getMimeType(path));
                }
                generatedXML.writeElement(null, "multistatus", 1);
                generatedXML.sendData();
            }
            catch (AccessDeniedException e) {
                resp.sendError(403);
            }
            catch (WebdavException e) {
                log.warn("Sending internal error!");
                resp.sendError(500);
            }
            catch (ServletException e) {
                e.printStackTrace();
            }
            finally {
                this.resLocks.unlock(path, lockOwner);
            }
        } else {
            log.warn("Sending internal error!");
            resp.sendError(500);
        }
    }

    private int getDepth(HttpServletRequest req) {
        int depth = 3;
        String depthStr = req.getHeader("Depth");
        if (depthStr != null) {
            if (depthStr.equals("0")) {
                depth = 0;
            } else if (depthStr.equals("1")) {
                depth = 1;
            } else if (depthStr.equals("infinity")) {
                depth = 3;
            }
        }
        return depth;
    }

    private String getCleanPath(String path) {
        if (path.endsWith("/") && path.length() > 1) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    private void getPropertyNodeAndType(Node propNode, int type, ServletRequest req) throws ServletException {
        if (req.getContentLength() != 0) {
            DocumentBuilder documentBuilder = this.getDocumentBuilder();
            try {
                Document document = documentBuilder.parse(new InputSource((InputStream)req.getInputStream()));
                Element rootElement = document.getDocumentElement();
                NodeList childList = rootElement.getChildNodes();
                block6: for (int i = 0; i < childList.getLength(); ++i) {
                    Node currentNode = childList.item(i);
                    switch (currentNode.getNodeType()) {
                        case 3: {
                            continue block6;
                        }
                        case 1: {
                            if (currentNode.getNodeName().endsWith("prop")) {
                                type = 0;
                                propNode = currentNode;
                            }
                            if (currentNode.getNodeName().endsWith("propname")) {
                                type = 2;
                            }
                            if (!currentNode.getNodeName().endsWith("allprop")) continue block6;
                            type = 1;
                        }
                    }
                }
            }
            catch (Exception e) {}
        } else {
            type = 1;
        }
    }

    private DocumentBuilder getDocumentBuilder() throws ServletException {
        DocumentBuilder documentBuilder = null;
        DocumentBuilderFactory documentBuilderFactory = null;
        try {
            documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new ServletException("jaxp failed");
        }
        return documentBuilder;
    }

    private Vector getPropertiesFromXML(Node propNode) {
        Vector<String> properties = new Vector<String>();
        NodeList childList = propNode.getChildNodes();
        block4: for (int i = 0; i < childList.getLength(); ++i) {
            Node currentNode = childList.item(i);
            switch (currentNode.getNodeType()) {
                case 3: {
                    continue block4;
                }
                case 1: {
                    String nodeName = currentNode.getNodeName();
                    String propertyName = null;
                    propertyName = nodeName.indexOf(58) != -1 ? nodeName.substring(nodeName.indexOf(58) + 1) : nodeName;
                    properties.addElement(propertyName);
                }
            }
        }
        return properties;
    }

    private void recursiveParseProperties(String currentPath, HttpServletRequest req, XMLWriter generatedXML, int propertyFindType, Vector properties, int depth, String mimeType) throws WebdavException {
        this.parseProperties(req, generatedXML, currentPath, propertyFindType, properties, mimeType);
        String[] names = this.store.getChildrenNames(currentPath);
        if (names != null && depth > 0) {
            for (int i = 0; i < names.length; ++i) {
                String name = names[i];
                String newPath = currentPath;
                if (!newPath.endsWith("/")) {
                    newPath = newPath + "/";
                }
                newPath = newPath + name;
                this.recursiveParseProperties(newPath, req, generatedXML, propertyFindType, properties, depth - 1, mimeType);
            }
        }
    }

    private void parseProperties(HttpServletRequest req, XMLWriter generatedXML, String path, int type, Vector propertiesVector, String mimeType) throws WebdavException {
        String creationdate = this.getISOCreationDate(this.store.getCreationDate(path).getTime());
        boolean isFolder = this.store.isFolder(path);
        SimpleDateFormat formatter = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
        formatter.setTimeZone(TimeZone.getTimeZone("GMT"));
        String lastModified = formatter.format(this.store.getLastModified(path));
        String resourceLength = String.valueOf(this.store.getResourceLength(path));
        generatedXML.writeElement(null, "response", 0);
        String status = new String("HTTP/1.1 200 " + WebdavStatus.getStatusText((int)200));
        generatedXML.writeElement(null, "href", 0);
        String href = req.getContextPath();
        String servletPath = req.getServletPath();
        if (servletPath != null) {
            href = href.endsWith("/") && servletPath.startsWith("/") ? href + servletPath.substring(1) : href + servletPath;
        }
        href = href.endsWith("/") && path.startsWith("/") ? href + path.substring(1) : href + path;
        if (isFolder && !href.endsWith("/")) {
            href = href + "/";
        }
        generatedXML.writeText(this.rewriteUrl(href));
        generatedXML.writeElement(null, "href", 1);
        String resourceName = path;
        int lastSlash = path.lastIndexOf(47);
        if (lastSlash != -1) {
            resourceName = resourceName.substring(lastSlash + 1);
        }
        switch (type) {
            case 1: {
                generatedXML.writeElement(null, "propstat", 0);
                generatedXML.writeElement(null, "prop", 0);
                generatedXML.writeProperty(null, "creationdate", creationdate);
                generatedXML.writeElement(null, "displayname", 0);
                generatedXML.writeData(resourceName);
                generatedXML.writeElement(null, "displayname", 1);
                if (!isFolder) {
                    generatedXML.writeProperty(null, "getlastmodified", lastModified);
                    generatedXML.writeProperty(null, "getcontentlength", resourceLength);
                    String contentType = mimeType;
                    if (contentType != null) {
                        generatedXML.writeProperty(null, "getcontenttype", contentType);
                    }
                    generatedXML.writeProperty(null, "getetag", this.getETag(path, resourceLength, lastModified));
                    generatedXML.writeElement(null, "resourcetype", 2);
                } else {
                    generatedXML.writeElement(null, "resourcetype", 0);
                    generatedXML.writeElement(null, "collection", 2);
                    generatedXML.writeElement(null, "resourcetype", 1);
                }
                generatedXML.writeProperty(null, "source", "");
                generatedXML.writeElement(null, "prop", 1);
                generatedXML.writeElement(null, "status", 0);
                generatedXML.writeText(status);
                generatedXML.writeElement(null, "status", 1);
                generatedXML.writeElement(null, "propstat", 1);
                break;
            }
            case 2: {
                generatedXML.writeElement(null, "propstat", 0);
                generatedXML.writeElement(null, "prop", 0);
                generatedXML.writeElement(null, "creationdate", 2);
                generatedXML.writeElement(null, "displayname", 2);
                if (!isFolder) {
                    generatedXML.writeElement(null, "getcontentlanguage", 2);
                    generatedXML.writeElement(null, "getcontentlength", 2);
                    generatedXML.writeElement(null, "getcontenttype", 2);
                    generatedXML.writeElement(null, "getetag", 2);
                    generatedXML.writeElement(null, "getlastmodified", 2);
                }
                generatedXML.writeElement(null, "resourcetype", 2);
                generatedXML.writeElement(null, "source", 2);
                generatedXML.writeElement(null, "lockdiscovery", 2);
                generatedXML.writeElement(null, "prop", 1);
                generatedXML.writeElement(null, "status", 0);
                generatedXML.writeText(status);
                generatedXML.writeElement(null, "status", 1);
                generatedXML.writeElement(null, "propstat", 1);
                break;
            }
            case 0: {
                Vector<String> propertiesNotFound = new Vector<String>();
                generatedXML.writeElement(null, "propstat", 0);
                generatedXML.writeElement(null, "prop", 0);
                Enumeration properties = propertiesVector.elements();
                while (properties.hasMoreElements()) {
                    String property = (String)properties.nextElement();
                    if (property.equals("creationdate")) {
                        generatedXML.writeProperty(null, "creationdate", creationdate);
                        continue;
                    }
                    if (property.equals("displayname")) {
                        generatedXML.writeElement(null, "displayname", 0);
                        generatedXML.writeData(resourceName);
                        generatedXML.writeElement(null, "displayname", 1);
                        continue;
                    }
                    if (property.equals("getcontentlanguage")) {
                        if (isFolder) {
                            propertiesNotFound.addElement(property);
                            continue;
                        }
                        generatedXML.writeElement(null, "getcontentlanguage", 2);
                        continue;
                    }
                    if (property.equals("getcontentlength")) {
                        if (isFolder) {
                            propertiesNotFound.addElement(property);
                            continue;
                        }
                        generatedXML.writeProperty(null, "getcontentlength", resourceLength);
                        continue;
                    }
                    if (property.equals("getcontenttype")) {
                        if (isFolder) {
                            propertiesNotFound.addElement(property);
                            continue;
                        }
                        generatedXML.writeProperty(null, "getcontenttype", mimeType);
                        continue;
                    }
                    if (property.equals("getetag")) {
                        if (isFolder) {
                            propertiesNotFound.addElement(property);
                            continue;
                        }
                        generatedXML.writeProperty(null, "getetag", this.getETag(path, resourceLength, lastModified));
                        continue;
                    }
                    if (property.equals("getlastmodified")) {
                        if (isFolder) {
                            propertiesNotFound.addElement(property);
                            continue;
                        }
                        generatedXML.writeProperty(null, "getlastmodified", lastModified);
                        continue;
                    }
                    if (property.equals("resourcetype")) {
                        if (isFolder) {
                            generatedXML.writeElement(null, "resourcetype", 0);
                            generatedXML.writeElement(null, "collection", 2);
                            generatedXML.writeElement(null, "resourcetype", 1);
                            continue;
                        }
                        generatedXML.writeElement(null, "resourcetype", 2);
                        continue;
                    }
                    if (property.equals("source")) {
                        generatedXML.writeProperty(null, "source", "");
                        continue;
                    }
                    propertiesNotFound.addElement(property);
                }
                generatedXML.writeElement(null, "prop", 1);
                generatedXML.writeElement(null, "status", 0);
                generatedXML.writeText(status);
                generatedXML.writeElement(null, "status", 1);
                generatedXML.writeElement(null, "propstat", 1);
                Enumeration propertiesNotFoundList = propertiesNotFound.elements();
                if (!propertiesNotFoundList.hasMoreElements()) break;
                status = new String("HTTP/1.1 404 " + WebdavStatus.getStatusText((int)404));
                generatedXML.writeElement(null, "propstat", 0);
                generatedXML.writeElement(null, "prop", 0);
                while (propertiesNotFoundList.hasMoreElements()) {
                    generatedXML.writeElement(null, (String)propertiesNotFoundList.nextElement(), 2);
                }
                generatedXML.writeElement(null, "prop", 1);
                generatedXML.writeElement(null, "status", 0);
                generatedXML.writeText(status);
                generatedXML.writeElement(null, "status", 1);
                generatedXML.writeElement(null, "propstat", 1);
            }
        }
        generatedXML.writeElement(null, "response", 1);
    }

    private String getISOCreationDate(long creationDate) {
        StringBuffer creationDateValue = new StringBuffer(creationDateFormat.format(new Date(creationDate)));
        return creationDateValue.toString();
    }

    protected String getETag(String path, String resourceLength, String lastModified) {
        return "W/\"" + resourceLength + "-" + lastModified + "\"";
    }

    protected String rewriteUrl(String path) {
        return urlEncoder.encode(path);
    }

    static {
        creationDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        creationDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        urlEncoder = new URLEncoder();
        urlEncoder.addSafeCharacter('-');
        urlEncoder.addSafeCharacter('_');
        urlEncoder.addSafeCharacter('.');
        urlEncoder.addSafeCharacter('*');
        urlEncoder.addSafeCharacter('/');
    }
}

