/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.decisiontable;

import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.ChangeListener;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import java.util.HashSet;
import org.drools.guvnor.client.common.FormStylePopup;
import org.drools.guvnor.client.common.ImageButton;
import org.drools.guvnor.client.common.InfoPopup;
import org.drools.guvnor.client.common.SmallLabel;
import org.drools.guvnor.client.modeldriven.SuggestionCompletionEngine;
import org.drools.guvnor.client.modeldriven.dt.ActionCol;
import org.drools.guvnor.client.modeldriven.dt.ActionInsertFactCol;
import org.drools.guvnor.client.modeldriven.dt.GuidedDecisionTable;

public class ActionInsertColumn
extends FormStylePopup {
    private GuidedDecisionTable dt;
    private SuggestionCompletionEngine sce;
    private ActionInsertFactCol editingCol;
    private SmallLabel patternLabel = new SmallLabel();
    private TextBox fieldLabel = this.getFieldLabel();

    public ActionInsertColumn(SuggestionCompletionEngine sce, GuidedDecisionTable dt, Command refreshGrid, ActionInsertFactCol col, boolean isNew) {
        this.setModal(false);
        this.dt = dt;
        this.sce = sce;
        this.editingCol = new ActionInsertFactCol();
        this.editingCol.boundName = col.boundName;
        this.editingCol.type = col.type;
        this.editingCol.factField = col.factField;
        this.editingCol.factType = col.factType;
        this.editingCol.header = col.header;
        this.editingCol.valueList = col.valueList;
        this.setTitle("Action column configuration (inserting a new fact)");
        HorizontalPanel pattern = new HorizontalPanel();
        pattern.add((Widget)this.patternLabel);
        this.doPatternLabel();
        ImageButton changePattern = new ImageButton("images/edit.gif", "Choose a pattern that this column adds data to", (ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        pattern.add((Widget)changePattern);
        this.addAttribute("Pattern:", (Widget)pattern);
        HorizontalPanel field = new HorizontalPanel();
        field.add((Widget)this.fieldLabel);
        ImageButton editField = new ImageButton("images/edit.gif", "Edit the field that this column operates on", (ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        field.add((Widget)editField);
        this.addAttribute("Field:", (Widget)field);
        this.doFieldLabel();
        TextBox valueList = new TextBox();
        valueList.setText(this.editingCol.valueList);
        valueList.addChangeListener((ChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        HorizontalPanel vl = new HorizontalPanel();
        vl.add((Widget)valueList);
        vl.add((Widget)new InfoPopup("Value list", "Value lists are an optional comma separated list of values to show as a drop down."));
        this.addAttribute("(optional) value list:", (Widget)vl);
        TextBox header = new TextBox();
        header.setText(col.header);
        header.addChangeListener((ChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.addAttribute("Column header (description):", (Widget)header);
        Button apply = new Button("Apply changes");
        apply.addClickListener((ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        this.addAttribute("", (Widget)apply);
    }

    private TextBox getFieldLabel() {
        TextBox box = new TextBox();
        box.addChangeListener((ChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        return box;
    }

    private void showFieldChange() {
        FormStylePopup pop = new FormStylePopup();
        pop.setModal(false);
        String[] fields = this.sce.getFieldCompletions(this.editingCol.factType);
        ListBox box = new ListBox();
        for (int i = 0; i < fields.length; ++i) {
            box.addItem(fields[i]);
        }
        pop.addAttribute("Field:", (Widget)box);
        Button b = new Button("OK");
        pop.addAttribute("", (Widget)b);
        b.addClickListener((ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        pop.show();
    }

    private void doFieldLabel() {
        if (this.nil(this.editingCol.factField)) {
            this.fieldLabel.setText("(please choose fact type)");
        } else {
            this.fieldLabel.setText(this.editingCol.factField);
        }
    }

    private boolean nil(String s) {
        return s == null || s.equals("");
    }

    private void doPatternLabel() {
        if (this.editingCol.factType != null) {
            this.patternLabel.setText(this.editingCol.factType + " [" + this.editingCol.boundName + "]");
        }
    }

    protected void showChangePattern(Widget w) {
        ListBox pats = this.loadPatterns();
        if (pats.getItemCount() == 0) {
            this.showNewPatternDialog();
            return;
        }
        FormStylePopup pop = new FormStylePopup();
        Button ok = new Button("OK");
        HorizontalPanel hp = new HorizontalPanel();
        hp.add((Widget)pats);
        hp.add((Widget)ok);
        pop.addAttribute("Choose existing pattern to add column to:", (Widget)hp);
        pop.addAttribute("", (Widget)new HTML("<i><b>---OR---</i></b>"));
        Button createPattern = new Button("Create new fact pattern");
        createPattern.addClickListener((ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        pop.addAttribute("", (Widget)createPattern);
        ok.addClickListener((ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        pop.show();
    }

    protected void showNewPatternDialog() {
        FormStylePopup pop = new FormStylePopup();
        pop.setTitle("New fact - select the type");
        ListBox types = new ListBox();
        for (int i = 0; i < this.sce.factTypes.length; ++i) {
            types.addItem(this.sce.factTypes[i]);
        }
        pop.addAttribute("Fact type:", (Widget)types);
        TextBox binding = new TextBox();
        pop.addAttribute("name:", (Widget)binding);
        Button ok = new Button("OK");
        ok.addClickListener((ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        pop.addAttribute("", (Widget)ok);
        pop.show();
    }

    private ListBox loadPatterns() {
        HashSet<String> vars = new HashSet<String>();
        ListBox patterns = new ListBox();
        for (ActionCol o : this.dt.actionCols) {
            ActionCol col = o;
            if (!(col instanceof ActionInsertFactCol)) continue;
            ActionInsertFactCol c = (ActionInsertFactCol)col;
            if (vars.contains(c.boundName)) continue;
            patterns.addItem(c.factType + " [" + c.boundName + "]", c.factType + " " + c.boundName);
            vars.add(c.boundName);
        }
        return patterns;
    }

    static /* synthetic */ void access$000(ActionInsertColumn x0) {
        x0.showFieldChange();
    }

    static /* synthetic */ ActionInsertFactCol access$100(ActionInsertColumn x0) {
        return x0.editingCol;
    }

    static /* synthetic */ SuggestionCompletionEngine access$200(ActionInsertColumn x0) {
        return x0.sce;
    }

    static /* synthetic */ void access$300(ActionInsertColumn x0) {
        x0.doFieldLabel();
    }

    static /* synthetic */ void access$400(ActionInsertColumn x0) {
        x0.doPatternLabel();
    }
}

