/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.modeldriven.ui;

import com.google.gwt.user.client.ui.ChangeListener;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Widget;
import org.drools.guvnor.client.common.ClickableLabel;
import org.drools.guvnor.client.common.DirtyableComposite;
import org.drools.guvnor.client.common.DirtyableFlexTable;
import org.drools.guvnor.client.common.FormStylePopup;
import org.drools.guvnor.client.common.ImageButton;
import org.drools.guvnor.client.common.SmallLabel;
import org.drools.guvnor.client.modeldriven.DropDownData;
import org.drools.guvnor.client.modeldriven.HumanReadable;
import org.drools.guvnor.client.modeldriven.SuggestionCompletionEngine;
import org.drools.guvnor.client.modeldriven.brl.ActionFieldValue;
import org.drools.guvnor.client.modeldriven.brl.ActionSetField;
import org.drools.guvnor.client.modeldriven.brl.ActionUpdateField;
import org.drools.guvnor.client.modeldriven.brl.FactPattern;
import org.drools.guvnor.client.modeldriven.ui.ActionSetFieldWidget;
import org.drools.guvnor.client.modeldriven.ui.ActionValueEditor;
import org.drools.guvnor.client.modeldriven.ui.RuleModeller;

public class ActionSetFieldWidget
extends DirtyableComposite {
    private final ActionSetField model;
    private final SuggestionCompletionEngine completions;
    private final DirtyableFlexTable layout;
    private boolean isBoundFact = false;
    private final String[] fieldCompletions;
    private final RuleModeller modeller;
    private final String variableClass;

    public ActionSetFieldWidget(RuleModeller mod, ActionSetField set, SuggestionCompletionEngine com) {
        this.model = set;
        this.completions = com;
        this.layout = new DirtyableFlexTable();
        this.modeller = mod;
        this.layout.setStyleName("model-builderInner-Background");
        if (this.completions.isGlobalVariable(set.variable)) {
            this.fieldCompletions = this.completions.getFieldCompletionsForGlobalVariable(set.variable);
            this.variableClass = (String)this.completions.globalTypes.get(set.variable);
        } else {
            FactPattern pattern = mod.getModel().getBoundFact(set.variable);
            this.fieldCompletions = this.completions.getFieldCompletions(pattern.factType);
            this.variableClass = pattern.factType;
            this.isBoundFact = true;
        }
        this.doLayout();
        this.initWidget((Widget)this.layout);
    }

    private void doLayout() {
        this.layout.clear();
        this.layout.setWidget(0, 0, this.getSetterLabel());
        DirtyableFlexTable inner = new DirtyableFlexTable();
        for (int i = 0; i < this.model.fieldValues.length; ++i) {
            ActionFieldValue val = this.model.fieldValues[i];
            inner.setWidget(i, 0, this.fieldSelector(val));
            inner.setWidget(i, 1, this.valueEditor(val));
            int idx = i;
            ImageButton remove = new ImageButton("images/delete_item_small.gif");
            remove.addClickListener((ClickListener)new /* Unavailable Anonymous Inner Class!! */);
            inner.setWidget(i, 2, (Widget)remove);
        }
        this.layout.setWidget(0, 1, (Widget)inner);
    }

    private Widget getSetterLabel() {
        HorizontalPanel horiz = new HorizontalPanel();
        ImageButton edit = new ImageButton("images/edit_tiny.gif");
        edit.setTitle("Add another field to this so you can set its value.");
        2 clk = new /* Unavailable Anonymous Inner Class!! */;
        edit.addClickListener((ClickListener)clk);
        String modifyType = "set";
        if (this.model instanceof ActionUpdateField) {
            modifyType = "modify";
        }
        ClickableLabel lbl = new ClickableLabel(HumanReadable.getActionDisplayName((String)modifyType) + " value of <b>[" + this.model.variable + "]</b>", (ClickListener)clk);
        horiz.add((Widget)lbl);
        horiz.add((Widget)edit);
        return horiz;
    }

    protected void showAddFieldPopup(Widget w) {
        FormStylePopup popup = new FormStylePopup("images/newex_wiz.gif", "Add a field");
        ListBox box = new ListBox();
        box.addItem("...");
        for (int i = 0; i < this.fieldCompletions.length; ++i) {
            box.addItem(this.fieldCompletions[i]);
        }
        box.setSelectedIndex(0);
        popup.addAttribute("Add field", (Widget)box);
        box.addChangeListener((ChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        popup.show();
    }

    private Widget valueEditor(ActionFieldValue val) {
        String type = "";
        type = this.completions.isGlobalVariable(this.model.variable) ? (String)this.completions.globalTypes.get(this.model.variable) : this.modeller.getModel().getBoundFact((String)this.model.variable).factType;
        DropDownData enums = this.completions.getEnums(type, this.model.fieldValues, val.field);
        return new ActionValueEditor(val, enums);
    }

    private Widget fieldSelector(ActionFieldValue val) {
        return new SmallLabel(val.field);
    }

    public boolean isBoundFact() {
        return this.isBoundFact;
    }

    public boolean isDirty() {
        return this.layout.hasDirty();
    }

    static /* synthetic */ ActionSetField access$000(ActionSetFieldWidget x0) {
        return x0.model;
    }

    static /* synthetic */ RuleModeller access$100(ActionSetFieldWidget x0) {
        return x0.modeller;
    }

    static /* synthetic */ String access$200(ActionSetFieldWidget x0) {
        return x0.variableClass;
    }

    static /* synthetic */ SuggestionCompletionEngine access$300(ActionSetFieldWidget x0) {
        return x0.completions;
    }
}

