/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.qa;

import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import org.drools.guvnor.client.common.PrettyFormLayout;
import org.drools.guvnor.client.common.SmallLabel;
import org.drools.guvnor.client.packages.PackageBuilderWidget;
import org.drools.guvnor.client.qa.ScenarioWidget;
import org.drools.guvnor.client.rpc.BuilderResult;
import org.drools.guvnor.client.rpc.BulkTestRunResult;
import org.drools.guvnor.client.rpc.ScenarioResultSummary;
import org.drools.guvnor.client.rulelist.EditItemEvent;

public class BulkRunResultWidget
extends Composite {
    private BulkTestRunResult result;
    private EditItemEvent editEvent;
    private PrettyFormLayout layout;
    private SimplePanel parent;
    private Command close;

    public BulkRunResultWidget(BulkTestRunResult result, EditItemEvent editEvent, Command close) {
        this.close = close;
        this.result = result;
        this.editEvent = editEvent;
        this.parent = new SimplePanel();
        if (result.errors != null && result.errors.length > 0) {
            this.showErrors();
        } else {
            this.showResult();
        }
        this.initWidget((Widget)this.parent);
    }

    private void showResult() {
        this.clear();
        int grandTotal = 0;
        int totalFailures = 0;
        FlexTable summaryTable = new FlexTable();
        ScenarioResultSummary[] summaries = this.result.results;
        for (int i = 0; i < summaries.length; ++i) {
            ScenarioResultSummary s = summaries[i];
            grandTotal += s.total;
            totalFailures += s.failures;
            summaryTable.setWidget(i, 0, (Widget)new SmallLabel(s.scenarioName + ":"));
            summaryTable.getFlexCellFormatter().setHorizontalAlignment(i, 0, HasHorizontalAlignment.ALIGN_RIGHT);
            if (s.failures > 0) {
                summaryTable.setWidget(i, 1, ScenarioWidget.getBar((String)"#CC0000", (int)150, (int)(s.total - s.failures), (int)s.total));
            } else {
                summaryTable.setWidget(i, 1, ScenarioWidget.getBar((String)"GREEN", (int)150, (float)100.0f));
            }
            summaryTable.setWidget(i, 2, (Widget)new SmallLabel("[" + s.failures + " failures out of " + s.total + "]"));
            Button open = new Button("Open");
            open.addClickListener((ClickListener)new /* Unavailable Anonymous Inner Class!! */);
            summaryTable.setWidget(i, 3, (Widget)open);
        }
        summaryTable.setWidth("100%");
        HorizontalPanel resultsH = new HorizontalPanel();
        if (totalFailures > 0) {
            resultsH.add(ScenarioWidget.getBar((String)"#CC0000", (int)300, (int)totalFailures, (int)grandTotal));
        } else {
            resultsH.add(ScenarioWidget.getBar((String)"GREEN", (int)300, (float)100.0f));
        }
        resultsH.add((Widget)new SmallLabel("&nbsp;" + totalFailures + " failures out of " + grandTotal + " expectations."));
        this.layout.startSection();
        this.layout.addAttribute("Overall result:", (Widget)new HTML(totalFailures == 0 ? "<b>SUCCESS</b>" : "<b>FAILURE</b>"));
        this.layout.addAttribute("Results:", (Widget)resultsH);
        HorizontalPanel coveredH = new HorizontalPanel();
        if (this.result.percentCovered < 100) {
            coveredH.add(ScenarioWidget.getBar((String)"YELLOW", (int)300, (float)this.result.percentCovered));
        } else {
            coveredH.add(ScenarioWidget.getBar((String)"GREEN", (int)300, (float)100.0f));
        }
        coveredH.add((Widget)new SmallLabel("&nbsp;" + this.result.percentCovered + "% of the rules were tested."));
        this.layout.addAttribute("Rules covered:", (Widget)coveredH);
        if (this.result.percentCovered < 100) {
            ListBox uncoveredRules = new ListBox();
            for (int i = 0; i < this.result.rulesNotCovered.length; ++i) {
                uncoveredRules.addItem(this.result.rulesNotCovered[i]);
            }
            uncoveredRules.setMultipleSelect(true);
            if (this.result.rulesNotCovered.length > 20) {
                uncoveredRules.setVisibleItemCount(20);
            } else {
                uncoveredRules.setVisibleItemCount(this.result.rulesNotCovered.length);
            }
            this.layout.addAttribute("Uncovered rules:", (Widget)uncoveredRules);
        }
        this.layout.endSection();
        this.layout.startSection("Scenarios");
        this.layout.addAttribute("", (Widget)summaryTable);
        Button c = new Button("Close");
        c.addClickListener((ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        this.layout.addRow((Widget)c);
        this.layout.endSection();
    }

    private void clear() {
        this.parent.clear();
        this.layout = new PrettyFormLayout();
        this.parent.add((Widget)this.layout);
    }

    private void showErrors() {
        this.clear();
        BuilderResult[] errors = this.result.errors;
        SimplePanel err = new SimplePanel();
        PackageBuilderWidget.showBuilderErrors((BuilderResult[])errors, (Panel)err, (EditItemEvent)this.editEvent);
        this.layout.startSection("Build errors - unable to run scenarios");
        this.layout.addRow((Widget)err);
        this.layout.endSection();
    }

    static /* synthetic */ EditItemEvent access$000(BulkRunResultWidget x0) {
        return x0.editEvent;
    }

    static /* synthetic */ Command access$100(BulkRunResultWidget x0) {
        return x0.close;
    }
}

