/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.ruleeditor;

import com.google.gwt.user.client.ui.Widget;
import com.gwtext.client.data.ArrayReader;
import com.gwtext.client.data.DataProxy;
import com.gwtext.client.data.FieldDef;
import com.gwtext.client.data.MemoryProxy;
import com.gwtext.client.data.Reader;
import com.gwtext.client.data.Record;
import com.gwtext.client.data.RecordDef;
import com.gwtext.client.data.Store;
import com.gwtext.client.data.StringFieldDef;
import com.gwtext.client.widgets.Component;
import com.gwtext.client.widgets.Panel;
import com.gwtext.client.widgets.Toolbar;
import com.gwtext.client.widgets.ToolbarButton;
import com.gwtext.client.widgets.event.ButtonListener;
import com.gwtext.client.widgets.form.Field;
import com.gwtext.client.widgets.form.TextField;
import com.gwtext.client.widgets.grid.BaseColumnConfig;
import com.gwtext.client.widgets.grid.ColumnConfig;
import com.gwtext.client.widgets.grid.ColumnModel;
import com.gwtext.client.widgets.grid.EditorGridPanel;
import com.gwtext.client.widgets.grid.GridEditor;
import java.util.ArrayList;
import org.drools.guvnor.client.packages.AssetAttachmentFileWidget;
import org.drools.guvnor.client.rpc.RuleAsset;
import org.drools.guvnor.client.ruleeditor.PropertiesHolder;
import org.drools.guvnor.client.ruleeditor.PropertyHolder;
import org.drools.guvnor.client.ruleeditor.RuleViewer;
import org.drools.guvnor.client.ruleeditor.SaveEventListener;

public class PropertiesWidget
extends AssetAttachmentFileWidget
implements SaveEventListener {
    PropertiesHolder properties;
    Store store;

    public PropertiesWidget(RuleAsset asset, RuleViewer viewer) {
        super(asset, viewer);
        this.properties = asset.content == null ? new PropertiesHolder() : (PropertiesHolder)asset.content;
        Panel panel = new Panel();
        panel.setBorder(false);
        panel.setPaddings(15);
        RecordDef recordDef = new RecordDef(new FieldDef[]{new StringFieldDef("key"), new StringFieldDef("value")});
        Object[][] data = new String[this.properties.list.size()][];
        int dataIndex = 0;
        for (PropertyHolder holder : this.properties.list) {
            data[dataIndex++] = new String[]{holder.name, holder.value};
        }
        MemoryProxy proxy = new MemoryProxy(data);
        this.store = new Store((DataProxy)proxy, (Reader)new ArrayReader(recordDef));
        this.store.load();
        ColumnConfig keyCol = new ColumnConfig("Key?", "key", 100, true, null, "key");
        keyCol.setEditor(new GridEditor((Field)new TextField()));
        keyCol.setFixed(false);
        ColumnConfig valueCol = new ColumnConfig("Value?", "value", 100, true, null, "value");
        valueCol.setEditor(new GridEditor((Field)new TextField()));
        valueCol.setFixed(false);
        ColumnConfig[] columnConfigs = new ColumnConfig[]{keyCol, valueCol};
        ColumnModel columnModel = new ColumnModel((BaseColumnConfig[])columnConfigs);
        columnModel.setDefaultSortable(true);
        EditorGridPanel grid = new EditorGridPanel();
        Toolbar toolbar = new Toolbar();
        ToolbarButton add = new ToolbarButton("Add", (ButtonListener)new /* Unavailable Anonymous Inner Class!! */);
        toolbar.addButton(add);
        ToolbarButton clear = new ToolbarButton("Clear", (ButtonListener)new /* Unavailable Anonymous Inner Class!! */);
        toolbar.addButton(clear);
        grid.setStore(this.store);
        grid.setColumnModel(columnModel);
        grid.setWidth(215);
        grid.setHeight(300);
        grid.setTitle("Properties");
        grid.setFrame(true);
        grid.setClicksToEdit(2);
        grid.setTopToolbar(toolbar);
        panel.add((Component)grid);
        this.layout.addRow((Widget)grid);
    }

    private void addNewField(RecordDef recordDef, EditorGridPanel grid) {
        Record pair = recordDef.createRecord(new Object[]{"", ""});
        grid.stopEditing();
        this.store.insert(0, pair);
        grid.startEditing(0, 0);
    }

    public String getIcon() {
        return "";
    }

    public String getOverallStyleName() {
        return "";
    }

    public void onSave() {
        Record[] records;
        ArrayList<PropertyHolder> result = new ArrayList<PropertyHolder>();
        for (Record record : records = this.store.getRecords()) {
            String key = record.getAsString("key");
            if (key == null || "".equals(key)) continue;
            result.add(new PropertyHolder(key, record.getAsString("value")));
        }
        this.properties.list = result;
        this.asset.content = this.properties;
    }

    public void onAfterSave() {
    }

    static /* synthetic */ void access$000(PropertiesWidget x0, RecordDef x1, EditorGridPanel x2) {
        x0.addNewField(x1, x2);
    }
}

