/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.ruleeditor;

import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.gwtext.client.widgets.Panel;
import com.gwtext.client.widgets.Toolbar;
import com.gwtext.client.widgets.ToolbarButton;
import com.gwtext.client.widgets.event.ButtonListener;
import org.drools.guvnor.client.common.FormStyleLayout;
import org.drools.guvnor.client.common.FormStylePopup;
import org.drools.guvnor.client.common.LoadingPopup;
import org.drools.guvnor.client.explorer.Preferences;
import org.drools.guvnor.client.rpc.RuleAsset;
import org.drools.guvnor.client.rpc.RuleFlowContentModel;
import org.drools.guvnor.client.ruleeditor.RuleFlowUploadWidget;
import org.drools.guvnor.client.ruleeditor.RuleViewer;
import org.drools.guvnor.client.ruleeditor.SaveEventListener;
import org.drools.guvnor.client.rulefloweditor.RuleFlowViewer;

public class RuleFlowWrapper
extends Composite
implements SaveEventListener {
    private RuleViewer viewer;
    private RuleAsset asset;
    private RuleFlowViewer ruleFlowViewer;
    private Panel parameterPanel;

    public RuleFlowWrapper(RuleAsset asset, RuleViewer viewer) {
        this.viewer = viewer;
        this.asset = asset;
        this.initWidgets(asset.uuid, asset.metaData.name);
    }

    protected void initWidgets(String uuid, String formName) {
        RuleFlowUploadWidget uploadWidget = new RuleFlowUploadWidget(this.asset, this.viewer);
        VerticalPanel panel = new VerticalPanel();
        panel.add((Widget)uploadWidget);
        if (Preferences.getBooleanPref((String)"visual-ruleflow")) {
            this.initRuleflowViewer();
            if (this.ruleFlowViewer != null && this.parameterPanel != null) {
                Toolbar tb = new Toolbar();
                ToolbarButton viewSource = new ToolbarButton();
                viewSource.setText("View diagram");
                viewSource.addListener((ButtonListener)new /* Unavailable Anonymous Inner Class!! */);
                tb.addButton(viewSource);
                panel.add((Widget)tb);
            }
        }
        this.initWidget((Widget)panel);
        this.setStyleName(this.getOverallStyleName());
    }

    private void doViewDiagram() {
        LoadingPopup.showMessage((String)"Calculating source...");
        FormStylePopup pop = new FormStylePopup("images/view_source.gif", "Viewing diagram", new Integer(600), Boolean.FALSE);
        pop.addRow((Widget)this.ruleFlowViewer);
        pop.addRow((Widget)this.parameterPanel);
        pop.show();
        LoadingPopup.close();
    }

    private void initRuleflowViewer() {
        RuleFlowContentModel rfcm = (RuleFlowContentModel)this.asset.content;
        if (rfcm != null && rfcm.getXml() != null && rfcm.getNodes() != null) {
            try {
                this.parameterPanel = new Panel();
                this.parameterPanel.setCollapsible(true);
                this.parameterPanel.setTitle("Parameters");
                FormStyleLayout parametersForm = new FormStyleLayout();
                parametersForm.setHeight("120px");
                this.parameterPanel.add((Widget)parametersForm);
                this.ruleFlowViewer = new RuleFlowViewer(rfcm, parametersForm);
            }
            catch (Exception e) {
                Window.alert((String)e.toString());
            }
        } else if (rfcm != null && rfcm.getXml() == null) {
            Window.alert((String)"Could not create the ruleflow diagram. It is possible that the ruleflow file is invalid.");
        }
    }

    public String getIcon() {
        return "images/ruleflow_large.png";
    }

    public String getOverallStyleName() {
        return "decision-Table-upload";
    }

    public void onAfterSave() {
    }

    public void onSave() {
        RuleFlowContentModel rfcm = (RuleFlowContentModel)this.asset.content;
        rfcm.setNodes(this.ruleFlowViewer.getTransferNodes());
    }

    public RuleFlowViewer getRuleFlowViewer() {
        return this.ruleFlowViewer;
    }

    static /* synthetic */ void access$000(RuleFlowWrapper x0) {
        x0.doViewDiagram();
    }

    static /* synthetic */ RuleFlowViewer access$100(RuleFlowWrapper x0) {
        return x0.ruleFlowViewer;
    }
}

