/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server;

import com.google.gwt.user.client.rpc.SerializableException;
import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.drools.guvnor.client.modeldriven.SuggestionCompletionEngine;
import org.drools.guvnor.client.modeldriven.testing.Scenario;
import org.drools.guvnor.client.rpc.AnalysisReport;
import org.drools.guvnor.client.rpc.BuilderResult;
import org.drools.guvnor.client.rpc.BulkTestRunResult;
import org.drools.guvnor.client.rpc.DetailedSerializableException;
import org.drools.guvnor.client.rpc.LogEntry;
import org.drools.guvnor.client.rpc.MetaDataQuery;
import org.drools.guvnor.client.rpc.PackageConfigData;
import org.drools.guvnor.client.rpc.RepositoryService;
import org.drools.guvnor.client.rpc.RuleAsset;
import org.drools.guvnor.client.rpc.SingleScenarioResult;
import org.drools.guvnor.client.rpc.SnapshotInfo;
import org.drools.guvnor.client.rpc.TableConfig;
import org.drools.guvnor.client.rpc.TableDataResult;
import org.drools.guvnor.client.rpc.ValidatedResponse;
import org.drools.guvnor.server.ServiceImplementation;
import org.drools.guvnor.server.util.LoggingHelper;
import org.drools.guvnor.server.util.TestEnvironmentSessionHelper;
import org.drools.repository.RulesRepository;
import org.drools.repository.RulesRepositoryException;
import org.jboss.seam.Component;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.security.AuthorizationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class RepositoryServiceServlet
extends RemoteServiceServlet
implements RepositoryService {
    private static final Logger log = LoggingHelper.getLogger();

    public static ServiceImplementation getService() {
        if (Contexts.isApplicationContextActive()) {
            return (ServiceImplementation)Component.getInstance((String)"org.drools.guvnor.client.rpc.RepositoryService");
        }
        ServiceImplementation impl = new ServiceImplementation();
        impl.repository = new RulesRepository(TestEnvironmentSessionHelper.getSession((boolean)false));
        return impl;
    }

    protected void doUnexpectedFailure(Throwable e) {
        if (e.getCause() instanceof AuthorizationException) {
            HttpServletResponse response = this.getThreadLocalResponse();
            try {
                log.error((Object)e.getCause());
                response.setContentType("text/plain");
                response.setStatus(401);
                response.getWriter().write("Sorry, insufficient permissions to perform this action.");
            }
            catch (IOException ex) {
                this.getServletContext().log("respondWithUnexpectedFailure failed while sending the previous failure to the client", (Throwable)ex);
            }
        } else if (e.getCause() instanceof RulesRepositoryException) {
            log.error((Object)e.getCause());
            HttpServletResponse response = this.getThreadLocalResponse();
            response.setContentType("text/plain");
            response.setStatus(400);
            try {
                response.getWriter().write(e.getCause().getMessage());
            }
            catch (IOException ex) {
                this.getServletContext().log("respondWithUnexpectedFailure failed while sending the previous failure to the client", (Throwable)ex);
            }
        } else {
            log.error((Object)e.getCause());
            super.doUnexpectedFailure(e);
        }
    }

    public String[] loadChildCategories(String p0) {
        return RepositoryServiceServlet.getService().loadChildCategories(p0);
    }

    public TableDataResult loadRuleListForCategories(String p0, int p1, int p2, String p3) throws SerializableException {
        return RepositoryServiceServlet.getService().loadRuleListForCategories(p0, p1, p2, p3);
    }

    public TableDataResult loadRuleListForState(String p0, int p1, int p2, String p3) throws SerializableException {
        return RepositoryServiceServlet.getService().loadRuleListForState(p0, p1, p2, p3);
    }

    public TableConfig loadTableConfig(String p0) {
        return RepositoryServiceServlet.getService().loadTableConfig(p0);
    }

    public Boolean createCategory(String p0, String p1, String p2) {
        return RepositoryServiceServlet.getService().createCategory(p0, p1, p2);
    }

    public String createNewRule(String p0, String p1, String p2, String p3, String p4) throws SerializableException {
        return RepositoryServiceServlet.getService().createNewRule(p0, p1, p2, p3, p4);
    }

    public void deleteUncheckedRule(String p0, String p1) {
        RepositoryServiceServlet.getService().deleteUncheckedRule(p0, p1);
    }

    public void clearRulesRepository() {
        RepositoryServiceServlet.getService().clearRulesRepository();
    }

    public PackageConfigData[] listPackages() {
        return RepositoryServiceServlet.getService().listPackages();
    }

    public PackageConfigData[] listArchivedPackages() {
        return RepositoryServiceServlet.getService().listArchivedPackages();
    }

    public RuleAsset loadRuleAsset(String p0) throws SerializableException {
        return RepositoryServiceServlet.getService().loadRuleAsset(p0);
    }

    public TableDataResult loadAssetHistory(String p0) throws SerializableException {
        return RepositoryServiceServlet.getService().loadAssetHistory(p0);
    }

    public TableDataResult loadArchivedAssets(int p0, int p1) throws SerializableException {
        return RepositoryServiceServlet.getService().loadArchivedAssets(p0, p1);
    }

    public String checkinVersion(RuleAsset p0) throws SerializableException {
        return RepositoryServiceServlet.getService().checkinVersion(p0);
    }

    public void restoreVersion(String p0, String p1, String p2) {
        RepositoryServiceServlet.getService().restoreVersion(p0, p1, p2);
    }

    public String createPackage(String p0, String p1) throws SerializableException {
        return RepositoryServiceServlet.getService().createPackage(p0, p1);
    }

    public PackageConfigData loadPackageConfig(String p0) {
        return RepositoryServiceServlet.getService().loadPackageConfig(p0);
    }

    public ValidatedResponse savePackage(PackageConfigData p0) throws SerializableException {
        return RepositoryServiceServlet.getService().savePackage(p0);
    }

    public TableDataResult listAssets(String p0, String[] p1, int p2, int p3, String p4) throws SerializableException {
        return RepositoryServiceServlet.getService().listAssets(p0, p1, p2, p3, p4);
    }

    public String[] listStates() throws SerializableException {
        return RepositoryServiceServlet.getService().listStates();
    }

    public String createState(String p0) throws SerializableException {
        return RepositoryServiceServlet.getService().createState(p0);
    }

    public void removeState(String name) throws SerializableException {
        RepositoryServiceServlet.getService().removeState(name);
    }

    public void renameState(String oldName, String newName) throws SerializableException {
        RepositoryServiceServlet.getService().renameState(oldName, newName);
    }

    public void changeState(String p0, String p1, boolean p2) {
        RepositoryServiceServlet.getService().changeState(p0, p1, p2);
    }

    public void changeAssetPackage(String p0, String p1, String p2) {
        RepositoryServiceServlet.getService().changeAssetPackage(p0, p1, p2);
    }

    public String copyAsset(String p0, String p1, String p2) {
        return RepositoryServiceServlet.getService().copyAsset(p0, p1, p2);
    }

    public void copyPackage(String p0, String p1) throws SerializableException {
        RepositoryServiceServlet.getService().copyPackage(p0, p1);
    }

    public SnapshotInfo[] listSnapshots(String p0) {
        return RepositoryServiceServlet.getService().listSnapshots(p0);
    }

    public void createPackageSnapshot(String p0, String p1, boolean p2, String p3) {
        RepositoryServiceServlet.getService().createPackageSnapshot(p0, p1, p2, p3);
    }

    public void copyOrRemoveSnapshot(String p0, String p1, boolean p2, String p3) throws SerializableException {
        RepositoryServiceServlet.getService().copyOrRemoveSnapshot(p0, p1, p2, p3);
    }

    public TableDataResult quickFindAsset(String p0, int p1, boolean p2) {
        return RepositoryServiceServlet.getService().quickFindAsset(p0, p1, p2);
    }

    public void removeCategory(String p0) throws SerializableException {
        RepositoryServiceServlet.getService().removeCategory(p0);
    }

    public SuggestionCompletionEngine loadSuggestionCompletionEngine(String p0) throws SerializableException {
        return RepositoryServiceServlet.getService().loadSuggestionCompletionEngine(p0);
    }

    public BuilderResult[] buildPackage(String p0, String p1, boolean p2) throws SerializableException {
        return RepositoryServiceServlet.getService().buildPackage(p0, p1, p2);
    }

    public String buildPackageSource(String p0) throws SerializableException {
        return RepositoryServiceServlet.getService().buildPackageSource(p0);
    }

    public String buildAssetSource(RuleAsset p0) throws SerializableException {
        return RepositoryServiceServlet.getService().buildAssetSource(p0);
    }

    public BuilderResult[] buildAsset(RuleAsset p0) throws SerializableException {
        return RepositoryServiceServlet.getService().buildAsset(p0);
    }

    public String renameAsset(String p0, String p1) {
        return RepositoryServiceServlet.getService().renameAsset(p0, p1);
    }

    public void renameCategory(String p0, String p1) {
        RepositoryServiceServlet.getService().renameCategory(p0, p1);
    }

    public void archiveAsset(String p0, boolean p1) {
        RepositoryServiceServlet.getService().archiveAsset(p0, p1);
    }

    public void removeAsset(String p0) {
        RepositoryServiceServlet.getService().removeAsset(p0);
    }

    public void removePackage(String p0) {
        RepositoryServiceServlet.getService().removePackage(p0);
    }

    public String renamePackage(String p0, String p1) {
        return RepositoryServiceServlet.getService().renamePackage(p0, p1);
    }

    public void rebuildSnapshots() throws SerializableException {
        RepositoryServiceServlet.getService().rebuildSnapshots();
    }

    public void rebuildPackages() throws SerializableException {
        RepositoryServiceServlet.getService().rebuildPackages();
    }

    public String[] listRulesInPackage(String p0) throws SerializableException {
        return RepositoryServiceServlet.getService().listRulesInPackage(p0);
    }

    public SingleScenarioResult runScenario(String p0, Scenario p1) throws SerializableException {
        return RepositoryServiceServlet.getService().runScenario(p0, p1);
    }

    public BulkTestRunResult runScenariosInPackage(String p0) throws SerializableException {
        return RepositoryServiceServlet.getService().runScenariosInPackage(p0);
    }

    public AnalysisReport analysePackage(String p0) throws SerializableException {
        return RepositoryServiceServlet.getService().analysePackage(p0);
    }

    public String[] listTypesInPackage(String p0) throws SerializableException {
        return RepositoryServiceServlet.getService().listTypesInPackage(p0);
    }

    public LogEntry[] showLog() {
        return RepositoryServiceServlet.getService().showLog();
    }

    public String[] loadDropDownExpression(String[] p0, String p1) {
        return RepositoryServiceServlet.getService().loadDropDownExpression(p0, p1);
    }

    public TableDataResult queryFullText(String p0, boolean p1, int p2, int p3) throws SerializableException {
        return RepositoryServiceServlet.getService().queryFullText(p0, p1, p2, p3);
    }

    public TableDataResult queryMetaData(MetaDataQuery[] p0, Date p1, Date p2, Date p3, Date p4, boolean p5, int p6, int p7) throws SerializableException {
        return RepositoryServiceServlet.getService().queryMetaData(p0, p1, p2, p3, p4, p5, p6, p7);
    }

    public Map<String, List<String>> listUserPermissions() throws DetailedSerializableException {
        return RepositoryServiceServlet.getService().listUserPermissions();
    }

    public Map<String, List<String>> retrieveUserPermissions(String userName) {
        return RepositoryServiceServlet.getService().retrieveUserPermissions(userName);
    }

    public void updateUserPermissions(String userName, Map<String, List<String>> perms) {
        RepositoryServiceServlet.getService().updateUserPermissions(userName, perms);
    }

    public String[] listAvailablePermissionTypes() {
        return RepositoryServiceServlet.getService().listAvailablePermissionTypes();
    }

    public void deleteUser(String userName) {
        RepositoryServiceServlet.getService().deleteUser(userName);
    }

    public String getAssetLockerUserName(String uuid) {
        return RepositoryServiceServlet.getService().getAssetLockerUserName(uuid);
    }

    public void lockAsset(String uuid) {
        RepositoryServiceServlet.getService().lockAsset(uuid);
    }

    public void unLockAsset(String uuid) {
        RepositoryServiceServlet.getService().unLockAsset(uuid);
    }

    public void installSampleRepository() throws SerializableException {
        RepositoryServiceServlet.getService().installSampleRepository();
    }
}

