/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server;

import com.google.gwt.user.client.rpc.SerializableException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import javax.jcr.ItemExistsException;
import javax.jcr.RepositoryException;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.util.ISO8601;
import org.apache.log4j.Logger;
import org.drools.RuleBase;
import org.drools.RuleBaseConfiguration;
import org.drools.RuleBaseFactory;
import org.drools.SessionConfiguration;
import org.drools.WorkingMemory;
import org.drools.base.ClassTypeResolver;
import org.drools.base.TypeResolver;
import org.drools.common.AbstractRuleBase;
import org.drools.common.DroolsObjectOutputStream;
import org.drools.common.InternalRuleBase;
import org.drools.common.InternalWorkingMemory;
import org.drools.compiler.DrlParser;
import org.drools.compiler.DroolsParserException;
import org.drools.event.AgendaEventListener;
import org.drools.guvnor.client.modeldriven.SuggestionCompletionEngine;
import org.drools.guvnor.client.modeldriven.testing.Scenario;
import org.drools.guvnor.client.rpc.AnalysisReport;
import org.drools.guvnor.client.rpc.BuilderResult;
import org.drools.guvnor.client.rpc.BulkTestRunResult;
import org.drools.guvnor.client.rpc.DetailedSerializableException;
import org.drools.guvnor.client.rpc.LogEntry;
import org.drools.guvnor.client.rpc.MetaData;
import org.drools.guvnor.client.rpc.MetaDataQuery;
import org.drools.guvnor.client.rpc.PackageConfigData;
import org.drools.guvnor.client.rpc.RepositoryService;
import org.drools.guvnor.client.rpc.RuleAsset;
import org.drools.guvnor.client.rpc.ScenarioResultSummary;
import org.drools.guvnor.client.rpc.ScenarioRunResult;
import org.drools.guvnor.client.rpc.SingleScenarioResult;
import org.drools.guvnor.client.rpc.SnapshotInfo;
import org.drools.guvnor.client.rpc.TableConfig;
import org.drools.guvnor.client.rpc.TableDataResult;
import org.drools.guvnor.client.rpc.TableDataRow;
import org.drools.guvnor.client.rpc.ValidatedResponse;
import org.drools.guvnor.server.AssetItemFilter;
import org.drools.guvnor.server.CategoryFilter;
import org.drools.guvnor.server.PackageFilter;
import org.drools.guvnor.server.ServiceImplementation;
import org.drools.guvnor.server.builder.AuditLogReporter;
import org.drools.guvnor.server.builder.BRMSPackageBuilder;
import org.drools.guvnor.server.builder.ContentAssemblyError;
import org.drools.guvnor.server.builder.ContentPackageAssembler;
import org.drools.guvnor.server.contenthandler.ContentHandler;
import org.drools.guvnor.server.contenthandler.ContentManager;
import org.drools.guvnor.server.contenthandler.IRuleAsset;
import org.drools.guvnor.server.contenthandler.IValidating;
import org.drools.guvnor.server.contenthandler.ModelContentHandler;
import org.drools.guvnor.server.security.AdminType;
import org.drools.guvnor.server.security.CategoryPathType;
import org.drools.guvnor.server.security.PackageNameType;
import org.drools.guvnor.server.security.PackageUUIDType;
import org.drools.guvnor.server.security.RoleTypes;
import org.drools.guvnor.server.util.AssetFormatHelper;
import org.drools.guvnor.server.util.AssetLockManager;
import org.drools.guvnor.server.util.BRMSSuggestionCompletionLoader;
import org.drools.guvnor.server.util.LoggingHelper;
import org.drools.guvnor.server.util.MetaDataMapper;
import org.drools.guvnor.server.util.TableDisplayHandler;
import org.drools.guvnor.server.util.VerifierRunner;
import org.drools.lang.descr.PackageDescr;
import org.drools.lang.descr.RuleDescr;
import org.drools.lang.descr.TypeDeclarationDescr;
import org.drools.repository.AssetHistoryIterator;
import org.drools.repository.AssetItem;
import org.drools.repository.AssetItemIterator;
import org.drools.repository.AssetPageList;
import org.drools.repository.CategoryItem;
import org.drools.repository.PackageItem;
import org.drools.repository.PackageIterator;
import org.drools.repository.RepositoryFilter;
import org.drools.repository.RulesRepository;
import org.drools.repository.RulesRepositoryAdministrator;
import org.drools.repository.RulesRepositoryException;
import org.drools.repository.StateItem;
import org.drools.repository.VersionableItem;
import org.drools.repository.security.PermissionManager;
import org.drools.rule.Package;
import org.drools.runtime.rule.ConsequenceException;
import org.drools.testframework.RuleCoverageListener;
import org.drools.testframework.ScenarioRunner;
import org.drools.util.DroolsStreamUtils;
import org.jboss.seam.annotations.AutoCreate;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.remoting.WebRemote;
import org.jboss.seam.annotations.security.Restrict;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.security.Identity;
import org.mvel2.MVEL;
import org.mvel2.templates.TemplateRuntime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
@Name(value="org.drools.guvnor.client.rpc.RepositoryService")
@AutoCreate
public class ServiceImplementation
implements RepositoryService {
    private static final int MAX_RULES_TO_SHOW_IN_PACKAGE_LIST = 5000;
    @In
    public RulesRepository repository;
    private static final long serialVersionUID = 400L;
    private static final DateFormat dateFormatter = DateFormat.getInstance();
    private static final Logger log = LoggingHelper.getLogger();
    private MetaDataMapper metaDataMapper = new MetaDataMapper();
    static Map<String, RuleBase> ruleBaseCache = Collections.synchronizedMap(new HashMap());

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public String[] loadChildCategories(String categoryPath) {
        ArrayList<String> resultList = new ArrayList<String>();
        CategoryFilter filter = new CategoryFilter();
        CategoryItem item = this.repository.loadCategory(categoryPath);
        List children = item.getChildTags();
        for (int i = 0; i < children.size(); ++i) {
            String childCategoryName = ((CategoryItem)children.get(i)).getName();
            if (!filter.acceptNavigate(categoryPath, childCategoryName)) continue;
            resultList.add(childCategoryName);
        }
        String[] resultArr = resultList.toArray(new String[resultList.size()]);
        return resultArr;
    }

    @WebRemote
    public Boolean createCategory(String path, String name, String description) {
        if (Contexts.isSessionContextActive()) {
            Identity.instance().checkPermission((Object)new AdminType(), "admin");
        }
        log.info((Object)("USER:" + this.repository.getSession().getUserID() + " CREATING cateogory: [" + name + "] in path [" + path + "]"));
        if (path == null || "".equals(path)) {
            path = "/";
        }
        path = this.cleanHTML(path);
        CategoryItem item = this.repository.loadCategory(path);
        item.addCategory(name, description);
        this.repository.save();
        return Boolean.TRUE;
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public String createNewRule(String ruleName, String description, String initialCategory, String initialPackage, String format) throws SerializableException {
        if (Contexts.isSessionContextActive()) {
            Identity.instance().checkPermission((Object)new PackageNameType(initialPackage), "package.developer");
        }
        log.info((Object)("USER:" + this.repository.getSession().getUserID() + " CREATING new asset name [" + ruleName + "] in package [" + initialPackage + "]"));
        try {
            PackageItem pkg = this.repository.loadPackage(initialPackage);
            AssetItem asset = pkg.addAsset(ruleName, description, initialCategory, format);
            this.applyPreBuiltTemplates(ruleName, format, asset);
            this.repository.save();
            return asset.getUUID();
        }
        catch (RulesRepositoryException e) {
            if (e.getCause() instanceof ItemExistsException) {
                return "DUPLICATE";
            }
            log.error((Object)e);
            throw new SerializableException(e.getMessage());
        }
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public void deleteUncheckedRule(String uuid, String initialPackage) {
        if (Contexts.isSessionContextActive()) {
            Identity.instance().checkPermission((Object)new AdminType(), "package.admin");
        }
        AssetItem asset = this.repository.loadAssetByUUID(uuid);
        asset.remove();
        this.repository.save();
    }

    private void applyPreBuiltTemplates(String ruleName, String format, AssetItem asset) {
        if (format.equals("dslr")) {
            asset.updateContent("when\n\nthen\n");
        } else if (format.equals("function")) {
            asset.updateContent("function <returnType> " + ruleName + "(<args here>) {\n\n\n}");
        } else if (format.equals("dsl")) {
            asset.updateContent("[when]Condition sentence template {var}=rule language mapping {var}\n[then]Action sentence template=rule language mapping");
        } else if (format.equals("xls")) {
            asset.updateBinaryContentAttachment(this.getClass().getResourceAsStream("/SampleDecisionTable.xls"));
            asset.updateBinaryContentAttachmentFileName("SampleDecisionTable.xls");
        } else if (format.equals("drl")) {
            asset.updateContent("when\n\t#conditions\nthen\n\t#actions");
        } else if (format.equals("enumeration")) {
            // empty if block
        }
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public PackageConfigData[] listPackages() {
        PackageFilter pf = new PackageFilter();
        return this.listPackages(false, (RepositoryFilter)pf);
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public PackageConfigData[] listArchivedPackages() {
        PackageFilter pf = new PackageFilter();
        return this.listPackages(true, (RepositoryFilter)pf);
    }

    private PackageConfigData[] listPackages(boolean archive, RepositoryFilter filter) {
        ArrayList<PackageConfigData> result = new ArrayList<PackageConfigData>();
        PackageIterator pkgs = this.repository.listPackages();
        pkgs.setArchivedIterator(archive);
        while (pkgs.hasNext()) {
            PackageItem pkg = (PackageItem)pkgs.next();
            PackageConfigData data = new PackageConfigData();
            data.uuid = pkg.getUUID();
            data.name = pkg.getName();
            data.archived = pkg.isArchived();
            if (!archive && (filter == null || filter.accept((Object)data, "package.readonly"))) {
                result.add(data);
                continue;
            }
            if (!archive || !data.archived || filter != null && !filter.accept((Object)data, "package.readonly")) continue;
            result.add(data);
        }
        this.sortPackages(result);
        PackageConfigData[] resultArr = result.toArray(new PackageConfigData[result.size()]);
        return resultArr;
    }

    void sortPackages(List<PackageConfigData> result) {
        Collections.sort(result, new /* Unavailable Anonymous Inner Class!! */);
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public TableDataResult loadRuleListForCategories(String categoryPath, int skip, int numRows, String tableConfig) throws SerializableException {
        if (Contexts.isSessionContextActive() && !Identity.instance().hasPermission((Object)new CategoryPathType(categoryPath), "analyst.readonly")) {
            TableDisplayHandler handler = new TableDisplayHandler(tableConfig);
            return handler.loadRuleListTable(new AssetPageList());
        }
        RepositoryFilter filter = null;
        AssetPageList list = this.repository.findAssetsByCategory(categoryPath, false, skip, numRows, filter);
        TableDisplayHandler handler = new TableDisplayHandler(tableConfig);
        return handler.loadRuleListTable(list);
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public TableDataResult loadRuleListForState(String stateName, int skip, int numRows, String tableConfig) throws SerializableException {
        AssetItemFilter filter = new AssetItemFilter();
        AssetPageList list = this.repository.findAssetsByState(stateName, false, skip, numRows, (RepositoryFilter)filter);
        TableDisplayHandler handler = new TableDisplayHandler(tableConfig);
        return handler.loadRuleListTable(list);
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public TableConfig loadTableConfig(String listName) {
        TableDisplayHandler handler = new TableDisplayHandler(listName);
        return handler.loadTableConfig();
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public RuleAsset loadRuleAsset(String uuid) throws SerializableException {
        long time = System.currentTimeMillis();
        AssetItem item = this.repository.loadAssetByUUID(uuid);
        RuleAsset asset = new RuleAsset();
        asset.uuid = uuid;
        asset.metaData = this.populateMetaData(item);
        if (Contexts.isSessionContextActive()) {
            Identity.instance().checkPermission((Object)new PackageNameType(asset.metaData.packageName), "package.readonly");
            if (asset.metaData.categories.length == 0) {
                Identity.instance().checkPermission((Object)new CategoryPathType(null), "analyst.readonly");
            } else {
                boolean passed = false;
                RuntimeException exception = null;
                for (String cat : asset.metaData.categories) {
                    try {
                        Identity.instance().checkPermission((Object)new CategoryPathType(cat), "analyst.readonly");
                        passed = true;
                    }
                    catch (RuntimeException e) {
                        exception = e;
                    }
                }
                if (!passed) {
                    throw exception;
                }
            }
        }
        PackageItem pkgItem = item.getPackage();
        ContentHandler handler = ContentManager.getHandler((String)asset.metaData.format);
        handler.retrieveAssetContent(asset, pkgItem, item);
        if (pkgItem.isSnapshot()) {
            asset.isreadonly = true;
        }
        log.debug((Object)("Load time taken for asset: " + (System.currentTimeMillis() - time)));
        return asset;
    }

    private RuleAsset loadAsset(AssetItem item) throws SerializableException {
        RuleAsset asset = new RuleAsset();
        asset.uuid = item.getUUID();
        asset.metaData = this.populateMetaData(item);
        PackageItem pkgItem = item.getPackage();
        ContentHandler handler = ContentManager.getHandler((String)asset.metaData.format);
        handler.retrieveAssetContent(asset, pkgItem, item);
        return asset;
    }

    MetaData populateMetaData(VersionableItem item) {
        MetaData meta = new MetaData();
        meta.status = item.getState() != null ? item.getState().getName() : "";
        this.metaDataMapper.copyToMetaData(meta, (Object)item);
        meta.createdDate = this.calendarToDate(item.getCreatedDate());
        meta.lastModifiedDate = this.calendarToDate(item.getLastModified());
        return meta;
    }

    MetaData populateMetaData(AssetItem item) {
        MetaData meta = this.populateMetaData((VersionableItem)item);
        meta.packageName = item.getPackageName();
        List cats = item.getCategories();
        meta.categories = new String[cats.size()];
        for (int i = 0; i < meta.categories.length; ++i) {
            CategoryItem cat = (CategoryItem)cats.get(i);
            meta.categories[i] = cat.getFullPath();
        }
        meta.dateEffective = this.calendarToDate(item.getDateEffective());
        meta.dateExpired = this.calendarToDate(item.getDateExpired());
        return meta;
    }

    private Date calendarToDate(Calendar createdDate) {
        if (createdDate == null) {
            return null;
        }
        return createdDate.getTime();
    }

    private Calendar dateToCalendar(Date date) {
        if (date == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal;
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public String checkinVersion(RuleAsset asset) throws SerializableException {
        if (Contexts.isSessionContextActive()) {
            Identity.instance().checkPermission((Object)new PackageNameType(asset.metaData.packageName), "package.developer");
            if (asset.metaData.categories.length == 0) {
                Identity.instance().checkPermission((Object)new CategoryPathType(null), "analyst");
            } else {
                boolean passed = false;
                RuntimeException exception = null;
                for (String cat : asset.metaData.categories) {
                    try {
                        Identity.instance().checkPermission((Object)new CategoryPathType(cat), "analyst");
                        passed = true;
                    }
                    catch (RuntimeException e) {
                        exception = e;
                    }
                }
                if (!passed) {
                    throw exception;
                }
            }
        }
        log.info((Object)("USER:" + this.repository.getSession().getUserID() + " CHECKING IN asset: [" + asset.metaData.name + "] UUID: [" + asset.uuid + "]  ARCHIVED [" + asset.archived + "]"));
        AssetItem repoAsset = this.repository.loadAssetByUUID(asset.uuid);
        if (asset.metaData.lastModifiedDate.before(repoAsset.getLastModified().getTime())) {
            return "ERR: Unable to save this asset, as it has been recently updated by [" + repoAsset.getLastContributor() + "]";
        }
        repoAsset.archiveItem(asset.archived);
        MetaData meta = asset.metaData;
        this.metaDataMapper.copyFromMetaData(meta, (Object)repoAsset);
        repoAsset.updateDateEffective(this.dateToCalendar(meta.dateEffective));
        repoAsset.updateDateExpired(this.dateToCalendar(meta.dateExpired));
        repoAsset.updateCategoryList(meta.categories);
        ContentHandler handler = ContentManager.getHandler((String)repoAsset.getFormat());
        handler.storeAssetContent(asset, repoAsset);
        if (!asset.metaData.format.equals("scenario") || asset.metaData.format.equals("enumeration")) {
            PackageItem pkg = repoAsset.getPackage();
            pkg.updateBinaryUpToDate(false);
            ruleBaseCache.remove(pkg.getUUID());
        }
        repoAsset.checkin(meta.checkinComment);
        return repoAsset.getUUID();
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public TableDataResult loadAssetHistory(String uuid) throws SerializableException {
        ArrayList<TableDataRow> result = new ArrayList<TableDataRow>();
        AssetItem item = this.repository.loadAssetByUUID(uuid);
        if (Contexts.isSessionContextActive()) {
            Identity.instance().checkPermission((Object)new PackageUUIDType(item.getPackage().getUUID()), "package.readonly");
        }
        AssetHistoryIterator it = item.getHistory();
        while (it.hasNext()) {
            AssetItem historical = it.next();
            long versionNumber = historical.getVersionNumber();
            if (versionNumber == 0L || versionNumber == item.getVersionNumber()) continue;
            TableDataRow row = new TableDataRow();
            row.id = historical.getVersionSnapshotUUID();
            row.values = new String[4];
            row.values[0] = Long.toString(historical.getVersionNumber());
            row.values[1] = historical.getCheckinComment();
            row.values[2] = dateFormatter.format(historical.getLastModified().getTime());
            row.values[3] = historical.getStateDescription();
            result.add(row);
        }
        if (result.size() == 0) {
            return null;
        }
        TableDataResult table = new TableDataResult();
        table.data = result.toArray(new TableDataRow[result.size()]);
        return table;
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public TableDataResult loadArchivedAssets(int skip, int numRows) throws SerializableException {
        ArrayList<TableDataRow> result = new ArrayList<TableDataRow>();
        AssetItemFilter filter = new AssetItemFilter();
        AssetItemIterator it = this.repository.findArchivedAssets();
        it.skip(skip);
        int count = 0;
        while (it.hasNext()) {
            AssetItem archived = it.next();
            if (filter.accept((Object)archived, "read")) {
                TableDataRow row = new TableDataRow();
                row.id = archived.getUUID();
                row.values = new String[5];
                row.values[0] = archived.getFormat();
                row.values[1] = archived.getPackageName();
                row.values[2] = archived.getName();
                row.values[3] = archived.getLastContributor();
                row.values[4] = Long.toString(archived.getLastModified().getTime().getTime());
                result.add(row);
                ++count;
            }
            if (count != numRows) continue;
            break;
        }
        TableDataResult table = new TableDataResult();
        table.data = result.toArray(new TableDataRow[result.size()]);
        table.currentPosition = it.getPosition();
        return table;
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public void restoreVersion(String versionUUID, String assetUUID, String comment) {
        AssetItem old = this.repository.loadAssetByUUID(versionUUID);
        AssetItem head = this.repository.loadAssetByUUID(assetUUID);
        log.info((Object)("USER:" + this.repository.getSession().getUserID() + " RESTORE of asset: [" + head.getName() + "] UUID: [" + head.getUUID() + "] with historical version number: [" + old.getVersionNumber()));
        this.repository.restoreHistoricalAsset(old, head, comment);
    }

    @WebRemote
    public String createPackage(String name, String description) throws SerializableException {
        if (Contexts.isSessionContextActive()) {
            Identity.instance().checkPermission((Object)new AdminType(), "admin");
        }
        log.info((Object)("USER:" + this.repository.getSession().getUserID() + " CREATING package [" + name + "]"));
        PackageItem item = this.repository.createPackage(name, description);
        return item.getUUID();
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public PackageConfigData loadPackageConfig(String uuid) {
        PackageItem item = this.repository.loadPackageByUUID(uuid);
        if (Contexts.isSessionContextActive()) {
            Identity.instance().checkPermission((Object)new PackageNameType(item.getName()), "package.readonly");
        }
        PackageConfigData data = new PackageConfigData();
        data.uuid = item.getUUID();
        data.header = ServiceImplementation.getDroolsHeader((PackageItem)item);
        data.externalURI = item.getExternalURI();
        data.catRules = item.getCategoryRules();
        data.description = item.getDescription();
        data.name = item.getName();
        data.lastModified = item.getLastModified().getTime();
        data.dateCreated = item.getCreatedDate().getTime();
        data.checkinComment = item.getCheckinComment();
        data.lasContributor = item.getLastContributor();
        data.state = item.getStateDescription();
        data.isSnapshot = item.isSnapshot();
        if (data.isSnapshot) {
            data.snapshotName = item.getSnapshotName();
        }
        return data;
    }

    private static String[] convertToObjectGraph(Map map, boolean getKeys) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (Map.Entry entry : map.entrySet()) {
            if (getKeys) {
                list.add(entry.getKey());
                continue;
            }
            list.add(entry.getValue());
        }
        return list.toArray(new String[0]);
    }

    private static String convertMapToString(Map map, boolean getKeys) {
        String[] sArray = ServiceImplementation.convertToObjectGraph((Map)map, (boolean)getKeys);
        String returnVal = new String();
        for (String string : sArray) {
            if (returnVal.length() > 0) {
                returnVal = returnVal + ",";
            }
            returnVal = returnVal + string;
        }
        return returnVal;
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public ValidatedResponse savePackage(PackageConfigData data) throws SerializableException {
        if (Contexts.isSessionContextActive()) {
            Identity.instance().checkPermission((Object)new PackageUUIDType(data.uuid), "package.developer");
        }
        log.info((Object)("USER:" + this.repository.getSession().getUserID() + " SAVING package [" + data.name + "]"));
        PackageItem item = this.repository.loadPackage(data.name);
        ServiceImplementation.updateDroolsHeader((String)data.header, (PackageItem)item);
        item.updateCategoryRules(ServiceImplementation.convertMapToString((Map)data.catRules, (boolean)true), ServiceImplementation.convertMapToString((Map)data.catRules, (boolean)false));
        item.updateExternalURI(data.externalURI);
        item.updateDescription(data.description);
        item.archiveItem(data.archived);
        item.updateBinaryUpToDate(false);
        ruleBaseCache.remove(data.uuid);
        item.checkin(data.description);
        BRMSSuggestionCompletionLoader loader = new BRMSSuggestionCompletionLoader();
        loader.getSuggestionEngine(item);
        ValidatedResponse res = new ValidatedResponse();
        if (loader.hasErrors()) {
            res.hasErrors = true;
            String err = "";
            Iterator iter = loader.getErrors().iterator();
            while (iter.hasNext()) {
                err = err + (String)iter.next();
                if (!iter.hasNext()) continue;
                err = err + "\n";
            }
            res.errorHeader = "Package validation errors";
            res.errorMessage = err;
        }
        return res;
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public TableDataResult listAssets(String uuid, String[] formats, int skip, int numRows, String tableConfig) throws SerializableException {
        log.debug((Object)("Loading asset list for [" + uuid + "]"));
        if (numRows == 0) {
            throw new DetailedSerializableException("Unable to return zero results (bug)", "probably have the parameters around the wrong way, sigh...");
        }
        long start = System.currentTimeMillis();
        PackageItem pkg = this.repository.loadPackageByUUID(uuid);
        AssetItemIterator it = formats.length > 0 ? pkg.listAssetsByFormat(formats) : pkg.listAssetsNotOfFormat(AssetFormatHelper.listRegisteredTypes());
        TableDisplayHandler handler = new TableDisplayHandler(tableConfig);
        log.debug((Object)("time for asset list load: " + (System.currentTimeMillis() - start)));
        return handler.loadRuleListTable(it, skip, numRows);
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public TableDataResult queryFullText(String text, boolean seekArchived, int skip, int numRows) throws SerializableException {
        if (numRows == 0) {
            throw new DetailedSerializableException("Unable to return zero results (bug)", "probably have the parameters around the wrong way, sigh...");
        }
        AssetItemIterator it = this.repository.queryFullText(text, seekArchived);
        ArrayList<AssetItem> resultList = new ArrayList<AssetItem>();
        PackageFilter filter = new PackageFilter();
        while (it.hasNext()) {
            AssetItem ai = it.next();
            if (!this.checkPackagePermissionHelper((RepositoryFilter)filter, ai, "package.readonly")) continue;
            resultList.add(ai);
        }
        TableDisplayHandler handler = new TableDisplayHandler("searchresults");
        return handler.loadRuleListTable(resultList, skip, numRows);
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public TableDataResult queryMetaData(MetaDataQuery[] qr, Date createdAfter, Date createdBefore, Date modifiedAfter, Date modifiedBefore, boolean seekArchived, int skip, int numRows) throws SerializableException {
        if (numRows == 0) {
            throw new DetailedSerializableException("Unable to return zero results (bug)", "probably have the parameters around the wrong way, sigh...");
        }
        2 q = new /* Unavailable Anonymous Inner Class!! */;
        RulesRepository.DateQuery[] dates = new RulesRepository.DateQuery[]{new RulesRepository.DateQuery("jcr:created", this.isoDate(createdAfter), this.isoDate(createdBefore)), new RulesRepository.DateQuery("drools:lastModified", this.isoDate(modifiedAfter), this.isoDate(modifiedBefore))};
        AssetItemIterator it = this.repository.query((Map)q, seekArchived, dates);
        ArrayList<AssetItem> resultList = new ArrayList<AssetItem>();
        PackageFilter packageFilter = new PackageFilter();
        CategoryFilter categoryFilter = new CategoryFilter();
        while (it.hasNext()) {
            AssetItem ai = it.next();
            if (!this.checkPackagePermissionHelper((RepositoryFilter)packageFilter, ai, "package.readonly") && !this.checkCategoryPermissionHelper((RepositoryFilter)categoryFilter, ai, "analyst.readonly")) continue;
            resultList.add(ai);
        }
        TableDisplayHandler handler = new TableDisplayHandler("searchresults");
        return handler.loadRuleListTable(resultList, skip, numRows);
    }

    private boolean checkPackagePermissionHelper(RepositoryFilter filter, AssetItem item, String roleType) {
        return filter.accept((Object)this.getConfigDataHelper(item.getPackage().getUUID()), roleType);
    }

    private boolean checkCategoryPermissionHelper(RepositoryFilter filter, AssetItem item, String roleType) {
        List tempCateList = item.getCategories();
        for (CategoryItem categoryItem : tempCateList) {
            if (!filter.accept((Object)categoryItem.getName(), roleType)) continue;
            return true;
        }
        return false;
    }

    private PackageConfigData getConfigDataHelper(String uuidStr) {
        PackageConfigData data = new PackageConfigData();
        data.uuid = uuidStr;
        return data;
    }

    private String isoDate(Date d) {
        if (d != null) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(d);
            return ISO8601.format((Calendar)cal);
        }
        return null;
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public String createState(String name) throws SerializableException {
        log.info((Object)("USER:" + this.repository.getSession().getUserID() + " CREATING state: [" + name + "]"));
        try {
            name = this.cleanHTML(name);
            String uuid = this.repository.createState(name).getNode().getUUID();
            this.repository.save();
            return uuid;
        }
        catch (RepositoryException e) {
            throw new SerializableException("Unable to create the status.");
        }
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public void removeState(String name) throws SerializableException {
        log.info((Object)("USER:" + this.repository.getSession().getUserID() + " REMOVING state: [" + name + "]"));
        try {
            this.repository.loadState(name).remove();
            this.repository.save();
        }
        catch (RulesRepositoryException e) {
            throw new DetailedSerializableException("Unable to remove status. It is probably still used (even by archived items).", e.getMessage());
        }
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public void renameState(String oldName, String newName) throws SerializableException {
        log.info((Object)("USER:" + this.repository.getSession().getUserID() + " RENAMING state: [" + oldName + "] to [" + newName + "]"));
        this.repository.renameState(oldName, newName);
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public String[] listStates() throws SerializableException {
        StateItem[] states = this.repository.listStates();
        String[] result = new String[states.length];
        for (int i = 0; i < states.length; ++i) {
            result[i] = states[i].getName();
        }
        return result;
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public void changeState(String uuid, String newState, boolean wholePackage) {
        if (!wholePackage) {
            AssetItem asset = this.repository.loadAssetByUUID(uuid);
            log.info((Object)("USER:" + this.repository.getSession().getUserID() + " CHANGING ASSET STATUS. Asset name, uuid: " + "[" + asset.getName() + ", " + asset.getUUID() + "]" + " to [" + newState + "]"));
            if (Contexts.isSessionContextActive()) {
                Identity.instance().checkPermission((Object)new PackageUUIDType(asset.getPackage().getUUID()), "package.developer");
                try {
                    RuleAsset ruleAsset = this.loadAsset(asset);
                    if (ruleAsset.metaData.categories.length == 0) {
                        Identity.instance().checkPermission((Object)new CategoryPathType(null), "analyst.readonly");
                    } else {
                        boolean passed = false;
                        RuntimeException exception = null;
                        for (String cat : ruleAsset.metaData.categories) {
                            try {
                                Identity.instance().checkPermission((Object)new CategoryPathType(cat), "analyst");
                                passed = true;
                            }
                            catch (RuntimeException e) {
                                exception = e;
                            }
                        }
                        if (!passed) {
                            throw exception;
                        }
                    }
                }
                catch (RulesRepositoryException e) {
                }
                catch (SerializableException e) {
                    // empty catch block
                }
                asset.updateState(newState);
            }
        } else {
            if (Contexts.isSessionContextActive()) {
                Identity.instance().checkPermission((Object)new PackageUUIDType(uuid), "package.developer");
            }
            PackageItem pkg = this.repository.loadPackageByUUID(uuid);
            log.info((Object)("USER:" + this.repository.getSession().getUserID() + " CHANGING Package STATUS. Asset name, uuid: " + "[" + pkg.getName() + ", " + pkg.getUUID() + "]" + " to [" + newState + "]"));
            pkg.changeStatus(newState);
        }
        this.repository.save();
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public void changeAssetPackage(String uuid, String newPackage, String comment) {
        if (Contexts.isSessionContextActive()) {
            Identity.instance().checkPermission((Object)new PackageNameType(newPackage), "package.developer");
        }
        log.info((Object)("USER:" + this.repository.getSession().getUserID() + " CHANGING PACKAGE OF asset: [" + uuid + "] to [" + newPackage + "]"));
        this.repository.moveRuleItemPackage(newPackage, uuid, comment);
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public String copyAsset(String assetUUID, String newPackage, String newName) {
        if (Contexts.isSessionContextActive()) {
            Identity.instance().checkPermission((Object)new PackageNameType(newPackage), "package.developer");
        }
        return this.repository.copyAsset(assetUUID, newPackage, newName);
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public SnapshotInfo[] listSnapshots(String packageName) {
        if (Contexts.isSessionContextActive()) {
            Identity.instance().checkPermission((Object)new PackageNameType(packageName), "package.developer");
        }
        String[] snaps = this.repository.listPackageSnapshots(packageName);
        SnapshotInfo[] res = new SnapshotInfo[snaps.length];
        for (int i = 0; i < snaps.length; ++i) {
            SnapshotInfo info;
            PackageItem snap = this.repository.loadPackageSnapshot(packageName, snaps[i]);
            res[i] = info = new SnapshotInfo();
            info.comment = snap.getCheckinComment();
            info.name = snaps[i];
            info.uuid = snap.getUUID();
        }
        return res;
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public void createPackageSnapshot(String packageName, String snapshotName, boolean replaceExisting, String comment) {
        if (Contexts.isSessionContextActive()) {
            Identity.instance().checkPermission((Object)new PackageNameType(packageName), "package.admin");
        }
        log.info((Object)("USER:" + this.repository.getSession().getUserID() + " CREATING PACKAGE SNAPSHOT for package: [" + packageName + "] snapshot name: [" + snapshotName));
        if (replaceExisting) {
            this.repository.removePackageSnapshot(packageName, snapshotName);
        }
        this.repository.createPackageSnapshot(packageName, snapshotName);
        PackageItem item = this.repository.loadPackageSnapshot(packageName, snapshotName);
        item.updateCheckinComment(comment);
        this.repository.save();
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public void copyOrRemoveSnapshot(String packageName, String snapshotName, boolean delete, String newSnapshotName) throws SerializableException {
        if (Contexts.isSessionContextActive()) {
            Identity.instance().checkPermission((Object)new PackageNameType(packageName), "package.admin");
        }
        if (delete) {
            log.info((Object)("USER:" + this.repository.getSession().getUserID() + " REMOVING SNAPSHOT for package: [" + packageName + "] snapshot: [" + snapshotName + "]"));
            this.repository.removePackageSnapshot(packageName, snapshotName);
        } else {
            if (newSnapshotName.equals("")) {
                throw new SerializableException("Need to have a new snapshot name.");
            }
            log.info((Object)("USER:" + this.repository.getSession().getUserID() + " COPYING SNAPSHOT for package: [" + packageName + "] snapshot: [" + snapshotName + "] to [" + newSnapshotName + "]"));
            this.repository.copyPackageSnapshot(packageName, snapshotName, newSnapshotName);
        }
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public TableDataResult quickFindAsset(String searchText, int max, boolean searchArchived) {
        String search = searchText.replace('*', '%');
        if (!search.endsWith("%")) {
            search = search + "%";
        }
        TableDataResult result = new TableDataResult();
        ArrayList<TableDataRow> resultList = new ArrayList<TableDataRow>();
        long start = System.currentTimeMillis();
        AssetItemIterator it = this.repository.findAssetsByName(search, searchArchived);
        log.debug((Object)("Search time: " + (System.currentTimeMillis() - start)));
        AssetItemFilter filter = new AssetItemFilter();
        for (int i = 0; i < max && it.hasNext(); ++i) {
            AssetItem item = it.next();
            try {
                System.err.println("jcr:path=" + item.getNode().getPath());
            }
            catch (RepositoryException e) {
                e.printStackTrace();
            }
            if (!filter.accept((Object)item, "package.readonly")) continue;
            TableDataRow row = new TableDataRow();
            row.id = item.getUUID();
            String desc = item.getDescription() + "";
            row.values = new String[]{item.getName(), desc.substring(0, Math.min(32, desc.length()))};
            resultList.add(row);
        }
        while (it.hasNext()) {
            if (!filter.accept((Object)it.next(), "package.readonly")) continue;
            TableDataRow empty = new TableDataRow();
            empty.id = "MORE";
            resultList.add(empty);
            break;
        }
        result.data = resultList.toArray(new TableDataRow[resultList.size()]);
        return result;
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public void removeCategory(String categoryPath) throws SerializableException {
        log.info((Object)("USER:" + this.repository.getSession().getUserID() + " REMOVING CATEGORY path: [" + categoryPath + "]"));
        try {
            this.repository.loadCategory(categoryPath).remove();
            this.repository.save();
        }
        catch (RulesRepositoryException e) {
            throw new DetailedSerializableException("Unable to remove category. It is probably still used (even by archived items).", e.getMessage());
        }
    }

    @WebRemote
    public void clearRulesRepository() {
        if (Contexts.isSessionContextActive()) {
            Identity.instance().checkPermission((Object)new AdminType(), "admin");
        }
        RulesRepositoryAdministrator admin = new RulesRepositoryAdministrator(this.repository.getSession());
        admin.clearRulesRepository();
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public SuggestionCompletionEngine loadSuggestionCompletionEngine(String packageName) throws SerializableException {
        if (Contexts.isSessionContextActive()) {
            Identity.instance().checkPermission((Object)new PackageNameType(packageName), "package.readonly");
        }
        try {
            PackageItem pkg = this.repository.loadPackage(packageName);
            BRMSSuggestionCompletionLoader loader = new BRMSSuggestionCompletionLoader();
            return loader.getSuggestionEngine(pkg);
        }
        catch (RulesRepositoryException e) {
            log.error((Object)e);
            throw new SerializableException(e.getMessage());
        }
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public BuilderResult[] buildPackage(String packageUUID, String selectorConfigName, boolean force) throws SerializableException {
        if (Contexts.isSessionContextActive()) {
            Identity.instance().checkPermission((Object)new PackageUUIDType(packageUUID), "package.developer");
        }
        PackageItem item = this.repository.loadPackageByUUID(packageUUID);
        try {
            return this.buildPackage(selectorConfigName, force, item);
        }
        catch (NoClassDefFoundError e) {
            throw new DetailedSerializableException("Unable to find a class that was needed when building the package  [" + e.getMessage() + "]", "Perhaps you are missing them from the model jars, or from the BRMS itself (lib directory).");
        }
    }

    private BuilderResult[] buildPackage(String selectorConfigName, boolean force, PackageItem item) throws DetailedSerializableException {
        if (!force && item.isBinaryUpToDate()) {
            return null;
        }
        ContentPackageAssembler asm = new ContentPackageAssembler(item, selectorConfigName);
        if (asm.hasErrors()) {
            BuilderResult[] result = this.generateBuilderResults(asm);
            return result;
        }
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            DroolsObjectOutputStream out = new DroolsObjectOutputStream((OutputStream)bout);
            out.writeObject(asm.getBinaryPackage());
            item.updateCompiledPackage((InputStream)new ByteArrayInputStream(bout.toByteArray()));
            out.flush();
            out.close();
            this.updateBinaryPackage(item, asm);
            this.repository.save();
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)e);
            throw new DetailedSerializableException("An error occurred building the package.", e.getMessage());
        }
        return null;
    }

    private void updateBinaryPackage(PackageItem item, ContentPackageAssembler asm) throws Exception {
        item.updateBinaryUpToDate(true);
        RuleBaseConfiguration conf = new RuleBaseConfiguration();
        conf.setClassLoader(asm.getBuilder().getRootClassLoader().getParent());
        RuleBase rb = RuleBaseFactory.newRuleBase((RuleBaseConfiguration)conf);
        rb.addPackage(asm.getBinaryPackage());
    }

    private BuilderResult[] generateBuilderResults(ContentPackageAssembler asm) {
        BuilderResult[] result = new BuilderResult[asm.getErrors().size()];
        for (int i = 0; i < result.length; ++i) {
            ContentAssemblyError err = (ContentAssemblyError)asm.getErrors().get(i);
            BuilderResult res = new BuilderResult();
            res.assetName = err.itemInError.getName();
            res.assetFormat = err.itemInError.getFormat();
            res.message = err.errorReport;
            res.uuid = err.itemInError.getUUID();
            result[i] = res;
        }
        return result;
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public String buildPackageSource(String packageUUID) throws SerializableException {
        if (Contexts.isSessionContextActive()) {
            Identity.instance().checkPermission((Object)new PackageUUIDType(packageUUID), "package.developer");
        }
        PackageItem item = this.repository.loadPackageByUUID(packageUUID);
        ContentPackageAssembler asm = new ContentPackageAssembler(item, false);
        return asm.getDRL();
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public String buildAssetSource(RuleAsset asset) throws SerializableException {
        if (Contexts.isSessionContextActive()) {
            Identity.instance().checkPermission((Object)new PackageNameType(asset.metaData.packageName), "package.developer");
        }
        AssetItem item = this.repository.loadAssetByUUID(asset.uuid);
        ContentHandler handler = ContentManager.getHandler((String)item.getFormat());
        handler.storeAssetContent(asset, item);
        StringBuffer buf = new StringBuffer();
        if (!handler.isRuleAsset()) {
            return item.getContent();
        }
        BRMSPackageBuilder builder = new BRMSPackageBuilder();
        builder.setDSLFiles(BRMSPackageBuilder.getDSLMappingFiles((PackageItem)item.getPackage(), (BRMSPackageBuilder.DSLErrorEvent)new /* Unavailable Anonymous Inner Class!! */));
        ((IRuleAsset)handler).assembleDRL(builder, item, buf);
        return buf.toString();
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public BuilderResult[] buildAsset(RuleAsset asset) throws SerializableException {
        if (Contexts.isSessionContextActive()) {
            Identity.instance().checkPermission((Object)new PackageNameType(asset.metaData.packageName), "package.developer");
        }
        try {
            AssetItem item = this.repository.loadAssetByUUID(asset.uuid);
            ContentHandler handler = ContentManager.getHandler((String)item.getFormat());
            handler.storeAssetContent(asset, item);
            if (handler instanceof IValidating) {
                return ((IValidating)handler).validateAsset(item);
            }
            ContentPackageAssembler asm = new ContentPackageAssembler(item);
            if (!asm.hasErrors()) {
                return null;
            }
            return this.generateBuilderResults(asm);
        }
        catch (Exception e) {
            log.error((Object)e);
            BuilderResult[] result = new BuilderResult[1];
            BuilderResult res = new BuilderResult();
            res.assetName = asset.metaData.name;
            res.assetFormat = asset.metaData.format;
            res.message = "Unable to validate this asset. (Check log for detailed messages).";
            res.uuid = asset.uuid;
            result[0] = res;
            return result;
        }
    }

    @WebRemote
    public void copyPackage(String sourcePackageName, String destPackageName) throws SerializableException {
        if (Contexts.isSessionContextActive()) {
            Identity.instance().checkPermission((Object)new AdminType(), "admin");
        }
        try {
            this.repository.copyPackage(sourcePackageName, destPackageName);
        }
        catch (RulesRepositoryException e) {
            log.error((Object)e);
            throw e;
        }
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public String renameAsset(String uuid, String newName) {
        AssetItem item = this.repository.loadAssetByUUID(uuid);
        if (Contexts.isSessionContextActive()) {
            Identity.instance().checkPermission((Object)new PackageUUIDType(item.getPackage().getUUID()), "package.developer");
        }
        return this.repository.renameAsset(uuid, newName);
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public void archiveAsset(String uuid, boolean value) {
        try {
            AssetItem item = this.repository.loadAssetByUUID(uuid);
            if (Contexts.isSessionContextActive()) {
                Identity.instance().checkPermission((Object)new PackageUUIDType(item.getPackage().getUUID()), "package.developer");
            }
            if (item.getPackage().isArchived()) {
                throw new RulesRepositoryException("The package [" + item.getPackageName() + "] that asset [" + item.getName() + "] belongs to is archived. You need to unarchive it first.");
            }
            item.archiveItem(value);
            PackageItem pkg = item.getPackage();
            pkg.updateBinaryUpToDate(false);
            ruleBaseCache.remove(pkg.getUUID());
            item.checkin("unarchived");
        }
        catch (RulesRepositoryException e) {
            log.error((Object)e);
            throw e;
        }
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public void removeAsset(String uuid) {
        try {
            AssetItem item = this.repository.loadAssetByUUID(uuid);
            if (Contexts.isSessionContextActive()) {
                Identity.instance().checkPermission((Object)new PackageUUIDType(item.getPackage().getUUID()), "package.developer");
            }
            item.remove();
            this.repository.save();
        }
        catch (RulesRepositoryException e) {
            log.error((Object)e);
            throw e;
        }
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public void removePackage(String uuid) {
        if (Contexts.isSessionContextActive()) {
            Identity.instance().checkPermission((Object)new PackageUUIDType(uuid), "package.admin");
        }
        try {
            PackageItem item = this.repository.loadPackageByUUID(uuid);
            item.remove();
            this.repository.save();
        }
        catch (RulesRepositoryException e) {
            log.error((Object)e);
            throw e;
        }
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public String renamePackage(String uuid, String newName) {
        if (Contexts.isSessionContextActive()) {
            Identity.instance().checkPermission((Object)new PackageUUIDType(uuid), "package.admin");
        }
        return this.repository.renamePackage(uuid, newName);
    }

    @WebRemote
    public void rebuildSnapshots() throws SerializableException {
        if (Contexts.isSessionContextActive()) {
            Identity.instance().checkPermission((Object)new AdminType(), "admin");
        }
        PackageIterator pkit = this.repository.listPackages();
        while (pkit.hasNext()) {
            String[] snaps;
            PackageItem pkg = (PackageItem)pkit.next();
            for (String snapName : snaps = this.repository.listPackageSnapshots(pkg.getName())) {
                PackageItem snap = this.repository.loadPackageSnapshot(pkg.getName(), snapName);
                BuilderResult[] res = this.buildPackage(snap.getUUID(), "", true);
                if (res == null) continue;
                StringBuffer buf = new StringBuffer();
                for (int i = 0; i < res.length; ++i) {
                    buf.append(res[i].toString());
                    buf.append('\n');
                }
                throw new DetailedSerializableException("Unable to rebuild snapshot [" + snapName, buf.toString() + "]");
            }
        }
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public String[] listRulesInPackage(String packageName) throws SerializableException {
        if (Contexts.isSessionContextActive()) {
            Identity.instance().checkPermission((Object)new PackageNameType(packageName), "package.readonly");
        }
        PackageItem item = this.repository.loadPackage(packageName);
        ContentPackageAssembler asm = new ContentPackageAssembler(item, false);
        ArrayList<String> result = new ArrayList<String>();
        DrlParser p = new DrlParser();
        try {
            PackageDescr pkg = p.parse(asm.getDRL());
            int count = 0;
            if (pkg != null) {
                for (RuleDescr r : pkg.getRules()) {
                    result.add(r.getName());
                    if (++count != 5000) continue;
                    result.add("More then 5000 rules.");
                    break;
                }
            }
            return result.toArray(new String[result.size()]);
        }
        catch (DroolsParserException e) {
            log.error((Object)e);
            return new String[0];
        }
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public SingleScenarioResult runScenario(String packageName, Scenario scenario) throws SerializableException {
        if (Contexts.isSessionContextActive()) {
            Identity.instance().checkPermission((Object)new PackageNameType(packageName), "package.developer");
        }
        return this.runScenario(packageName, scenario, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private SingleScenarioResult runScenario(String packageName, Scenario scenario, RuleCoverageListener coverage) throws SerializableException {
        item = this.repository.loadPackage(packageName);
        originalCL = Thread.currentThread().getContextClassLoader();
        try {
            if (!item.isBinaryUpToDate()) ** GOTO lbl-1000
            if (ServiceImplementation.ruleBaseCache.containsKey(item.getUUID())) {
                rb = (RuleBase)ServiceImplementation.ruleBaseCache.get(item.getUUID());
            } else lbl-1000:
            // 2 sources

            {
                jars = BRMSPackageBuilder.getJars((PackageItem)item);
                buildCl = BRMSPackageBuilder.createClassLoader((List)jars);
                if (item.isBinaryUpToDate()) {
                    rb = this.loadRuleBase(item, (ClassLoader)buildCl);
                    ServiceImplementation.ruleBaseCache.put(item.getUUID(), rb);
                } else {
                    errs = this.buildPackage(null, false, item);
                    if (errs == null || errs.length == 0) {
                        rb = this.loadRuleBase(item, (ClassLoader)buildCl);
                        ServiceImplementation.ruleBaseCache.put(item.getUUID(), rb);
                    } else {
                        r = new SingleScenarioResult();
                        r.result = new ScenarioRunResult(errs, null);
                        var11_11 = r;
                        return var11_11;
                    }
                }
            }
            cl = ((InternalRuleBase)ServiceImplementation.ruleBaseCache.get(item.getUUID())).getRootClassLoader();
            Thread.currentThread().setContextClassLoader((ClassLoader)cl);
            var8_8 = this.runScenario(scenario, item, (ClassLoader)cl, rb, coverage);
            return var8_8;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalCL);
        }
    }

    private RuleBase loadRuleBase(PackageItem item, ClassLoader cl) throws DetailedSerializableException {
        try {
            return this.deserKnowledgebase(item, cl);
        }
        catch (ClassNotFoundException e) {
            log.error((Object)e);
            throw new DetailedSerializableException("A required class was not found.", e.getMessage());
        }
        catch (Exception e) {
            log.error((Object)e);
            log.info((Object)"...but trying to rebuild binaries...");
            try {
                BuilderResult[] res = this.buildPackage("", true, item);
                if (res != null && res.length > 0) {
                    throw new DetailedSerializableException("There were errors when rebuilding the knowledgebase.", "");
                }
                try {
                    return this.deserKnowledgebase(item, cl);
                }
                catch (Exception e2) {
                    throw new DetailedSerializableException("Unable to reload knowledgebase.", e.getMessage());
                }
            }
            catch (SerializableException e1) {
                throw new DetailedSerializableException("Unable to rebuild the rulebase.", "");
            }
        }
    }

    private RuleBase deserKnowledgebase(PackageItem item, ClassLoader cl) throws IOException, ClassNotFoundException {
        RuleBase rb = RuleBaseFactory.newRuleBase((RuleBaseConfiguration)new RuleBaseConfiguration(cl));
        Package bin = (Package)DroolsStreamUtils.streamIn((byte[])item.getCompiledPackageBytes(), (ClassLoader)cl);
        rb.addPackage(bin);
        return rb;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SingleScenarioResult runScenario(Scenario scenario, PackageItem item, ClassLoader cl, RuleBase rb, RuleCoverageListener coverage) throws DetailedSerializableException {
        Package bin = rb.getPackages()[0];
        Set imps = bin.getImports().keySet();
        HashSet allImps = new HashSet(imps);
        if (bin.getGlobals() != null) {
            Iterator iterator = bin.getGlobals().keySet().iterator();
            while (iterator.hasNext()) {
                allImps.add(bin.getGlobals().get(iterator.next()));
            }
        }
        allImps.add(bin.getName() + ".*");
        ClassTypeResolver res = new ClassTypeResolver(allImps, cl);
        SessionConfiguration sessionConfiguration = new SessionConfiguration();
        sessionConfiguration.setKeepReference(false);
        InternalWorkingMemory workingMemory = (InternalWorkingMemory)rb.newStatefulSession(sessionConfiguration);
        if (coverage != null) {
            workingMemory.addEventListener((AgendaEventListener)coverage);
        }
        try {
            AuditLogReporter logger = new AuditLogReporter((WorkingMemory)workingMemory);
            new ScenarioRunner(scenario, (TypeResolver)res, workingMemory);
            SingleScenarioResult r = new SingleScenarioResult();
            r.auditLog = logger.buildReport();
            r.result = new ScenarioRunResult(null, scenario);
            return r;
        }
        catch (ClassNotFoundException e) {
            log.error((Object)e);
            throw new DetailedSerializableException("Unable to load a required class.", e.getMessage());
        }
        catch (ConsequenceException e) {
            log.info((Object)e);
            throw new DetailedSerializableException("There was an error executing the consequence of rule [" + e.getRule().getName() + "]", e.getMessage());
        }
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public BulkTestRunResult runScenariosInPackage(String packageUUID) throws SerializableException {
        if (Contexts.isSessionContextActive()) {
            Identity.instance().checkPermission((Object)new PackageUUIDType(packageUUID), "package.developer");
        }
        PackageItem item = this.repository.loadPackageByUUID(packageUUID);
        return this.runScenariosInPackage(item);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public BulkTestRunResult runScenariosInPackage(PackageItem item) throws DetailedSerializableException, SerializableException {
        originalCL = Thread.currentThread().getContextClassLoader();
        cl /* !! */  = null;
        try {
            if (!item.isBinaryUpToDate()) ** GOTO lbl-1000
            if (ServiceImplementation.ruleBaseCache.containsKey(item.getUUID())) {
                rb = (RuleBase)ServiceImplementation.ruleBaseCache.get(item.getUUID());
                arb = (AbstractRuleBase)rb;
                cl /* !! */  = arb.getConfiguration().getClassLoader();
                Thread.currentThread().setContextClassLoader((ClassLoader)cl /* !! */ );
            } else lbl-1000:
            // 2 sources

            {
                jars = BRMSPackageBuilder.getJars((PackageItem)item);
                cl /* !! */  = BRMSPackageBuilder.createClassLoader((List)jars);
                Thread.currentThread().setContextClassLoader((ClassLoader)cl /* !! */ );
                if (item.isBinaryUpToDate()) {
                    ServiceImplementation.ruleBaseCache.put(item.getUUID(), this.loadRuleBase(item, (ClassLoader)cl /* !! */ ));
                } else {
                    errs = this.buildPackage(null, false, item);
                    if (errs == null || errs.length == 0) {
                        ServiceImplementation.ruleBaseCache.put(item.getUUID(), this.loadRuleBase(item, (ClassLoader)cl /* !! */ ));
                    } else {
                        var6_6 = new BulkTestRunResult(errs, null, 0, null);
                        return var6_6;
                    }
                }
            }
            it = item.listAssetsByFormat(new String[]{"scenario"});
            resultSummaries = new ArrayList<ScenarioResultSummary>();
            rb = (RuleBase)ServiceImplementation.ruleBaseCache.get(item.getUUID());
            bin = rb.getPackages()[0];
            coverage = new RuleCoverageListener(this.expectedRules(bin));
            while (it.hasNext()) {
                asset = this.loadAsset(it.next());
                sc = (Scenario)asset.content;
                this.runScenario(item.getName(), sc, coverage);
                totals = sc.countFailuresTotal();
                resultSummaries.add(new ScenarioResultSummary(totals[0], totals[1], asset.metaData.name, asset.metaData.description, asset.uuid));
            }
            summaries = resultSummaries.toArray(new ScenarioResultSummary[resultSummaries.size()]);
            var11_12 = result = new BulkTestRunResult(null, resultSummaries.toArray(summaries), coverage.getPercentCovered(), coverage.getUnfiredRules());
            return var11_12;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalCL);
        }
    }

    private HashSet<String> expectedRules(Package bin) {
        HashSet<String> h = new HashSet<String>();
        for (int i = 0; i < bin.getRules().length; ++i) {
            h.add(bin.getRules()[i].getName());
        }
        return h;
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public AnalysisReport analysePackage(String packageUUID) throws SerializableException {
        if (Contexts.isSessionContextActive()) {
            Identity.instance().checkPermission((Object)new PackageUUIDType(packageUUID), "package.developer");
        }
        String drl = this.buildPackageSource(packageUUID);
        VerifierRunner runner = new VerifierRunner();
        try {
            return runner.analyse(drl);
        }
        catch (DroolsParserException e) {
            log.error((Object)e);
            throw new DetailedSerializableException("Unable to parse the rules.", e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public String[] listTypesInPackage(String packageUUID) throws SerializableException {
        if (Contexts.isSessionContextActive()) {
            Identity.instance().checkPermission((Object)new PackageUUIDType(packageUUID), "package.readoly");
        }
        PackageItem pkg = this.repository.loadPackageByUUID(packageUUID);
        ArrayList<String> res = new ArrayList<String>();
        AssetItemIterator it = pkg.listAssetsByFormat(new String[]{"jar", "model.drl"});
        JarInputStream jis = null;
        try {
            String[] asset;
            while (it.hasNext()) {
                asset = it.next();
                if (asset.isArchived()) continue;
                if (asset.getFormat().equals("jar")) {
                    jis = new JarInputStream(asset.getBinaryContentAttachment());
                    JarEntry entry = null;
                    while ((entry = jis.getNextJarEntry()) != null) {
                        if (entry.isDirectory() || !entry.getName().endsWith(".class")) continue;
                        res.add(ModelContentHandler.convertPathToName((String)entry.getName()));
                    }
                    continue;
                }
                DrlParser parser = new DrlParser();
                try {
                    PackageDescr desc = parser.parse(asset.getContent());
                    List types = desc.getTypeDeclarations();
                    for (TypeDeclarationDescr typeDeclarationDescr : types) {
                        res.add(typeDeclarationDescr.getTypeName());
                    }
                }
                catch (DroolsParserException e) {
                    log.error((Object)e);
                }
            }
            asset = res.toArray(new String[res.size()]);
            return asset;
        }
        catch (IOException e) {
            log.error((Object)e);
            throw new DetailedSerializableException("Unable to read the jar files in the package.", e.getMessage());
        }
        finally {
            IOUtils.closeQuietly(jis);
        }
    }

    @WebRemote
    public LogEntry[] showLog() {
        if (Contexts.isSessionContextActive()) {
            Identity.instance().checkPermission((Object)new AdminType(), "admin");
        }
        return LoggingHelper.getMessages();
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public void renameCategory(String fullPathAndName, String newName) {
        this.repository.renameCategory(fullPathAndName, newName);
    }

    public static String getDroolsHeader(PackageItem pkg) {
        if (pkg.containsAsset("drools")) {
            return pkg.loadAsset("drools").getContent();
        }
        return "";
    }

    public static void updateDroolsHeader(String string, PackageItem pkg) {
        pkg.checkout();
        if (pkg.containsAsset("drools")) {
            AssetItem conf = pkg.loadAsset("drools");
            conf.updateContent(string);
            conf.checkin("");
        } else {
            AssetItem conf = pkg.addAsset("drools", "");
            conf.updateFormat("package");
            conf.updateContent(string);
            conf.checkin("");
        }
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public String[] loadDropDownExpression(String[] valuePairs, String expression) {
        HashMap<String, String> context = new HashMap<String, String>();
        for (int i = 0; i < valuePairs.length; ++i) {
            String[] pair = valuePairs[i].split("=");
            context.put(pair[0], pair[1]);
        }
        Object result = MVEL.eval((String)(expression = (String)TemplateRuntime.eval((String)expression, context)));
        if (result instanceof String[]) {
            return (String[])result;
        }
        if (result instanceof List) {
            List l = (List)result;
            String[] xs = new String[l.size()];
            for (int i = 0; i < xs.length; ++i) {
                Object el = l.get(i);
                xs[i] = el.toString();
            }
            return xs;
        }
        return null;
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public void rebuildPackages() throws SerializableException {
        PackageIterator pkit = this.repository.listPackages();
        StringBuffer errs = new StringBuffer();
        while (pkit.hasNext()) {
            PackageItem pkg = (PackageItem)pkit.next();
            try {
                BuilderResult[] res = this.buildPackage(pkg.getUUID(), "", true);
                if (res == null) continue;
                errs.append("Unable to build package name [" + pkg.getName() + "]\n");
                StringBuffer buf = new StringBuffer();
                for (int i = 0; i < res.length; ++i) {
                    buf.append(res[i].toString());
                    buf.append('\n');
                }
                log.warn((Object)buf.toString());
            }
            catch (Exception e) {
                log.error((Object)e);
                errs.append("An error occurred building package [" + pkg.getName() + "]\n");
            }
        }
        if (errs.toString().length() > 0) {
            throw new DetailedSerializableException("Unable to rebuild all packages.", errs.toString());
        }
    }

    @Restrict(value="#{identity.loggedIn}")
    public Map<String, List<String>> listUserPermissions() {
        if (Contexts.isSessionContextActive()) {
            Identity.instance().checkPermission((Object)new AdminType(), "admin");
        }
        PermissionManager pm = new PermissionManager(this.repository);
        return pm.listUsers();
    }

    @Restrict(value="#{identity.loggedIn}")
    public Map<String, List<String>> retrieveUserPermissions(String userName) {
        if (Contexts.isSessionContextActive()) {
            Identity.instance().checkPermission((Object)new AdminType(), "admin");
        }
        PermissionManager pm = new PermissionManager(this.repository);
        return pm.retrieveUserPermissions(userName);
    }

    @Restrict(value="#{identity.loggedIn}")
    public void updateUserPermissions(String userName, Map<String, List<String>> perms) {
        if (Contexts.isSessionContextActive()) {
            Identity.instance().checkPermission((Object)new AdminType(), "admin");
        }
        PermissionManager pm = new PermissionManager(this.repository);
        System.err.println(perms);
        log.info((Object)("Updating user permissions for userName [" + userName + "] to [" + perms + "]"));
        pm.updateUserPermissions(userName, perms);
        this.repository.save();
    }

    @Restrict(value="#{identity.loggedIn}")
    public String[] listAvailablePermissionTypes() {
        if (Contexts.isSessionContextActive()) {
            Identity.instance().checkPermission((Object)new AdminType(), "admin");
        }
        return RoleTypes.listAvailableTypes();
    }

    @Restrict(value="#{identity.loggedIn}")
    public void deleteUser(String userName) {
        log.info((Object)("Removing user permissions for user name [" + userName + "]"));
        PermissionManager pm = new PermissionManager(this.repository);
        pm.removeUserPermissions(userName);
        this.repository.save();
    }

    @Restrict(value="#{identity.loggedIn}")
    public String getAssetLockerUserName(String uuid) {
        AssetLockManager alm = AssetLockManager.instance();
        String userName = alm.getAssetLockerUserName(uuid);
        log.info((Object)("Asset locked by [" + userName + "]"));
        return userName;
    }

    @Restrict(value="#{identity.loggedIn}")
    public void lockAsset(String uuid) {
        AssetLockManager alm = AssetLockManager.instance();
        String userName = Contexts.isApplicationContextActive() ? Identity.instance().getUsername() : "anonymous";
        log.info((Object)("Locking asset uuid=" + uuid + " for user [" + userName + "]"));
        alm.lockAsset(uuid, userName);
    }

    @Restrict(value="#{identity.loggedIn}")
    public void unLockAsset(String uuid) {
        AssetLockManager alm = AssetLockManager.instance();
        log.info((Object)("Unlocking asset [" + uuid + "]"));
        alm.unLockAsset(uuid);
    }

    @Restrict(value="#{identity.loggedIn}")
    public void installSampleRepository() throws SerializableException {
        if (Contexts.isApplicationContextActive()) {
            Identity.instance().checkPermission((Object)new AdminType(), "admin");
        }
        this.repository.importRepository(this.getClass().getResourceAsStream("/mortgage-sample-repository.xml"));
        this.rebuildPackages();
        this.rebuildSnapshots();
    }

    public String cleanHTML(String s) {
        return s.replace("<", "&lt;").replace(">", "&gt;");
    }
}

