/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.builder;

import java.util.ArrayList;
import java.util.List;
import org.drools.definition.process.Connection;
import org.drools.definition.process.Node;
import org.drools.guvnor.client.rpc.RuleFlowContentModel;
import org.drools.guvnor.client.rulefloweditor.ElementContainerTransferNode;
import org.drools.guvnor.client.rulefloweditor.HumanTaskTransferNode;
import org.drools.guvnor.client.rulefloweditor.SplitNode;
import org.drools.guvnor.client.rulefloweditor.SplitTransferNode;
import org.drools.guvnor.client.rulefloweditor.TransferConnection;
import org.drools.guvnor.client.rulefloweditor.TransferNode;
import org.drools.guvnor.client.rulefloweditor.WorkItemTransferNode;
import org.drools.process.core.Work;
import org.drools.ruleflow.core.RuleFlowProcess;
import org.drools.workflow.core.Constraint;
import org.drools.workflow.core.node.ActionNode;
import org.drools.workflow.core.node.CompositeNode;
import org.drools.workflow.core.node.EndNode;
import org.drools.workflow.core.node.EventNode;
import org.drools.workflow.core.node.FaultNode;
import org.drools.workflow.core.node.ForEachNode;
import org.drools.workflow.core.node.HumanTaskNode;
import org.drools.workflow.core.node.Join;
import org.drools.workflow.core.node.MilestoneNode;
import org.drools.workflow.core.node.RuleSetNode;
import org.drools.workflow.core.node.Split;
import org.drools.workflow.core.node.StartNode;
import org.drools.workflow.core.node.SubProcessNode;
import org.drools.workflow.core.node.TimerNode;
import org.drools.workflow.core.node.WorkItemNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuleFlowContentModelBuilder {
    public RuleFlowContentModel createModel(RuleFlowProcess process) {
        RuleFlowContentModel model = new RuleFlowContentModel();
        List transferNodes = this.createNodesAndConnections(process.getNodes(), model);
        model.getNodes().addAll(transferNodes);
        return model;
    }

    private List<TransferNode> createNodesAndConnections(Node[] nodes, RuleFlowContentModel model) {
        ArrayList<TransferNode> transferNodes = new ArrayList<TransferNode>();
        for (int i = 0; i < nodes.length; ++i) {
            Integer width;
            Node node = nodes[i];
            TransferNode.Type type = this.getType(node);
            Object tn = null;
            tn = type == TransferNode.Type.WORK_ITEM ? this.createWorkItemTransfernode((WorkItemNode)node) : (type == TransferNode.Type.HUMANTASK ? this.createHumanTaskTransferNode((HumanTaskNode)node) : (type == TransferNode.Type.SPLIT ? this.createSplitNode((Split)node) : (type == TransferNode.Type.FOR_EACH ? this.createRuleFlowContentModelTransferNode(((ForEachNode)node).getNodes()) : (type == TransferNode.Type.COMPOSITE ? this.createRuleFlowContentModelTransferNode(((CompositeNode)node).getNodes()) : new TransferNode()))));
            this.createConnections(model, node);
            tn.setId(node.getId());
            tn.setX(((Integer)node.getMetaData("x")).intValue());
            tn.setY(((Integer)node.getMetaData("y")).intValue());
            Integer height = (Integer)node.getMetaData("height");
            if (height != null) {
                tn.setHeight(height.intValue());
            }
            if ((width = (Integer)node.getMetaData("width")) != null) {
                tn.setWidth(width.intValue());
            }
            tn.setName(node.getName());
            tn.setType(type);
            transferNodes.add((TransferNode)tn);
        }
        return transferNodes;
    }

    private ElementContainerTransferNode createRuleFlowContentModelTransferNode(Node[] nodes) {
        ElementContainerTransferNode fetn = new ElementContainerTransferNode();
        RuleFlowContentModel model = new RuleFlowContentModel();
        List transferNodes = this.createNodesAndConnections(nodes, model);
        model.setNodes(transferNodes);
        fetn.setContentModel(model);
        return fetn;
    }

    private void createConnections(RuleFlowContentModel model, Node node) {
        for (List inConnections : node.getIncomingConnections().values()) {
            for (Connection connection : inConnections) {
                this.createConnection(model, connection);
            }
        }
        for (List outConnections : node.getOutgoingConnections().values()) {
            for (Connection connection : outConnections) {
                this.createConnection(model, connection);
            }
        }
    }

    private void createConnection(RuleFlowContentModel model, Connection connection) {
        TransferConnection tc = new TransferConnection();
        tc.setFromId(connection.getFrom().getId());
        tc.setToId(connection.getTo().getId());
        model.getConnections().add(tc);
    }

    private TransferNode createHumanTaskTransferNode(HumanTaskNode node) {
        HumanTaskTransferNode httn = new HumanTaskTransferNode();
        Work work = node.getWork();
        if (work != null) {
            for (String key : work.getParameters().keySet()) {
                Object o = work.getParameters().get(key);
                String value = o == null ? "" : o.toString();
                httn.getParameters().put(key, value);
            }
        }
        return httn;
    }

    private SplitTransferNode createSplitNode(Split s) {
        SplitTransferNode sn = new SplitTransferNode();
        sn.setSplitType(SplitTransferNode.Type.getType((int)s.getType()));
        for (Split.ConnectionRef connection : s.getConstraints().keySet()) {
            SplitNode.ConnectionRef ref = new SplitNode.ConnectionRef();
            ref.setNodeId(connection.getNodeId());
            ref.setToType(connection.getToType());
            SplitNode.Constraint constraint = this.getConstraint((Constraint)s.getConstraints().get(connection));
            sn.getConstraints().put(ref, constraint);
        }
        return sn;
    }

    private WorkItemTransferNode createWorkItemTransfernode(WorkItemNode node) {
        WorkItemTransferNode tn = new WorkItemTransferNode();
        Work work = node.getWork();
        if (work != null) {
            tn.setWorkName(work.getName());
            for (String key : work.getParameters().keySet()) {
                Object o = work.getParameters().get(key);
                String value = o == null ? "" : o.toString();
                tn.getParameters().put(key, value);
            }
        }
        return tn;
    }

    private SplitNode.Constraint getConstraint(Constraint constraint) {
        SplitNode.Constraint c = new SplitNode.Constraint();
        c.setConstraint(constraint.getConstraint());
        c.setDialect(constraint.getDialect());
        c.setName(constraint.getName());
        c.setPriority(constraint.getPriority());
        c.setType(constraint.getType());
        return c;
    }

    private TransferNode.Type getType(Node node) {
        if (node instanceof StartNode) {
            return TransferNode.Type.START;
        }
        if (node instanceof EndNode) {
            return TransferNode.Type.END;
        }
        if (node instanceof ActionNode) {
            return TransferNode.Type.ACTION_NODE;
        }
        if (node instanceof RuleSetNode) {
            return TransferNode.Type.RULESET;
        }
        if (node instanceof SubProcessNode) {
            return TransferNode.Type.SUB_PROCESS;
        }
        if (node instanceof ForEachNode) {
            return TransferNode.Type.FOR_EACH;
        }
        if (node instanceof CompositeNode) {
            return TransferNode.Type.COMPOSITE;
        }
        if (node instanceof Join) {
            return TransferNode.Type.JOIN;
        }
        if (node instanceof Split) {
            return TransferNode.Type.SPLIT;
        }
        if (node instanceof MilestoneNode) {
            return TransferNode.Type.MILESTONE;
        }
        if (node instanceof TimerNode) {
            return TransferNode.Type.TIMER;
        }
        if (node instanceof HumanTaskNode) {
            return TransferNode.Type.HUMANTASK;
        }
        if (node instanceof WorkItemNode) {
            return TransferNode.Type.WORK_ITEM;
        }
        if (node instanceof FaultNode) {
            return TransferNode.Type.FAULT;
        }
        if (node instanceof EventNode) {
            return TransferNode.Type.EVENT;
        }
        throw new IllegalArgumentException("Unkown node type " + node);
    }
}

