/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.repository;

import javax.jcr.Credentials;
import javax.jcr.LoginException;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import org.drools.repository.JCRRepositoryConfigurator;
import org.drools.repository.JackrabbitRepositoryConfigurator;
import org.drools.repository.RulesRepositoryAdministrator;
import org.drools.repository.RulesRepositoryException;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.Destroy;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.Startup;

@Scope(value=ScopeType.APPLICATION)
@Startup
@Name(value="repositoryConfiguration")
public class BRMSRepositoryConfiguration {
    JCRRepositoryConfigurator configurator = new JackrabbitRepositoryConfigurator();
    String repositoryHomeDirectory = null;
    Repository repository;
    private Session sessionForSetup;

    @Create
    public void create() {
        this.repository = this.configurator.getJCRRepository(this.repositoryHomeDirectory);
        this.sessionForSetup = this.newSession("admin");
        this.create(this.sessionForSetup);
    }

    void create(Session sessionForSetup) {
        RulesRepositoryAdministrator admin = new RulesRepositoryAdministrator(sessionForSetup);
        if (!admin.isRepositoryInitialized()) {
            this.configurator.setupRulesRepository(sessionForSetup);
        }
    }

    @Destroy
    public void close() {
        this.sessionForSetup.logout();
    }

    public void setHomeDirectory(String home) {
        this.repositoryHomeDirectory = home;
    }

    public void setRepositoryConfigurator(String clazz) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class<?> cls = Class.forName(clazz);
        this.configurator = (JCRRepositoryConfigurator)cls.newInstance();
    }

    public Session newSession(String userName) {
        try {
            return this.repository.login((Credentials)new SimpleCredentials(userName, "password".toCharArray()));
        }
        catch (LoginException e) {
            throw new RulesRepositoryException("Unable to login to JCR backend.");
        }
        catch (RepositoryException e) {
            throw new RulesRepositoryException((Throwable)e);
        }
    }
}

